/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class LDScoreboard
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("teams", "scoreboard", "board");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.scoreboard";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        Scoreboard board;
        Team team;
        Player player;
        if (DisguiseConfig.isScoreboardDisguiseNames()) {
            int issuesFound = 0;
            int unexpected = 0;
            for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
                for (Disguise disguise : disguises) {
                    if (!disguise.isPlayerDisguise()) continue;
                    if (!((PlayerDisguise)disguise).hasScoreboardName()) {
                        if (unexpected++ >= 3) continue;
                        sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName() + " isn't using a scoreboard name? This is unexpected");
                        continue;
                    }
                    ArrayList<Scoreboard> checked = new ArrayList<Scoreboard>();
                    for (Player player2 : Bukkit.getOnlinePlayers()) {
                        Scoreboard board2 = player2.getScoreboard();
                        if (checked.contains(board2)) continue;
                        checked.add(board2);
                        DisguiseUtilities.DScoreTeam scoreboardName = ((PlayerDisguise)disguise).getScoreboardName();
                        Team team2 = board2.getTeam(scoreboardName.getTeamName());
                        if (team2 == null) {
                            if (issuesFound++ >= 5) continue;
                            sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName() + " is missing a scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " and possibly more players!");
                            continue;
                        }
                        if (!team2.getPrefix().equals(scoreboardName.getPrefix()) || !team2.getSuffix().equals(scoreboardName.getSuffix())) {
                            if (issuesFound++ >= 5) continue;
                            sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName() + " on scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " has an unexpected prefix/suffix of '" + team2.getPrefix() + "' & '" + team2.getSuffix() + "'!");
                            continue;
                        }
                        if (team2.hasEntry(scoreboardName.getPlayer()) || issuesFound++ >= 5) continue;
                        sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName() + " on scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " does not have the player entry expected! Instead has '" + StringUtils.join((Collection)team2.getEntries(), (String)", ").replace('\u00a7', '&') + "'");
                    }
                }
            }
            if (issuesFound == 0) {
                sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NO_ISSUES.get(new Object[0]));
            } else {
                sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_ISSUES.get(issuesFound));
            }
        } else {
            sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NAMES_DISABLED.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_IGNORE_TEST.get(new Object[0]));
        if (DisguiseConfig.getPushingOption() == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
            sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_DISABLED.get(new Object[0]));
        }
        if (args.length > 1) {
            player = Bukkit.getPlayer((String)args[1]);
            if (player == null) {
                sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[1]));
                return;
            }
            if (!DisguiseAPI.isDisguised((Entity)player)) {
                sender.sendMessage(LibsMsg.DMODPLAYER_NODISGUISE.get(player.getName()));
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
            if (!DisguiseAPI.isDisguised((Entity)player)) {
                sender.sendMessage(LibsMsg.NOT_DISGUISED.get(new Object[0]));
                return;
            }
        } else {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return;
        }
        if ((team = (board = player.getScoreboard()).getEntryTeam(sender.getName())) == null) {
            sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NO_TEAM.get(new Object[0]));
            return;
        }
        if (team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER && team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.FOR_OTHER_TEAMS) {
            sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NO_TEAM_PUSH.get(team.getName()));
            return;
        }
        sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_SUCCESS.get(team.getName()));
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_SCOREBOARD;
    }
}

