/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.commands.interactions.DisguiseEntityInteraction;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise testDisguise;
        if (this.isNotPremium(sender)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (!this.getPermissions(sender).hasPermissions()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        String[] disguiseArgs = DisguiseUtilities.split(StringUtils.join((Object[])args, (String)" "));
        try {
            testDisguise = DisguiseParser.parseTestDisguise(sender, this.getPermNode(), disguiseArgs, this.getPermissions(sender));
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ex.printStackTrace();
            return true;
        }
        LibsDisguises.getInstance().getListener().addInteraction(sender.getName(), new DisguiseEntityInteraction(disguiseArgs), DisguiseConfig.getDisguiseEntityExpire());
        sender.sendMessage(LibsMsg.DISG_ENT_CLICK.get(DisguiseConfig.getDisguiseEntityExpire(), testDisguise.getDisguiseName()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return tabs;
        }
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        return this.filterTabs(this.getTabDisguiseTypes(sender, perms, args, 0, this.getCurrentArg(origArgs)), origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        sender.sendMessage(LibsMsg.DISG_ENT_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.CAN_USE_DISGS.get(StringUtils.join(allowedDisguises, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0]))));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(LibsMsg.DISG_ENT_HELP3.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.DISG_ENT_HELP4.get(new Object[0]));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(LibsMsg.DISG_ENT_HELP5.get(new Object[0]));
        }
    }
}

