/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerMain
extends PacketAdapter {
    public PacketListenerMain(LibsDisguises plugin, ArrayList<PacketType> packetsToListen) {
        super((Plugin)plugin, ListenerPriority.HIGH, packetsToListen);
    }

    public void onPacketSending(PacketEvent event) {
        LibsPackets packets;
        if (event.isCancelled()) {
            return;
        }
        Player observer = event.getPlayer();
        if (observer.getName().contains("UNKNOWN[")) {
            return;
        }
        int entityId = (Integer)event.getPacket().getIntegers().read(PacketType.Play.Server.COLLECT == event.getPacketType() ? 1 : 0);
        Disguise disguise = DisguiseUtilities.getDisguise(observer, entityId);
        if (disguise == null || disguise.getEntity() == observer) {
            return;
        }
        try {
            packets = PacketsManager.getPacketsHandler().transformPacket(event.getPacket(), disguise, observer, disguise.getEntity());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            event.setCancelled(true);
            return;
        }
        if (packets.isUnhandled()) {
            return;
        }
        event.setCancelled(true);
        try {
            for (PacketContainer packet : packets.getPackets()) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
            }
            packets.sendDelayed(observer);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

