/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LibsPackets {
    private ArrayList<PacketContainer> packets = new ArrayList();
    private HashMap<Integer, ArrayList<PacketContainer>> delayedPackets = new HashMap();
    private Disguise disguise;
    private boolean doNothing;

    public LibsPackets(Disguise disguise) {
        this.disguise = disguise;
    }

    public void setUnhandled() {
        this.doNothing = true;
    }

    public boolean isUnhandled() {
        return this.doNothing;
    }

    public Disguise getDisguise() {
        return this.disguise;
    }

    public void addPacket(PacketContainer packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketContainer packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketContainer packet, int ticksDelayed) {
        if (!this.delayedPackets.containsKey(ticksDelayed)) {
            this.delayedPackets.put(ticksDelayed, new ArrayList());
        }
        this.delayedPackets.get(ticksDelayed).add(packet);
    }

    public ArrayList<PacketContainer> getPackets() {
        return this.packets;
    }

    public Collection<ArrayList<PacketContainer>> getDelayedPackets() {
        return this.delayedPackets.values();
    }

    public void sendDelayed(Player observer) {
        for (Map.Entry<Integer, ArrayList<PacketContainer>> entry : this.delayedPackets.entrySet()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (!this.disguise.isDisguiseInUse()) {
                    ArrayList packets = (ArrayList)entry.getValue();
                    if (packets.stream().noneMatch(p -> p.getType() == PacketType.Play.Server.PLAYER_INFO)) {
                        return;
                    }
                    packets.removeIf(p -> p.getType() != PacketType.Play.Server.PLAYER_INFO);
                }
                try {
                    for (PacketContainer packet : (ArrayList)entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }, (long)entry.getKey().intValue());
        }
    }

    private PacketContainer createPacket(EquipmentSlot slot) {
        ItemStack itemToSend = this.disguise.getWatcher().getItemStack(slot);
        if (itemToSend == null ? (itemToSend = ReflectionManager.getEquipment(slot, this.disguise.getEntity())) == null || itemToSend.getType() == Material.AIR : itemToSend.getType() == Material.AIR) {
            return null;
        }
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        StructureModifier mods = packet.getModifier();
        mods.write(0, (Object)this.disguise.getEntity().getEntityId());
        mods.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
        mods.write(2, ReflectionManager.getNmsItem(itemToSend));
        return packet;
    }
}

