/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.plugin.BisectHosting;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.FileUtil;

public class LibsPremium {
    private static Boolean thisPluginIsPaidFor;
    private static PluginInformation pluginInformation;
    private static PluginInformation paidInformation;
    private static boolean bisectHosted;

    public static PluginInformation getPluginInformation() {
        return pluginInformation;
    }

    public static PluginInformation getPaidInformation() {
        return paidInformation;
    }

    public static String getUserID() {
        return "%%__USER__%%";
    }

    public static String getResourceID() {
        return "%%__RESOURCE__%%";
    }

    public static String getDownloadID() {
        return "%%__NONCE__%%";
    }

    private static Boolean isPremium(String resourceID, String userID) {
        return !userID.contains("__USER__") && !resourceID.equals("81");
    }

    public static Boolean isAPIPlugin() {
        return LibsPremium.isPremium() == false && LibsPremium.getResourceID().equals("81");
    }

    public static Boolean isPremium() {
        return thisPluginIsPaidFor == null ? LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID()) : thisPluginIsPaidFor;
    }

    private static boolean isValidVersion(String currentVersion, String premiumVersion) {
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (!premiumVersion.matches("[0-9]+(\\.[0-9]+)+")) {
            return false;
        }
        if (premiumVersion.startsWith("9.")) {
            return false;
        }
        if (!currentVersion.matches("[0-9]+(\\.[0-9]+)+")) {
            return true;
        }
        String[] currentSplit = currentVersion.split("\\.");
        String[] premSplit = premiumVersion.split("\\.");
        return Integer.parseInt(currentSplit[0]) <= Integer.parseInt(premSplit[0]);
    }

    private static PluginInformation getInformation(File file) throws Exception {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Boolean premium;
            Class<?> c = cl.loadClass(LibsPremium.class.getName());
            boolean oldJarFile = true;
            try {
                c.getMethod("getUserID", new Class[0]);
                oldJarFile = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            YamlConfiguration config = ReflectionManager.getPluginYAML(file);
            String userId = null;
            String downloadId = null;
            String resourceId = null;
            if (oldJarFile) {
                premium = (Boolean)c.getMethod("isPremium", new Class[0]).invoke(null, new Object[0]);
            } else {
                userId = (String)c.getMethod("getUserID", new Class[0]).invoke(null, new Object[0]);
                resourceId = (String)c.getMethod("getResourceID", new Class[0]).invoke(null, new Object[0]);
                downloadId = (String)c.getMethod("getDownloadID", new Class[0]).invoke(null, new Object[0]);
                premium = LibsPremium.isPremium(resourceId, userId);
            }
            String pluginBuildDate = "??/??/????";
            if (config.contains("build-date")) {
                pluginBuildDate = config.getString("build-date");
            }
            String pluginBuildNumber = "???";
            if (config.contains("build-number") && (pluginBuildNumber = config.getString("build-number")).matches("[0-9]+")) {
                pluginBuildNumber = "#" + pluginBuildNumber;
            }
            String pluginVersion = config.getString("version");
            PluginInformation pluginInformation = new PluginInformation(userId, resourceId, downloadId, premium, pluginVersion, pluginBuildNumber, pluginBuildDate);
            return pluginInformation;
        }
    }

    private static void doSecondaryCheck(String version) {
        File[] files = new File("plugins/LibsDisguises/").listFiles();
        boolean foundJar = false;
        if (files == null) {
            return;
        }
        for (File file : files) {
            PluginInformation plugin;
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            foundJar = true;
            try {
                plugin = LibsPremium.getInformation(file);
            }
            catch (ClassNotFoundException ex) {
                DisguiseUtilities.getLogger().warning("Found an unrecognized jar in the LibsDisguises folder (" + file.getName() + ")");
                continue;
            }
            catch (Exception ex) {
                DisguiseUtilities.getLogger().warning("Error while trying to handle the file " + file.getName());
                ex.printStackTrace();
                continue;
            }
            String fileInfo = String.format("v%s, build %s, created %s", plugin.getVersion(), plugin.getBuildNumber(), plugin.getBuildDate());
            if (plugin.isPremium()) {
                if (!LibsPremium.isValidVersion(version, plugin.getVersion()) || plugin.getUserID() == null || plugin.getDownloadID() == null || plugin.getUserID().equals("666666")) {
                    DisguiseUtilities.getLogger().warning("You have an old Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder! For security purposes, please replace this with a new version from SpigotMC - https://www.spigotmc.org/resources/libs-disguises.32453/");
                    continue;
                }
                paidInformation = plugin;
                thisPluginIsPaidFor = true;
                DisguiseUtilities.getLogger().info("Found a premium Lib's Disguises jar (" + fileInfo + ")");
                DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(plugin.getUserID()));
                break;
            }
            DisguiseUtilities.getLogger().warning("You have a non-premium Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder!");
            DisguiseUtilities.getLogger().warning("Please place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in here!");
        }
        if (!foundJar) {
            bisectHosted = new BisectHosting().isBisectHosted("LibsDisguises");
            if (bisectHosted) {
                DisguiseUtilities.getLogger().info("Hosted by BisectHosting! Premium enabled!");
                paidInformation = new PluginInformation("0", "32453", "0", true, "0", "#0", "0");
                thisPluginIsPaidFor = true;
            } else {
                DisguiseUtilities.getLogger().warning("If you own the plugin, place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in plugins/LibsDisguises/");
            }
        }
    }

    private static String getSanitizedUser(String userID) {
        if (userID == null) {
            return "N/A";
        }
        if (!userID.matches("[0-9]+")) {
            return String.format("... %s? Am I reading this right?", userID);
        }
        int total = 0;
        for (char c : userID.toCharArray()) {
            total += Character.getNumericValue(c);
        }
        return String.format("%s (%s)", userID, total);
    }

    /*
     * WARNING - void declaration
     */
    public static void check(String version, File file) {
        thisPluginIsPaidFor = LibsPremium.isPremium();
        try {
            pluginInformation = LibsPremium.getInformation(file);
        }
        catch (Exception e) {
            void var3_7;
            String string = "??/??/????";
            YamlConfiguration config = new YamlConfiguration();
            try {
                try (InputStream stream = LibsDisguises.getInstance().getResource("plugin.yml");){
                    config.loadFromString(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                }
                if (config.contains("build-date")) {
                    String string2 = config.getString("build-date");
                }
            }
            catch (IOException | InvalidConfigurationException ex) {
                ex.printStackTrace();
            }
            String buildNo = LibsDisguises.getInstance().getBuildNo();
            if (buildNo != null && buildNo.matches("[0-9]+")) {
                buildNo = "#" + buildNo;
            }
            pluginInformation = new PluginInformation(LibsPremium.getUserID(), LibsPremium.getResourceID(), LibsPremium.getDownloadID(), LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID()), version, buildNo, (String)var3_7);
        }
        if (!LibsPremium.isPremium().booleanValue() || !LibsDisguises.getInstance().isReleaseBuild()) {
            LibsPremium.doSecondaryCheck(version);
        } else {
            DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(LibsPremium.getUserID()));
            boolean foundBetter = false;
            for (File f : LibsDisguises.getInstance().getDataFolder().listFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".jar")) continue;
                try {
                    PluginInformation info = LibsPremium.getInformation(f);
                    if (info.getBuildNumber() == null || !info.getBuildNumber().matches("#[0-9]+")) {
                        f.delete();
                        DisguiseUtilities.getLogger().info("Ew, I don't recognize " + f.getName());
                        continue;
                    }
                    if (Integer.parseInt(info.getBuildNumber().replace("#", "")) < Integer.parseInt(LibsDisguises.getInstance().getBuildNo().replace("#", ""))) {
                        f.delete();
                        DisguiseUtilities.getLogger().info("Ew, " + f.getName() + " is so old");
                        continue;
                    }
                    if (!info.isLegit()) {
                        f.delete();
                        DisguiseUtilities.getLogger().info("Ew, I saw something nasty in " + f.getName());
                        continue;
                    }
                    foundBetter = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!foundBetter) {
                File file2 = LibsDisguises.getInstance().getFile();
                FileUtil.copy((File)file2, (File)new File(LibsDisguises.getInstance().getDataFolder(), file2.getName()));
                DisguiseUtilities.getLogger().info("Copied " + file2.getName() + " to the plugin folder! You can use dev builds with premium enabled!");
            }
        }
        if (LibsPremium.isPremium().booleanValue()) {
            boolean prem = LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation().isLegit() : LibsPremium.getPaidInformation().isLegit();
            DisguiseUtilities.getLogger().info("Premium enabled, thank you for supporting Lib's Disguises!" + (!prem ? "!" : ""));
        }
    }

    public static boolean isBisectHosted() {
        return bisectHosted;
    }
}

