/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import java.security.InvalidParameterException;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.DroppedItemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PaintingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SplashPotionWatcher;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MiscDisguise
extends TargetedDisguise {
    private int id = -1;
    private int data = 0;

    public MiscDisguise(DisguiseType disguiseType) {
        this(disguiseType, -1, disguiseType.getDefaultData());
    }

    public MiscDisguise(DisguiseType disguiseType, Material material, int data) {
        this(disguiseType, new ItemStack(material, 1, (short)data));
    }

    public MiscDisguise(DisguiseType disguiseType, ItemStack itemStack) {
        super(disguiseType);
        if (disguiseType != DisguiseType.FALLING_BLOCK && disguiseType != DisguiseType.DROPPED_ITEM) {
            throw new IllegalArgumentException("This constructor requires a DROPPED_ITEM or FALLING_BLOCK disguise type!");
        }
        this.apply(0, itemStack);
    }

    public MiscDisguise(DisguiseType disguiseType, Material material) {
        super(disguiseType);
        if (disguiseType != DisguiseType.FALLING_BLOCK && disguiseType != DisguiseType.DROPPED_ITEM) {
            throw new IllegalArgumentException("This constructor requires a DROPPED_ITEM or FALLING_BLOCK disguise type!");
        }
        this.apply(0, new ItemStack(material));
    }

    public MiscDisguise(DisguiseType disguiseType, int id) {
        this(disguiseType, id, disguiseType.getDefaultData());
    }

    @Deprecated
    public MiscDisguise(DisguiseType disguiseType, int id, int data) {
        super(disguiseType);
        if (!disguiseType.isMisc()) {
            throw new InvalidParameterException("Expected a non-living DisguiseType while constructing MiscDisguise. Received " + (Object)((Object)disguiseType) + " instead. Please use " + (disguiseType.isPlayer() ? "PlayerDisguise" : "MobDisguise") + " instead");
        }
        this.apply(id, new ItemStack(Material.STONE));
    }

    private void apply(int id, ItemStack itemStack) {
        this.createDisguise();
        this.id = this.getType().getTypeId();
        this.data = this.getType().getDefaultData();
        switch (this.getType()) {
            case PAINTING: {
                ((PaintingWatcher)this.getWatcher()).setArt(Art.values()[Math.max(0, id) % Art.values().length]);
                break;
            }
            case FALLING_BLOCK: {
                ((FallingBlockWatcher)this.getWatcher()).setBlock(itemStack);
                break;
            }
            case SPLASH_POTION: {
                ((SplashPotionWatcher)this.getWatcher()).setPotionId(Math.max(0, id));
                break;
            }
            case DROPPED_ITEM: {
                ((DroppedItemWatcher)this.getWatcher()).setItemStack(itemStack);
                break;
            }
            case FISHING_HOOK: 
            case ARROW: 
            case SPECTRAL_ARROW: 
            case SMALL_FIREBALL: 
            case FIREBALL: 
            case WITHER_SKULL: 
            case TRIDENT: {
                this.data = id;
                break;
            }
        }
    }

    @Override
    public MiscDisguise addPlayer(Player player) {
        return (MiscDisguise)super.addPlayer(player);
    }

    @Override
    public MiscDisguise addPlayer(String playername) {
        return (MiscDisguise)super.addPlayer(playername);
    }

    @Override
    public MiscDisguise clone() {
        MiscDisguise disguise = new MiscDisguise(this.getType(), this.getData());
        this.clone(disguise);
        return disguise;
    }

    public int getData() {
        switch (this.getType()) {
            case FALLING_BLOCK: {
                return ((FallingBlockWatcher)this.getWatcher()).getBlock().getDurability();
            }
            case PAINTING: {
                return ((PaintingWatcher)this.getWatcher()).getArt().getId();
            }
            case SPLASH_POTION: {
                return ((SplashPotionWatcher)this.getWatcher()).getPotionId();
            }
        }
        return this.data;
    }

    public int getId() {
        if (this.getType() == DisguiseType.FALLING_BLOCK) {
            return ((FallingBlockWatcher)this.getWatcher()).getBlock().getType().ordinal();
        }
        return this.id;
    }

    @Override
    public boolean isMiscDisguise() {
        return true;
    }

    @Override
    public MiscDisguise removePlayer(Player player) {
        return (MiscDisguise)super.removePlayer(player);
    }

    @Override
    public MiscDisguise removePlayer(String playername) {
        return (MiscDisguise)super.removePlayer(playername);
    }

    @Override
    public MiscDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (MiscDisguise)super.setDisguiseTarget(newTargetType);
    }

    @Override
    public MiscDisguise setEntity(Entity entity) {
        return (MiscDisguise)super.setEntity(entity);
    }

    @Override
    public MiscDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (MiscDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public MiscDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (MiscDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public MiscDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (MiscDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public MiscDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (MiscDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public MiscDisguise setModifyBoundingBox(boolean modifyBox) {
        return (MiscDisguise)super.setModifyBoundingBox(modifyBox);
    }

    @Override
    public MiscDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (MiscDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    @Override
    public MiscDisguise setVelocitySent(boolean sendVelocity) {
        return (MiscDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public MiscDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (MiscDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public MiscDisguise setWatcher(FlagWatcher newWatcher) {
        return (MiscDisguise)super.setWatcher(newWatcher);
    }

    @Override
    public MiscDisguise silentlyAddPlayer(String playername) {
        return (MiscDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public MiscDisguise silentlyRemovePlayer(String playername) {
        return (MiscDisguise)super.silentlyRemovePlayer(playername);
    }
}

