/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import java.util.Arrays;
import java.util.Locale;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.reflection.ItemStackSerializer;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ParamInfoItemStack<I extends ItemStack>
extends ParamInfoEnum<Object> {
    public ParamInfoItemStack(Class paramClass, String name, String valueType, String description, Enum[] possibleValues) {
        super(paramClass, name, valueType, description, (T[])possibleValues);
        this.setOtherValues("null", "%held-item%", "%offhand-item%", "%helmet%", "%chestplate%", "%leggings%", "%boots%");
    }

    @Override
    public boolean canTranslateValues() {
        return false;
    }

    @Override
    public boolean canReturnNull() {
        return true;
    }

    @Override
    public Object fromString(String string) {
        return ParamInfoItemStack.parseToItemstack(string);
    }

    @Override
    public String toString(Object object) {
        ItemStack item = (ItemStack)object;
        ItemStack temp = new ItemStack(item.getType(), item.getAmount());
        if (item.containsEnchantment(DisguiseUtilities.getDurabilityEnchantment())) {
            temp.addUnsafeEnchantment(DisguiseUtilities.getDurabilityEnchantment(), 1);
        }
        if (temp.isSimilar(item)) {
            String name = item.getType().name();
            if (item.getAmount() != 1) {
                name = name + ":" + item.getAmount();
            }
            if (item.containsEnchantment(DisguiseUtilities.getDurabilityEnchantment())) {
                name = name + ":" + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow");
            }
            if (NmsVersion.v1_14.isSupported() && item.getItemMeta().hasCustomModelData()) {
                name = name + ":custom_model_" + item.getItemMeta().getCustomModelData();
            }
            return name;
        }
        return StringUtils.join(ItemStackSerializer.serialize(item), (String)"-");
    }

    protected static ItemStack parseToItemstack(String string) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            try {
                return (ItemStack)DisguiseUtilities.getGson().fromJson(string, ItemStack.class);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException();
            }
        }
        if (!string.matches("[a-zA-Z0-9_:,]+")) {
            String materialName;
            String[] split;
            if (!NmsVersion.v1_20_R4.isSupported()) {
                if (string.matches("^[^{]+?[ -]\\{[.].+?}$")) {
                    split = string.substring(0, string.indexOf("{") - 1).split("[ -]");
                    split = Arrays.copyOf(split, split.length + 1);
                    split[split.length - 1] = string.substring(string.indexOf("{"));
                } else if (string.matches("^[^{ -]+?\\{.+?}([ -][0-9]+)?$")) {
                    split = new String[string.endsWith("}") ? 2 : 3];
                    split[0] = string.substring(0, string.indexOf("{"));
                    split[string.endsWith((String)"}") ? 1 : 2] = string.substring(string.indexOf("{"), string.lastIndexOf("}") + 1);
                    if (!string.endsWith("}")) {
                        split[1] = string.substring(string.lastIndexOf(" ") + 1);
                    }
                } else {
                    split = string.split("[ -]");
                }
                materialName = split[0];
            } else {
                split = string.split(" (?=\\d+)");
                materialName = split[0];
                if (materialName.contains("[")) {
                    materialName = materialName.substring(0, materialName.indexOf("["));
                }
            }
            Material material = ReflectionManager.getMaterial(materialName.toUpperCase(Locale.ENGLISH));
            if (material == null) {
                material = Material.getMaterial((String)materialName.toUpperCase(Locale.ENGLISH));
            }
            ItemStack itemStack = ParamInfoItemStack.getItemStack(material, split);
            String s = split[split.length - 1];
            if (NmsVersion.v1_20_R4.isSupported()) {
                s = split[0];
            }
            if (s.contains("{") || s.contains("[")) {
                ItemStack clone = itemStack.clone();
                Bukkit.getUnsafe().modifyItemStack(itemStack, s);
                if (DisguiseUtilities.isDebuggingMode() && itemStack.equals((Object)clone)) {
                    LibsDisguises.getInstance().getLogger().info("Potential error when trying to modify an item via Bukkit Unsafe. Item Type: " + clone.getType() + ", Data: '" + s + "'");
                }
            }
            return itemStack;
        }
        return ParamInfoItemStack.parseToItemstack(string.split("[:,]"));
    }

    @NotNull
    private static ItemStack getItemStack(Material material, String[] split) {
        if (material == null || material == Material.AIR && !split[0].equalsIgnoreCase("air")) {
            throw new IllegalArgumentException();
        }
        int amount = split.length > 1 && split[1].matches("[0-9]+") ? Integer.parseInt(split[1]) : 1;
        ItemStack itemStack = !NmsVersion.v1_13.isSupported() && split.length > 2 && split[2].matches("[0-9]+") ? new ItemStack(material, amount, Short.parseShort(split[2])) : new ItemStack(material, amount);
        return itemStack;
    }

    protected static ItemStack parseToItemstack(String[] split) {
        if (split[0].isEmpty() || split[0].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("null"))) {
            return null;
        }
        Material material = ReflectionManager.getMaterial(split[0].toUpperCase(Locale.ENGLISH));
        if (material == null) {
            material = Material.getMaterial((String)split[0].toUpperCase(Locale.ENGLISH));
        }
        if (material == null || material == Material.AIR && !split[0].equalsIgnoreCase("air")) {
            throw new IllegalArgumentException();
        }
        Integer amount = null;
        boolean enchanted = false;
        Integer customModel = null;
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            if (!enchanted && s.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow"))) {
                enchanted = true;
                continue;
            }
            if (s.matches("\\d+") && amount == null) {
                amount = Integer.parseInt(s);
                continue;
            }
            if (NmsVersion.v1_14.isSupported() && s.toLowerCase(Locale.ENGLISH).matches("^custom_model_-?\\d+$")) {
                customModel = Integer.parseInt(s.split("_", 3)[2]);
                continue;
            }
            throw new IllegalArgumentException();
        }
        ItemStack itemStack = new ItemStack(material, amount == null ? 1 : amount);
        if (enchanted) {
            itemStack.addUnsafeEnchantment(DisguiseUtilities.getDurabilityEnchantment(), 1);
        }
        if (customModel != null) {
            itemStack.getItemMeta().setCustomModelData(customModel);
        }
        return itemStack;
    }

    @Override
    public boolean isParam(Class paramClass) {
        return this.getParamClass().isAssignableFrom(paramClass);
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

