/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketLoginReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.login.client.WrapperLoginClientLoginStart;
import com.github.retrooper.packetevents.wrapper.login.client.WrapperLoginClientPluginResponse;
import com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerPluginRequest;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;

public class PacketListenerModdedClient
extends SimplePacketListenerAbstract {
    private final Cache<String, WrapperLoginClientLoginStart> loginAttempts = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private static final int packetId1 = 5555554;
    private static final int packetId2 = 5555555;

    private int getInt(ByteBuf buf) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    private void handleModlist(String name, byte[] data) {
        ByteBuf buf = Unpooled.copiedBuffer((byte[])data);
        int packetId = this.getInt(buf);
        if (packetId != 2) {
            return;
        }
        int count = this.getInt(buf);
        ArrayList<String> mods = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            mods.add(this.getString(buf));
        }
        ModdedManager.getForgeMods().put((Object)name, mods);
    }

    public String getString(ByteBuf buf) {
        int size;
        int j = this.getInt(buf);
        if (j > (size = 256) * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + j + " > " + size * 4 + ")");
        }
        if (j < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = buf.toString(buf.readerIndex(), j, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + j);
        if (s.length() > size) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + j + " > " + size + ")");
        }
        return s;
    }

    public void onPacketLoginReceive(PacketLoginReceiveEvent event) {
        if (event.getPacketType() != PacketType.Login.Client.LOGIN_PLUGIN_RESPONSE && event.getPacketType() != PacketType.Login.Client.LOGIN_START) {
            return;
        }
        event.setCancelled(true);
        if (event.getPacketType() == PacketType.Login.Client.LOGIN_PLUGIN_RESPONSE) {
            String address = event.getSocketAddress().toString();
            WrapperLoginClientLoginStart startAttempt = (WrapperLoginClientLoginStart)this.loginAttempts.getIfPresent((Object)address);
            if (startAttempt == null) {
                return;
            }
            WrapperLoginClientPluginResponse wrapper = new WrapperLoginClientPluginResponse((PacketReceiveEvent)event);
            if (wrapper.getMessageId() == 5555554 && wrapper.isSuccessful()) {
                this.handleModlist(startAttempt.getUsername(), wrapper.getData());
            } else if (wrapper.getMessageId() == 5555555) {
                this.loginAttempts.invalidate((Object)address);
                PacketEvents.getAPI().getPlayerManager().receivePacketSilently(event.getPlayer(), (PacketWrapper)startAttempt);
            }
            return;
        }
        this.loginAttempts.put((Object)event.getSocketAddress().toString(), (Object)new WrapperLoginClientLoginStart((PacketReceiveEvent)event.clone()));
        WrapperLoginServerPluginRequest packet1 = new WrapperLoginServerPluginRequest(5555554, "fml:handshake", ModdedManager.getFmlHandshake());
        WrapperLoginServerPluginRequest packet2 = new WrapperLoginServerPluginRequest(5555555, "fml:handshake", ModdedManager.getFmlRegistries());
        PacketEvents.getAPI().getPlayerManager().sendPacket(event.getPlayer(), (PacketWrapper)packet1);
        PacketEvents.getAPI().getPlayerManager().sendPacket(event.getPlayer(), (PacketWrapper)packet2);
    }
}

