/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean debugging;
    private String apiKey;
    private static long lastErrorPage;
    private final String userAgent;

    public MineSkinAPI() {
        this("third-party");
    }

    public MineSkinAPI(String extraInfo) {
        extraInfo = extraInfo == null || extraInfo.trim().isEmpty() ? "" : (!extraInfo.contains("(") ? " (" + extraInfo.trim() + ")" : " " + extraInfo.trim());
        this.userAgent = "LibsDisguises/" + LibsDisguises.getInstance().getDescription().getVersion() + extraInfo;
    }

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback callback, String url, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/url", url, null, modelType);
    }

    private void printDebug(String message) {
        if (!this.isDebugging() || LibsDisguises.getInstance() == null) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info("[MineSkinAPI] " + message);
    }

    /*
     * Exception decompiling
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback callback, String path, String skinUrl, File file, SkinUtils.ModelType modelType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MineSkinResponse generateFromUUID(UUID uuid, SkinUtils.ModelType modelType) throws IllegalArgumentException {
        block18: {
            this.lock.lock();
            long sleep = this.nextRequest - System.currentTimeMillis();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            long nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
            try {
                MineSkinResponse mineSkinResponse;
                block17: {
                    String siteUrl = "https://api.mineskin.org/generate/user/:" + uuid.toString();
                    if (modelType == SkinUtils.ModelType.SLIM) {
                        siteUrl = siteUrl + "?model=slim";
                    }
                    URL url = new URL(siteUrl);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "LibsDisguises");
                    con.setDoOutput(true);
                    InputStream input = con.getInputStream();
                    try {
                        String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                        nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
                        con.disconnect();
                        mineSkinResponse = skinResponse;
                        if (input == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            if (ex.getMessage() != null && ex.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                                throw new IllegalArgumentException();
                            }
                            if (LibsDisguises.getInstance().getLogger() != null) {
                                LibsDisguises.getInstance().getLogger().warning("Failed to access MineSkin.org");
                            }
                            ex.printStackTrace();
                            break block18;
                        }
                    }
                    input.close();
                }
                return mineSkinResponse;
            }
            finally {
                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                this.lock.unlock();
            }
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback callback, File file, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/upload", null, file, modelType);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

