/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.bukkit.DyeColor;
import org.bukkit.entity.Wolf;

public class WolfWatcher
extends TameableWatcher {
    public WolfWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises() && NmsVersion.v1_20_R4.isSupported()) {
            this.setVariant(ReflectionManager.randomEnum(Wolf.Variant.class));
        }
    }

    public DyeColor getCollarColor() {
        return this.getData(MetaIndex.WOLF_COLLAR).getDyeColor();
    }

    @Deprecated
    public void setCollarColor(AnimalColor color) {
        this.setCollarColor(color.getDyeColor());
    }

    public void setCollarColor(DyeColor newColor) {
        if (!this.isTamed()) {
            this.setTamed(true);
        }
        if (this.hasValue(MetaIndex.WOLF_COLLAR) && newColor == this.getCollarColor()) {
            return;
        }
        this.sendData(MetaIndex.WOLF_COLLAR, AnimalColor.getColorByWool(newColor.getWoolData()));
    }

    public boolean isBegging() {
        return this.getData(MetaIndex.WOLF_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.sendData(MetaIndex.WOLF_BEGGING, begging);
    }

    public boolean isAngry() {
        if (!NmsVersion.v1_16.isSupported()) {
            return this.isTameableFlag(2);
        }
        return this.getAnger() > 0;
    }

    public void setAngry(boolean angry) {
        if (!NmsVersion.v1_16.isSupported()) {
            this.setTameableFlag(2, angry);
        } else {
            this.setAnger(angry ? 1 : 0);
        }
    }

    public int getAnger() {
        return this.getData(MetaIndex.WOLF_ANGER);
    }

    @NmsAddedIn(value=NmsVersion.v1_16)
    public void setAnger(int anger) {
        this.sendData(MetaIndex.WOLF_ANGER, anger);
    }

    @NmsRemovedIn(value=NmsVersion.v1_15)
    @Deprecated
    public float getDamageTaken() {
        return this.getData(MetaIndex.WOLF_DAMAGE).floatValue();
    }

    @Deprecated
    @NmsRemovedIn(value=NmsVersion.v1_15)
    public void setDamageTaken(float damage) {
        this.sendData(MetaIndex.WOLF_DAMAGE, Float.valueOf(damage));
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public void setVariant(Wolf.Variant variant) {
        this.sendData(MetaIndex.WOLF_VARIANT, variant);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public Wolf.Variant getVariant() {
        return this.getData(MetaIndex.WOLF_VARIANT);
    }
}

