/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.util.Vector3f;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import org.bukkit.util.EulerAngle;

public class ArmorStandWatcher
extends LivingWatcher {
    public ArmorStandWatcher(Disguise disguise) {
        super(disguise);
    }

    private boolean getArmorStandFlag(int value) {
        return (this.getData(MetaIndex.ARMORSTAND_META) & value) != 0;
    }

    public EulerAngle getBody() {
        return this.getPose(MetaIndex.ARMORSTAND_BODY);
    }

    @MethodDescription(value="The body rotation of the ArmorStand")
    public void setBody(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_BODY, vector);
    }

    public EulerAngle getHead() {
        return this.getPose(MetaIndex.ARMORSTAND_HEAD);
    }

    @MethodDescription(value="The head rotation of the ArmorStand")
    public void setHead(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_HEAD, vector);
    }

    public EulerAngle getLeftArm() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_ARM);
    }

    @MethodDescription(value="The left arm rotation of the ArmorStand")
    public void setLeftArm(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_ARM, vector);
    }

    public EulerAngle getLeftLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_LEG);
    }

    @MethodDescription(value="The left leg rotation of the ArmorStand")
    public void setLeftLeg(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_LEG, vector);
    }

    private EulerAngle getPose(MetaIndex<Vector3f> type) {
        if (!this.hasValue(type)) {
            return new EulerAngle(0.0, 0.0, 0.0);
        }
        Vector3f vec = this.getData(type);
        return new EulerAngle((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
    }

    public EulerAngle getRightArm() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_ARM);
    }

    @MethodDescription(value="The right arm rotation of the ArmorStand")
    public void setRightArm(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_ARM, vector);
    }

    public EulerAngle getRightLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_LEG);
    }

    @MethodDescription(value="The right leg rotation of the ArmorStand")
    public void setRightLeg(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_LEG, vector);
    }

    public boolean isMarker() {
        return this.getArmorStandFlag(16);
    }

    @MethodDescription(value="Can this ArmorStand be interacted with?")
    public void setMarker(boolean isMarker) {
        this.setArmorStandFlag(16, isMarker);
    }

    public boolean isNoBasePlate() {
        return this.getArmorStandFlag(8);
    }

    @MethodDescription(value="Does this ArmorStand have a base plate?")
    public void setNoBasePlate(boolean noBasePlate) {
        this.setArmorStandFlag(8, noBasePlate);
    }

    @Override
    public boolean isNoGravity() {
        return this.getArmorStandFlag(2);
    }

    @Override
    @MethodDescription
    public void setNoGravity(boolean noGravity) {
        this.setArmorStandFlag(2, noGravity);
    }

    public boolean isShowArms() {
        return this.getArmorStandFlag(4);
    }

    @MethodDescription(value="Can you see this ArmorStand's arms?")
    public void setShowArms(boolean showArms) {
        this.setArmorStandFlag(4, showArms);
    }

    public boolean isSmall() {
        return this.getArmorStandFlag(1);
    }

    @MethodDescription(value="Is this ArmorStand small?")
    public void setSmall(boolean isSmall) {
        this.setArmorStandFlag(1, isSmall);
    }

    private void setArmorStandFlag(int value, boolean isTrue) {
        byte b1 = this.getData(MetaIndex.ARMORSTAND_META);
        b1 = isTrue ? (byte)(b1 | value) : (byte)(b1 & ~value);
        this.sendData(MetaIndex.ARMORSTAND_META, b1);
    }

    private void setPose(MetaIndex<Vector3f> type, EulerAngle vector) {
        this.sendData(type, new Vector3f((float)vector.getX(), (float)vector.getY(), (float)vector.getZ()));
    }
}

