/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.reflection.ItemStackSerializer;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LDJson
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("json", "gson", "tostring", "item", "parse");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.json";
    }

    private Component createComponent(String text, int section, int max) {
        Component component = LibsMsg.CLICK_COPY.getAdv(section);
        component = NmsVersion.v1_15.isSupported() ? component.clickEvent(ClickEvent.copyToClipboard((String)text)) : component.clickEvent(ClickEvent.suggestCommand((String)text));
        LibsMsg hover = NmsVersion.v1_15.isSupported() ? LibsMsg.CLICK_TO_COPY_HOVER_CLIPBOARD : LibsMsg.CLICK_TO_COPY_HOVER;
        Component hoverText = hover.getAdv(section, max, DisguiseUtilities.getMiniMessage().escapeTags(text));
        component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
        return component;
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return;
        }
        ItemStack item = ((Player)sender).getInventory().getItemInMainHand();
        String gson = DisguiseUtilities.getGson().toJson((Object)item);
        String simple = ParamInfoManager.toString(item);
        String itemName = ReflectionManager.getItemName(item.getType());
        List<String> mcArray = ItemStackSerializer.serialize(item);
        String ldItem = StringUtils.join(mcArray, (String)"-");
        String mcItem = StringUtils.join(mcArray, (String)" ");
        this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED, LibsMsg.ITEM_SERIALIZED_NO_COPY, gson, false);
        if (!(gson.equals(simple) || ldItem.equals(simple) || mcItem.equals(simple))) {
            this.sendMessage(sender, LibsMsg.ITEM_SIMPLE_STRING, LibsMsg.ITEM_SIMPLE_STRING_NO_COPY, simple, false);
        }
        this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED_MC, LibsMsg.ITEM_SERIALIZED_MC_NO_COPY, mcItem, false);
        if (mcArray.size() > 1) {
            this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED_MC, LibsMsg.ITEM_SERIALIZED_MC_NO_COPY, ldItem, false);
        }
    }

    private void sendMessage(CommandSender sender, LibsMsg msg, LibsMsg oldVer, String string, boolean forceAbbrev) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append(msg.getAdv(new Object[0]))).appendSpace();
        if (string.length() > 256 || forceAbbrev) {
            int i;
            int i2;
            String[] split = DisguiseUtilities.split(string);
            for (i2 = 0; i2 < split.length; ++i2) {
                split[i2] = DisguiseUtilities.quote(split[i2]);
            }
            for (i2 = 0; i2 < split.length; ++i2) {
                if (split[i2].length() <= 256) continue;
                split = Arrays.copyOf(split, split.length + 1);
                for (int a = split.length - 1; a > i2; --a) {
                    split[a] = split[a - 1];
                }
                split[i2 + 1] = split[i2].substring(256);
                split[i2] = split[i2].substring(0, 256);
            }
            ArrayList<String> sections = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            for (i = 0; i < split.length; ++i) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(split[i]);
                if (split.length > i + 1 && split[i + 1].length() + current.length() + 1 <= 256) continue;
                if (i + 1 < split.length) {
                    current.append(" ");
                }
                sections.add(current.toString());
                current = new StringBuilder();
            }
            for (i = 0; i < sections.size(); ++i) {
                if (i > 0) {
                    builder.appendSpace();
                }
                builder.append(this.createComponent((String)sections.get(i), i + 1, sections.size()));
            }
        } else {
            builder.append(this.createComponent(string, 1, 1));
        }
        DisguiseUtilities.sendMessage(sender, (Component)builder.build());
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_JSON;
    }
}

