/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDChangelog;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.commands.libsdisguises.LDConfig;
import me.libraryaddict.disguise.commands.libsdisguises.LDCount;
import me.libraryaddict.disguise.commands.libsdisguises.LDDebugDisguiseLoop;
import me.libraryaddict.disguise.commands.libsdisguises.LDDebugMineSkin;
import me.libraryaddict.disguise.commands.libsdisguises.LDDebugPlayer;
import me.libraryaddict.disguise.commands.libsdisguises.LDDebugging;
import me.libraryaddict.disguise.commands.libsdisguises.LDHelp;
import me.libraryaddict.disguise.commands.libsdisguises.LDJson;
import me.libraryaddict.disguise.commands.libsdisguises.LDMetaInfo;
import me.libraryaddict.disguise.commands.libsdisguises.LDMissingDescription;
import me.libraryaddict.disguise.commands.libsdisguises.LDMods;
import me.libraryaddict.disguise.commands.libsdisguises.LDPermTest;
import me.libraryaddict.disguise.commands.libsdisguises.LDReload;
import me.libraryaddict.disguise.commands.libsdisguises.LDScoreboard;
import me.libraryaddict.disguise.commands.libsdisguises.LDUpdate;
import me.libraryaddict.disguise.commands.libsdisguises.LDUpdatePacketEvents;
import me.libraryaddict.disguise.commands.libsdisguises.LDUploadLogs;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class LibsDisguisesCommand
implements CommandExecutor,
TabCompleter {
    private final ArrayList<LDCommand> commands = new ArrayList();

    public LibsDisguisesCommand() {
        this.getCommands().add(new LDHelp(this));
        this.getCommands().add(new LDReload());
        this.getCommands().add(new LDUpdate());
        this.getCommands().add(new LDChangelog());
        this.getCommands().add(new LDCount());
        this.getCommands().add(new LDConfig());
        this.getCommands().add(new LDPermTest());
        this.getCommands().add(new LDScoreboard());
        this.getCommands().add(new LDJson());
        this.getCommands().add(new LDMods());
        this.getCommands().add(new LDMetaInfo());
        this.getCommands().add(new LDDebugPlayer());
        this.getCommands().add(new LDUploadLogs());
        this.getCommands().add(new LDUpdatePacketEvents());
        this.getCommands().add(new LDDebugMineSkin());
        this.getCommands().add(new LDDebugDisguiseLoop());
        this.getCommands().add(new LDMissingDescription());
        this.getCommands().add(new LDDebugging());
    }

    protected ArrayList<String> filterTabs(ArrayList<String> list, String[] origArgs) {
        if (origArgs.length == 0) {
            return list;
        }
        Iterator<String> itel = list.iterator();
        String label = origArgs[origArgs.length - 1].toLowerCase(Locale.ENGLISH);
        while (itel.hasNext()) {
            String name = itel.next();
            if (name.toLowerCase(Locale.ENGLISH).startsWith(label)) continue;
            itel.remove();
        }
        return list;
    }

    protected String[] getArgs(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            String s = args[i];
            if (s.trim().isEmpty()) continue;
            newArgs.add(s);
        }
        return newArgs.toArray(new String[0]);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            LibsDisguises disguises = LibsDisguises.getInstance();
            String version = disguises.getDescription().getVersion();
            if (!disguises.isReleaseBuild()) {
                version = version + "-";
                if (disguises.isJenkins()) {
                    version = version + "b";
                }
                version = version + disguises.getBuildNo();
            }
            sender.sendMessage(ChatColor.DARK_GREEN + "This server is running Lib's Disguises v" + version + " by libraryaddict, formerly maintained by Byteflux and NavidK0.");
            if (sender.hasPermission("libsdisguises.reload")) {
                sender.sendMessage(ChatColor.DARK_GREEN + "Use " + ChatColor.GREEN + "/libsdisguises reload" + ChatColor.DARK_GREEN + " to reload the config. All disguises will be blown by doing this.");
                sender.sendMessage(ChatColor.DARK_GREEN + "Use /libsdisguises help to see more help");
            }
            if (LibsPremium.isPremium().booleanValue()) {
                sender.sendMessage(ChatColor.DARK_GREEN + "This server supports the plugin developer!");
            }
        } else if (args.length > 0) {
            LDCommand command = null;
            for (LDCommand c : this.getCommands()) {
                if (!c.getTabComplete().contains(args[0].toLowerCase(Locale.ENGLISH))) continue;
                command = c;
                break;
            }
            if (command != null) {
                if (!command.hasPermission(sender)) {
                    LibsMsg.NO_PERM.send(sender, new Object[0]);
                    return true;
                }
                command.onCommand(sender, args);
            } else {
                LibsMsg.LIBS_COMMAND_WRONG_ARG.send(sender, new Object[0]);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        for (LDCommand command : this.getCommands()) {
            if (!command.hasPermission(sender)) continue;
            if (origArgs.length <= 1) {
                tabs.addAll(command.getTabComplete());
                continue;
            }
            for (String s : command.getTabComplete()) {
                String[] split = s.split(" ");
                if (split.length <= 1 || !args[0].equalsIgnoreCase(split[0])) continue;
                tabs.add(split[1]);
            }
        }
        return this.filterTabs(tabs, origArgs);
    }

    public ArrayList<LDCommand> getCommands() {
        return this.commands;
    }
}

