/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodHiddenFor;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodIgnoredBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodMappedAs;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.sounds.DisguiseSoundEnums;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.jetbrains.annotations.NotNull;

public class CompileMethods {
    @CompileMethodsIntfer(user="%%__USER__%%")
    public static void main(String[] args) {
        CompileMethods.doMethods();
        CompileMethods.doSounds();
        CompileMethods.doFileCount();
    }

    public static String[] ignoredDirectories() {
        return new String[]{"META-INF/", "libsdisg/", "me/libraryaddict/disguise/utilities/reflection/v", "me/libraryaddict/disguise/utilities/reflection/ReflectionManagerAbstract.class", "fernflower_", "net/kyori/adventure/"};
    }

    private static void doFileCount() {
        File classesFolder = new File("plugin/target/classes");
        int count = CompileMethods.getFileCount(classesFolder);
        try {
            Files.write(new File(classesFolder, "plugin.yml").toPath(), ("\nfile-count: " + count).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getFileCount(File folder) {
        int count = 0;
        for (File f : folder.listFiles()) {
            if (f.isFile()) {
                ++count;
                continue;
            }
            count += CompileMethods.getFileCount(f);
        }
        return count;
    }

    private static void doSounds() {
        ArrayList<String> list = new ArrayList<String>();
        for (DisguiseSoundEnums e : DisguiseSoundEnums.values()) {
            StringBuilder sound = CompileMethods.getSoundAsString(e);
            list.add(sound.toString());
        }
        File soundsFile = new File("plugin/target/classes/SOUND_MAPPINGS");
        try (FileOutputStream fos = new FileOutputStream(soundsFile);){
            fos.write(String.join((CharSequence)"\n", list).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private static StringBuilder getSoundAsString(DisguiseSoundEnums e) {
        StringBuilder sound = new StringBuilder(e.name());
        for (SoundGroup.SoundType type : SoundGroup.SoundType.values()) {
            sound.append("/");
            int i = 0;
            for (Map.Entry<String, SoundGroup.SoundType> entry : e.getSounds().entrySet()) {
                if (entry.getValue() != type) continue;
                if (i++ > 0) {
                    sound.append(",");
                }
                sound.append(entry.getKey());
            }
        }
        return sound;
    }

    private static void addClass(ArrayList<Class> classes, Class c) {
        if (classes.contains(c)) {
            return;
        }
        if (c != FlagWatcher.class) {
            CompileMethods.addClass(classes, c.getSuperclass());
        }
        classes.add(c);
    }

    private static void doMethods() {
        ArrayList<Class<?>> classes = ClassGetter.getClassesForPackage(FlagWatcher.class, "me.libraryaddict.disguise.disguisetypes.watchers");
        if (classes.isEmpty()) {
            throw new IllegalStateException("Classes were not found for FlagWatchers");
        }
        ArrayList<Class> sorted = new ArrayList<Class>();
        for (Class<?> clazz : classes) {
            CompileMethods.addClass(sorted, clazz);
        }
        ArrayList<WatcherInfo> methods = new ArrayList<WatcherInfo>();
        for (Class c : sorted) {
            for (Method method : c.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !FlagWatcher.class.isAssignableFrom(method.getDeclaringClass()) || method.getParameterCount() > 1 || (!method.getName().startsWith("set") || method.getParameterCount() != 1) && !method.getName().startsWith("get") && !method.getName().startsWith("has") && !method.getName().startsWith("is") || method.getName().equals("removePotionEffect") || (LibsPremium.isPremium().booleanValue() || !LibsPremium.getUserID().contains("%")) && new Random().nextBoolean() || method.getParameterCount() > 0 && method.getReturnType() != Void.TYPE) continue;
                int added = -1;
                int removed = -1;
                DisguiseType[] unusableBy = new DisguiseType[]{};
                DisguiseType[] hiddenFor = new DisguiseType[]{};
                String mappedAs = method.getName();
                if (method.isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getAnnotation(NmsAddedIn.class).value().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getDeclaringClass().getAnnotation(NmsAddedIn.class).value().ordinal();
                }
                if (method.isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getAnnotation(NmsRemovedIn.class).value().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getDeclaringClass().getAnnotation(NmsRemovedIn.class).value().ordinal();
                }
                if (method.isAnnotationPresent(MethodOnlyUsedBy.class)) {
                    DisguiseType[] usableBy = method.getAnnotation(MethodOnlyUsedBy.class).value();
                    if (usableBy.length == 0) {
                        usableBy = method.getAnnotation(MethodOnlyUsedBy.class).group().getDisguiseTypes();
                    }
                    List<DisguiseType> list = Arrays.asList(usableBy);
                    unusableBy = (DisguiseType[])Arrays.stream(DisguiseType.values()).filter(type -> !list.contains(type)).toArray(DisguiseType[]::new);
                } else if (method.isAnnotationPresent(MethodIgnoredBy.class) && (unusableBy = method.getAnnotation(MethodIgnoredBy.class).value()).length == 0) {
                    unusableBy = method.getAnnotation(MethodIgnoredBy.class).group().getDisguiseTypes();
                }
                if (method.isAnnotationPresent(MethodHiddenFor.class) && (hiddenFor = method.getAnnotation(MethodHiddenFor.class).value()).length == 0) {
                    hiddenFor = DisguiseType.values();
                }
                if (method.isAnnotationPresent(MethodMappedAs.class)) {
                    mappedAs = method.getAnnotation(MethodMappedAs.class).value();
                }
                String param = method.getParameterCount() == 1 ? method.getParameterTypes()[0].getName() : null;
                WatcherInfo info = new WatcherInfo();
                info.setMethod(method.getName());
                info.setMappedAs(mappedAs);
                info.setAdded(added);
                info.setRemoved(removed);
                info.setUnusableBy(unusableBy);
                info.setHiddenFor(hiddenFor);
                info.setDeprecated(method.isAnnotationPresent(Deprecated.class));
                info.setParam(param);
                info.setDescriptor(CompileMethods.getMethodDescriptor(method));
                info.setWatcher(method.getDeclaringClass().getSimpleName());
                info.setReturnType(method.getReturnType().getName());
                info.setRandomDefault(method.isAnnotationPresent(RandomDefaultValue.class));
                if (info.isRandomDefault() && !"void".equals(info.getReturnType())) {
                    throw new IllegalStateException("@RandomDefaultValue is intended for use only on setter methods, " + info.getMethod() + " on " + c.getSimpleName() + " does not met this criteria!");
                }
                if (methods.contains(info)) continue;
                methods.add(info);
            }
        }
        if (methods.isEmpty()) {
            throw new IllegalStateException("Methods were not compiled");
        }
        String string = new Gson().toJson(methods);
        File methodsFile = new File("plugin/target/classes/METHOD_MAPPINGS");
        try (FileOutputStream fos = new FileOutputStream(methodsFile);){
            fos.write(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    static String getMethodDescriptor(Method m) {
        StringBuilder s = new StringBuilder("(");
        for (Class<?> c : m.getParameterTypes()) {
            s.append(CompileMethods.getDescriptorForClass(c));
        }
        return s.append(")") + CompileMethods.getDescriptorForClass(m.getReturnType());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CompileMethodsIntfer {
        public String user() default "%%__USER__%%";
    }
}

