/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_20_R3;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.CraftArt;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCat;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReflectionManager
implements ReflectionManagerAbstract {
    private Field dataItemsField;
    private final Field trackedEntityField;
    private final AtomicInteger entityCounter;
    private final Method entityDefaultSoundMethod;
    private final Method itemMetaDeserialize;

    public ReflectionManager() {
        for (Field f : DataWatcher.class.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || !Int2ObjectMap.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            this.dataItemsField = f;
        }
        Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("d");
        entityCounter.setAccessible(true);
        this.entityCounter = (AtomicInteger)entityCounter.get(null);
        this.trackedEntityField = PlayerChunkMap.EntityTracker.class.getDeclaredField("b");
        this.trackedEntityField.setAccessible(true);
        this.entityDefaultSoundMethod = EntityLiving.class.getDeclaredMethod("eW", new Class[0]);
        this.entityDefaultSoundMethod.setAccessible(true);
        Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_20_R3.inventory.CraftMetaItem$SerializableMeta");
        this.itemMetaDeserialize = aClass.getDeclaredMethod("deserialize", Map.class);
    }

    @Override
    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof EntityLiving) {
            return nmsEntity.al > 0;
        }
        return nmsEntity.b(nmsEntity.dN().n());
    }

    @Override
    public int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.bS.k();
    }

    @Override
    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    @Override
    public int getNewEntityId(boolean increment) {
        if (increment) {
            return this.entityCounter.incrementAndGet();
        }
        return this.entityCounter.get();
    }

    public PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().c;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        net.minecraft.world.entity.Entity entity;
        Optional optional = EntityTypes.a((String)entityName.toLowerCase(Locale.ENGLISH));
        if (!optional.isPresent()) {
            return null;
        }
        EntityTypes entityType = (EntityTypes)optional.get();
        WorldServer world = this.getWorldServer((org.bukkit.World)Bukkit.getWorlds().get(0));
        if (entityType == EntityTypes.bv) {
            GameProfile gameProfile = new GameProfile(new UUID(0L, 0L), "Steve");
            ClientInformation information = new ClientInformation("english", 10, EnumChatVisibility.a, true, 0, EnumMainHand.b, true, true);
            entity = new EntityPlayer((MinecraftServer)this.getMinecraftServer(), world, gameProfile, information);
        } else {
            entity = entityType.a((World)world);
        }
        if (entity == null) {
            return null;
        }
        entity.a_(1.0, 1.0, 1.0);
        entity.a_(0.0, 0.0, 0.0);
        return entity;
    }

    public AxisAlignedBB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().cH();
    }

    @Override
    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).d - this.getBoundingBox((Entity)entity).a;
    }

    @Override
    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).e - this.getBoundingBox((Entity)entity).b;
    }

    @Override
    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).f - this.getBoundingBox((Entity)entity).c;
    }

    public EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).p();
    }

    @Override
    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    @Override
    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    @Override
    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public EntityTrackerEntry getEntityTrackerEntry(Entity target) throws Exception {
        WorldServer world = ((CraftWorld)target.getWorld()).getHandle();
        ChunkProviderServer chunkSource = world.l();
        PlayerChunkMap chunkMap = chunkSource.a;
        Int2ObjectMap entityMap = chunkMap.K;
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        return (EntityTrackerEntry)this.trackedEntityField.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    @Override
    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    @Override
    public double getPing(Player player) {
        return player.getPing();
    }

    @Override
    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntitySize dimensions = nmsEntity.a(EntityPose.a);
        return new float[]{dimensions.a, nmsEntity.cI()};
    }

    @Override
    public MinecraftSessionService getMinecraftSessionService() {
        return this.getMinecraftServer().ao();
    }

    @Override
    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            return (Float)this.entityDefaultSoundMethod.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void injectCallback(String playername, ProfileLookupCallback callback) {
        this.getMinecraftServer().aq().findProfilesByNames(new String[]{playername}, callback);
    }

    @Override
    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    @Override
    public String getSoundString(Sound sound) {
        return CraftSound.bukkitToMinecraft((Sound)sound).a().toString();
    }

    @Override
    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    @Override
    public String getItemName(Material material) {
        return BuiltInRegistries.h.b((Object)CraftMagicNumbers.getItem((Material)material)).a();
    }

    public MinecraftKey createMinecraftKey(String name) {
        return new MinecraftKey(name);
    }

    public EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    @Override
    public Object registerEntityType(NamespacedKey key) {
        EntityTypes newEntity = new EntityTypes(null, null, false, false, false, false, null, null, 0, 0, FeatureFlagSet.a());
        IRegistry.a((IRegistry)BuiltInRegistries.g, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.g();
        return newEntity;
    }

    @Override
    public int getEntityTypeId(Object entityTypes) {
        EntityTypes entityType = (EntityTypes)entityTypes;
        return BuiltInRegistries.g.a((Object)entityType);
    }

    @Override
    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    @Override
    public Object getEntityType(NamespacedKey name) {
        return BuiltInRegistries.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    @Override
    public int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.i((IBlockData)state);
    }

    @Override
    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.i((IBlockData)block.o());
    }

    @Override
    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.a((int)id));
    }

    @Override
    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.a((int)id).b()));
    }

    public WorldServer getWorldServer(org.bukkit.World w) {
        return ((CraftWorld)w).getHandle();
    }

    @Override
    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            return (ItemMeta)this.itemMetaDeserialize.invoke(null, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ByteBuf getDataWatcherValues(Entity entity) {
        DataWatcher watcher = ((CraftEntity)entity).getHandle().an();
        Int2ObjectMap dataItems = (Int2ObjectMap)this.dataItemsField.get(watcher);
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer();
        PacketDataSerializer serializer = new PacketDataSerializer(buf);
        for (DataWatcher.Item dataItem : dataItems.values()) {
            dataItem.e().a(serializer);
        }
        serializer.k(255);
        return buf;
    }

    @Override
    public GameProfile getMCGameProfile(Player player) {
        return ((CraftPlayer)player).getProfile();
    }

    @Override
    public Cat.Type getCatTypeFromInt(int catType) {
        IRegistry registry = BuiltInRegistries.ak;
        Holder.c ref = (Holder.c)registry.c(catType).get();
        return CraftCat.CraftType.minecraftToBukkit((CatVariant)((CatVariant)ref.a()));
    }

    @Override
    public int getCatVariantAsInt(Cat.Type type) {
        IRegistry registry = BuiltInRegistries.ak;
        return registry.a((Object)CraftCat.CraftType.bukkitToMinecraft((Cat.Type)type));
    }

    @Override
    public Frog.Variant getFrogVariantFromInt(int frogType) {
        IRegistry registry = BuiltInRegistries.al;
        Holder.c ref = (Holder.c)registry.c(frogType).get();
        return CraftFrog.CraftVariant.minecraftToBukkit((FrogVariant)((FrogVariant)ref.a()));
    }

    @Override
    public int getFrogVariantAsInt(Frog.Variant type) {
        IRegistry registry = BuiltInRegistries.al;
        return registry.a((Object)CraftFrog.CraftVariant.bukkitToMinecraft((Frog.Variant)type));
    }

    @Override
    public Art getPaintingFromInt(int paintingId) {
        RegistryBlocks registry = BuiltInRegistries.l;
        Holder.c ref = (Holder.c)registry.c(paintingId).get();
        return CraftArt.minecraftHolderToBukkit((Holder)((Holder)registry.c(paintingId).get()));
    }

    @Override
    public int getPaintingAsInt(Art type) {
        RegistryBlocks registry = BuiltInRegistries.l;
        return registry.a((Object)CraftArt.bukkitToMinecraft((Art)type));
    }
}

