/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;

public class ParamInfoTime
extends ParamInfo {
    public ParamInfoTime(Class paramClass, String name, String description) {
        super(paramClass, name, description);
    }

    @Override
    public boolean isParam(Class classType) {
        return classType == Long.class || classType == Long.TYPE;
    }

    protected Object fromString(String string) throws DisguiseParseException {
        if (string.matches("[0-9]{13,}")) {
            return Long.parseLong(string);
        }
        long time = DisguiseParser.parseStringToTime(string);
        if (DisguiseConfig.isDynamicExpiry()) {
            time *= 20L;
        } else if (!DisguiseConfig.isDynamicExpiry()) {
            time *= 1000L;
            time += System.currentTimeMillis();
        }
        return time;
    }

    public String toString(Object object) {
        return object.toString();
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

