/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketHandlerMetadata
implements IPacketHandler<WrapperPlayServerEntityMetadata> {
    @Override
    public PacketTypeCommon[] getHandledPackets() {
        return new PacketTypeCommon[]{PacketType.Play.Server.ENTITY_METADATA};
    }

    @Override
    public void handle(Disguise disguise, LibsPackets<WrapperPlayServerEntityMetadata> packets, Player observer, Entity entity) {
        packets.clear();
        if (!DisguiseConfig.isMetaPacketsEnabled()) {
            return;
        }
        List dataList = packets.getOriginalPacket().getEntityMetadata();
        ArrayList<WatcherValue> watcherValues = new ArrayList<WatcherValue>();
        for (Object data : dataList) {
            watcherValues.add(new WatcherValue((EntityData)data));
        }
        List<WatcherValue> watchableObjects = disguise.getWatcher().convert(observer, watcherValues);
        if (watchableObjects.isEmpty()) {
            return;
        }
        for (WatcherValue object : watchableObjects) {
            if (!(object.getDataValue().getValue() instanceof ItemStack) || !DisguiseUtilities.hasCustomEnchants((ItemStack)object.getDataValue().getValue())) continue;
            object.getDataValue().setValue((Object)DisguiseUtilities.stripEnchants((ItemStack)object.getDataValue().getValue()));
        }
        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(entity.getEntityId(), watchableObjects);
        packets.addPacket((PacketWrapper)metaPacket);
    }
}

