/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LibsPackets<T extends PacketWrapper<T>> {
    private final List<PacketWrapper> packets = new ArrayList<PacketWrapper>();
    private final HashMap<Integer, ArrayList<PacketWrapper>> delayedPacketsMap = new HashMap();
    private final T originalPacket;
    private final Disguise disguise;
    private boolean unhandled;
    private boolean skinHandling;

    public boolean shouldCancelPacketEvent() {
        return !this.packets.contains(this.getOriginalPacket());
    }

    public void addPacket(PacketWrapper packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketWrapper packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketWrapper packet, int ticksDelayed) {
        if (!this.delayedPacketsMap.containsKey(ticksDelayed)) {
            this.delayedPacketsMap.put(ticksDelayed, new ArrayList());
        }
        this.delayedPacketsMap.get(ticksDelayed).add(packet);
    }

    public void sendDelayed(Player observer) {
        for (Map.Entry<Integer, ArrayList<PacketWrapper>> entry : this.getDelayedPacketsMap().entrySet()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (!this.getDisguise().isDisguiseInUse()) {
                    ArrayList packets = (ArrayList)entry.getValue();
                    if (packets.stream().noneMatch(p -> p.getPacketTypeData().getPacketType() == PacketType.Play.Server.PLAYER_INFO)) {
                        return;
                    }
                    packets.removeIf(p -> p.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO);
                }
                for (PacketWrapper packet : (ArrayList)entry.getValue()) {
                    if (packet.getPacketTypeData().getPacketType() == PacketType.Play.Server.ENTITY_EQUIPMENT) {
                        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, packet);
                        continue;
                    }
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)observer, packet);
                }
            }, (long)entry.getKey().intValue());
        }
    }

    public HashMap<Integer, ArrayList<PacketWrapper>> getDelayedPacketsMap() {
        return this.delayedPacketsMap;
    }

    public boolean isUnhandled() {
        return this.unhandled;
    }

    public boolean isSkinHandling() {
        return this.skinHandling;
    }

    public LibsPackets(T originalPacket, Disguise disguise) {
        this.originalPacket = originalPacket;
        this.disguise = disguise;
    }

    public void setUnhandled(boolean unhandled) {
        this.unhandled = unhandled;
    }

    public void setSkinHandling(boolean skinHandling) {
        this.skinHandling = skinHandling;
    }

    public List<PacketWrapper> getPackets() {
        return this.packets;
    }

    public T getOriginalPacket() {
        return this.originalPacket;
    }

    public Disguise getDisguise() {
        return this.disguise;
    }
}

