/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import java.util.Locale;
import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Villager;

public class ZombieVillagerWatcher
extends ZombieWatcher {
    public ZombieVillagerWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setProfession(Villager.Profession.values()[new Random().nextInt(Villager.Profession.values().length)]);
        }
    }

    public boolean isShaking() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public void setShaking(boolean shaking) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_SHAKING, shaking);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public boolean isVillager() {
        if (NmsVersion.v1_14.isSupported()) {
            return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION).getProfession() != VillagerProfessions.NONE;
        }
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD) != 0;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setVillagerData(VillagerData villagerData) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION, villagerData);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    public Villager.Profession getProfession() {
        if (NmsVersion.v1_14.isSupported()) {
            return Villager.Profession.valueOf((String)this.getVillagerData().getProfession().getName().getKey().toUpperCase(Locale.ENGLISH));
        }
        return Villager.Profession.values()[this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD) + 1];
    }

    @RandomDefaultValue
    public void setProfession(Villager.Profession profession) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)this.getType().getKey().toString()), VillagerProfessions.getByName((String)profession.getKey().toString()), this.getLevel()));
        } else {
            this.setData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD, profession.ordinal() - 1);
            this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD);
        }
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getType() {
        return Villager.Type.valueOf((String)this.getVillagerData().getType().getName().getKey().toUpperCase(Locale.ENGLISH));
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)type.getKey().toString()), VillagerProfessions.getByName((String)this.getProfession().getKey().toString()), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getBiome() {
        return this.getType();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBiome(Villager.Type type) {
        this.setType(type);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setLevel(int level) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)this.getType().getKey().toString()), VillagerProfessions.getByName((String)this.getProfession().getKey().toString()), Math.max(1, Math.min(5, level))));
    }
}

