/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.DisplayWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;

public class TextDisplayWatcher
extends DisplayWatcher {
    public TextDisplayWatcher(Disguise disguise) {
        super(disguise);
        this.setBillboard(Display.Billboard.CENTER);
        this.setText("Text Display");
    }

    public String getText() {
        return DisguiseUtilities.getSimpleString(this.getData(MetaIndex.TEXT_DISPLAY_TEXT));
    }

    public void setText(String string) {
        this.setData(MetaIndex.TEXT_DISPLAY_TEXT, DisguiseUtilities.getAdventureChat(string));
        this.sendData(MetaIndex.TEXT_DISPLAY_TEXT);
    }

    public int getLineWidth() {
        return this.getData(MetaIndex.TEXT_DISPLAY_LINE_WIDTH);
    }

    public void setLineWidth(int width) {
        this.setData(MetaIndex.TEXT_DISPLAY_LINE_WIDTH, width);
        this.sendData(MetaIndex.TEXT_DISPLAY_LINE_WIDTH);
    }

    public Color getBackgroundColor() {
        int color = this.getData(MetaIndex.TEXT_DISPLAY_BACKGROUND_COLOR);
        if (color == -1) {
            return null;
        }
        return Color.fromARGB((int)color);
    }

    public void setBackgroundColor(Color color) {
        this.setData(MetaIndex.TEXT_DISPLAY_BACKGROUND_COLOR, color == null ? -1 : color.asARGB());
        this.sendData(MetaIndex.TEXT_DISPLAY_BACKGROUND_COLOR);
    }

    public byte getTextOpacity() {
        return this.getData(MetaIndex.TEXT_DISPLAY_TEXT_OPACITY);
    }

    public void setTextOpacity(byte opacity) {
        if (opacity < -1 || opacity > 255) {
            return;
        }
        this.setData(MetaIndex.TEXT_DISPLAY_TEXT_OPACITY, opacity);
        this.sendData(MetaIndex.TEXT_DISPLAY_TEXT_OPACITY);
    }

    public boolean isShadowed() {
        return this.getFlag(1);
    }

    public void setShadowed(boolean shadow) {
        this.setFlag(1, shadow);
    }

    public boolean isSeeThrough() {
        return this.getFlag(2);
    }

    public void setSeeThrough(boolean seeThrough) {
        this.setFlag(2, seeThrough);
    }

    public boolean isDefaultBackground() {
        return this.getFlag(4);
    }

    public void setDefaultBackground(boolean defaultBackground) {
        this.setFlag(4, defaultBackground);
    }

    public TextDisplay.TextAlignment getAlignment() {
        byte flags = this.getData(MetaIndex.TEXT_DISPLAY_FLAGS);
        if ((flags & 8) != 0) {
            return TextDisplay.TextAlignment.LEFT;
        }
        return (flags & 0x10) != 0 ? TextDisplay.TextAlignment.RIGHT : TextDisplay.TextAlignment.CENTER;
    }

    public void setAlignment(TextDisplay.TextAlignment alignment) {
        switch (alignment.ordinal()) {
            case 0: {
                this.setFlag(8, false);
                this.setFlag(16, false);
                break;
            }
            case 1: {
                this.setFlag(8, true);
                this.setFlag(16, false);
                break;
            }
            case 2: {
                this.setFlag(8, false);
                this.setFlag(16, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown alignment " + alignment);
            }
        }
    }

    private boolean getFlag(int flag) {
        return (this.getData(MetaIndex.TEXT_DISPLAY_FLAGS) & flag) != 0;
    }

    private void setFlag(int flag, boolean set) {
        byte flagBits = this.getData(MetaIndex.TEXT_DISPLAY_FLAGS);
        flagBits = set ? (byte)(flagBits | flag) : (byte)(flagBits & ~flag);
        this.setData(MetaIndex.TEXT_DISPLAY_FLAGS, flagBits);
        this.sendData(MetaIndex.TEXT_DISPLAY_FLAGS);
    }
}

