/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.util.Quaternion4f;
import com.github.retrooper.packetevents.util.Vector3f;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;

public abstract class DisplayWatcher
extends FlagWatcher {
    public DisplayWatcher(Disguise disguise) {
        super(disguise);
    }

    public Transformation getTransformation() {
        return new Transformation(this.getTranslation(), this.getLeftRotation(), this.getScale(), this.getRightRotation());
    }

    @RandomDefaultValue
    public void setTransformation(Transformation transformation) {
        org.joml.Vector3f trans = transformation.getTranslation();
        Quaternionf rl = transformation.getLeftRotation();
        Quaternionf rr = transformation.getRightRotation();
        org.joml.Vector3f scale = transformation.getScale();
        this.setData(MetaIndex.DISPLAY_TRANSLATION, new Vector3f(trans.x, trans.y, trans.z));
        this.setData(MetaIndex.DISPLAY_LEFT_ROTATION, new Quaternion4f(rl.x, rl.y, rl.z, rl.w));
        this.setData(MetaIndex.DISPLAY_RIGHT_ROTATION, new Quaternion4f(rr.x, rr.y, rr.z, rr.w));
        this.setData(MetaIndex.DISPLAY_SCALE, new Vector3f(scale.x, scale.y, scale.z));
        this.sendData(MetaIndex.DISPLAY_TRANSLATION, MetaIndex.DISPLAY_LEFT_ROTATION, MetaIndex.DISPLAY_RIGHT_ROTATION, MetaIndex.DISPLAY_SCALE);
    }

    public org.joml.Vector3f getTranslation() {
        Vector3f vec = this.getData(MetaIndex.DISPLAY_TRANSLATION);
        return new org.joml.Vector3f(vec.x, vec.y, vec.z);
    }

    @RandomDefaultValue
    public void setTranslation(org.joml.Vector3f translation) {
        this.setData(MetaIndex.DISPLAY_TRANSLATION, new Vector3f(translation.x, translation.y, translation.z));
        this.sendData(MetaIndex.DISPLAY_TRANSLATION);
    }

    public org.joml.Vector3f getScale() {
        Vector3f vec = this.getData(MetaIndex.DISPLAY_SCALE);
        return new org.joml.Vector3f(vec.x, vec.y, vec.z);
    }

    public void setScale(org.joml.Vector3f scale) {
        this.setData(MetaIndex.DISPLAY_SCALE, new Vector3f(scale.x, scale.y, scale.z));
        this.sendData(MetaIndex.DISPLAY_SCALE);
    }

    public Quaternionf getLeftRotation() {
        Quaternion4f rot = this.getData(MetaIndex.DISPLAY_LEFT_ROTATION);
        return new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
    }

    public void setLeftRotation(Quaternionf rotation) {
        this.setData(MetaIndex.DISPLAY_LEFT_ROTATION, new Quaternion4f(rotation.x, rotation.y, rotation.z, rotation.w));
        this.sendData(MetaIndex.DISPLAY_LEFT_ROTATION);
    }

    public Quaternionf getRightRotation() {
        Quaternion4f rot = this.getData(MetaIndex.DISPLAY_RIGHT_ROTATION);
        return new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
    }

    public void setRightRotation(Quaternionf rotation) {
        this.setData(MetaIndex.DISPLAY_RIGHT_ROTATION, new Quaternion4f(rotation.x, rotation.y, rotation.z, rotation.w));
        this.sendData(MetaIndex.DISPLAY_RIGHT_ROTATION);
    }

    public int getInterpolationDuration() {
        return this.getData(MetaIndex.DISPLAY_INTERPOLATION_DURATION);
    }

    public void setInterpolationDuration(int duration) {
        this.setData(MetaIndex.DISPLAY_INTERPOLATION_DURATION, duration);
        this.sendData(MetaIndex.DISPLAY_INTERPOLATION_DURATION);
    }

    public float getViewRange() {
        return this.getData(MetaIndex.DISPLAY_VIEW_RANGE).floatValue();
    }

    public void setViewRange(float range) {
        this.setData(MetaIndex.DISPLAY_VIEW_RANGE, Float.valueOf(range));
        this.sendData(MetaIndex.DISPLAY_VIEW_RANGE);
    }

    public float getShadowRadius() {
        return this.getData(MetaIndex.DISPLAY_SHADOW_RADIUS).floatValue();
    }

    public void setShadowRadius(float radius) {
        this.setData(MetaIndex.DISPLAY_SHADOW_RADIUS, Float.valueOf(radius));
        this.sendData(MetaIndex.DISPLAY_SHADOW_RADIUS);
    }

    public float getShadowStrength() {
        return this.getData(MetaIndex.DISPLAY_SHADOW_STRENGTH).floatValue();
    }

    public void setShadowStrength(float strength) {
        this.setData(MetaIndex.DISPLAY_SHADOW_STRENGTH, Float.valueOf(strength));
        this.sendData(MetaIndex.DISPLAY_SHADOW_STRENGTH);
    }

    public float getDisplayWidth() {
        return this.getData(MetaIndex.DISPLAY_WIDTH).floatValue();
    }

    public void setDisplayWidth(float width) {
        this.setData(MetaIndex.DISPLAY_WIDTH, Float.valueOf(width));
        this.sendData(MetaIndex.DISPLAY_WIDTH);
    }

    public float getDisplayHeight() {
        return this.getData(MetaIndex.DISPLAY_HEIGHT).floatValue();
    }

    public void setDisplayHeight(float height) {
        this.setData(MetaIndex.DISPLAY_HEIGHT, Float.valueOf(height));
        this.sendData(MetaIndex.DISPLAY_HEIGHT);
    }

    public int getInterpolationDelay() {
        return this.getData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS);
    }

    public void setInterpolationDelay(int ticks) {
        this.setData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS, ticks);
        this.sendData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.values()[this.getData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS)];
    }

    @RandomDefaultValue
    public void setBillboard(Display.Billboard billboard) {
        this.setData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS, (byte)billboard.ordinal());
        this.sendData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS);
    }

    public Color getGlowColorOverride() {
        int color = this.getData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE);
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        this.setData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE, color == null ? -1 : color.asARGB());
        this.sendData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE);
    }

    public Display.Brightness getBrightness() {
        int data = this.getData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE);
        if (data == -1) {
            return null;
        }
        int blockLight = data >> 4 & 0xFFFF;
        int skyLight = data >> 20 & 0xFFFF;
        return new Display.Brightness(blockLight, skyLight);
    }

    public void setBrightness(Display.Brightness brightness) {
        this.setData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE, brightness == null ? -1 : brightness.getBlockLight() << 4 | brightness.getSkyLight() << 20);
        this.sendData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE);
    }

    public int getTeleportDuration() {
        return this.getData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION);
    }

    public void setTeleportDuration(int duration) {
        this.setData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION, Math.max(0, Math.min(59, duration)));
        this.sendData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION);
    }
}

