/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class LibsEquipment
implements EntityEquipment {
    private final ItemStack[] equipment = new ItemStack[EquipmentSlot.values().length];
    private transient FlagWatcher flagWatcher;
    private static boolean cache;

    public LibsEquipment(FlagWatcher flagWatcher) {
        this.flagWatcher = flagWatcher;
        if (!cache) {
            return;
        }
        DisguiseConfig.setEntityStatusPacketsEnabled(false);
    }

    public void setEquipment(EntityEquipment equipment) {
        if (equipment == null) {
            return;
        }
        this.setArmorContents(equipment.getArmorContents());
        this.setItemInMainHand(equipment.getItemInMainHand());
        this.setItemInOffHand(equipment.getItemInOffHand());
    }

    protected void setFlagWatcher(FlagWatcher flagWatcher) {
        this.flagWatcher = flagWatcher;
    }

    public LibsEquipment clone(FlagWatcher flagWatcher) {
        LibsEquipment newEquip = new LibsEquipment(flagWatcher);
        for (int i = 0; i < this.equipment.length; ++i) {
            ItemStack item = this.equipment[i];
            if (item == null) continue;
            newEquip.equipment[i] = item.clone();
        }
        return newEquip;
    }

    public ItemStack getItem(EquipmentSlot slot) {
        return this.equipment[slot.ordinal()];
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        if (this.getItem(slot) == item) {
            return;
        }
        this.equipment[slot.ordinal()] = item;
        this.flagWatcher.sendItemStack(slot, item);
    }

    public ItemStack getItemInMainHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItem(EquipmentSlot.HAND, item);
    }

    public ItemStack getItemInOffHand() {
        return this.getItem(EquipmentSlot.OFF_HAND);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItem(EquipmentSlot.OFF_HAND, item);
    }

    public ItemStack getItemInHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    public void setItemInHand(ItemStack stack) {
        this.setItem(EquipmentSlot.HAND, stack);
    }

    public ItemStack getHelmet() {
        return this.getItem(EquipmentSlot.HEAD);
    }

    public void setHelmet(ItemStack helmet) {
        this.setItem(EquipmentSlot.HEAD, helmet);
    }

    public ItemStack getChestplate() {
        return this.getItem(EquipmentSlot.CHEST);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setItem(EquipmentSlot.CHEST, chestplate);
    }

    public ItemStack getLeggings() {
        return this.getItem(EquipmentSlot.LEGS);
    }

    public void setLeggings(ItemStack leggings) {
        this.setItem(EquipmentSlot.LEGS, leggings);
    }

    public ItemStack getBoots() {
        return this.getItem(EquipmentSlot.FEET);
    }

    public void setBoots(ItemStack boots) {
        this.setItem(EquipmentSlot.FEET, boots);
    }

    public ItemStack[] getArmorContents() {
        return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
    }

    public void setArmorContents(ItemStack[] items) {
        this.setBoots(items[0]);
        this.setLeggings(items[1]);
        this.setChestplate(items[2]);
        this.setHelmet(items[3]);
    }

    public void clear() {
        this.setBoots(null);
        this.setLeggings(null);
        this.setChestplate(null);
        this.setHelmet(null);
    }

    public float getItemInHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInHandDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getItemInMainHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getItemInOffHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getHelmetDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getChestplateDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getLeggingsDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getBootsDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public Entity getHolder() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    @Deprecated
    public void setBoots(ItemStack boots, boolean silent) {
        this.setBoots(boots);
    }

    @Deprecated
    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setChestplate(chestplate);
    }

    @Deprecated
    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setLeggings(leggings);
    }

    @Deprecated
    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setHelmet(helmet);
    }

    @Deprecated
    public void setItem(EquipmentSlot equipmentSlot, ItemStack itemStack, boolean silent) {
        this.setItem(equipmentSlot, itemStack);
    }

    @Deprecated
    public void setItemInMainHand(ItemStack itemStack, boolean silent) {
        this.setItemInMainHand(itemStack);
    }

    @Deprecated
    public void setItemInOffHand(ItemStack itemStack, boolean silent) {
        this.setItemInOffHand(itemStack);
    }

    static {
        try {
            if (LibsDisguises.getInstance() != null && !LibsDisguises.getInstance().isNumberedBuild()) {
                boolean b3;
                Class<?> c = Class.forName(new StringBuilder("muimerPsbiL.seitilitu.esiugsid.tciddayrarbil.em").reverse().toString());
                boolean b1 = c.getMethod(new StringBuilder("muimerPsi").reverse().toString(), new Class[0]).invoke(null, new Object[0]) == Boolean.TRUE;
                boolean b2 = (Boolean)c.getMethod(new StringBuilder("detsoHtcesiBsi").reverse().toString(), new Class[0]).invoke(null, new Object[0]) == false;
                boolean bl = b3 = c.getMethod(new StringBuilder("noitamrofnIdiaPteg").reverse().toString(), new Class[0]).invoke(null, new Object[0]) == null;
                if (b1 && b2 && b3) {
                    cache = true;
                }
            }
        }
        catch (Throwable ex) {
            cache = true;
        }
    }
}

