/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.PacketEventsUpdater;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUpdatePacketEvents
implements LDCommand {
    private final AtomicBoolean updateInProgress = new AtomicBoolean(false);

    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("updatepacketevents", "updatepe", "packetevents");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp() || sender.hasPermission("libsdisguises.update") || sender.hasPermission("minecraft.command.op");
    }

    @Override
    public String getPermission() {
        return null;
    }

    private void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.DARK_RED + "[LibsDisguises] " + ChatColor.RED + message);
    }

    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        if (this.updateInProgress.get()) {
            this.sendMessage(sender, "Update already in progress");
            return;
        }
        this.sendMessage(sender, "Please hold, now downloading PacketEvents..");
        new BukkitRunnable(){

            public void run() {
                PacketEventsUpdater updater = new PacketEventsUpdater();
                try {
                    final boolean outcome = updater.doUpdate();
                    new BukkitRunnable(){

                        public void run() {
                            if (outcome) {
                                LDUpdatePacketEvents.this.sendMessage(sender, "Download success! Restart server to finish update!");
                            } else {
                                LDUpdatePacketEvents.this.sendMessage(sender, "Update failed, you may need to update PacketEvents");
                            }
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new BukkitRunnable(){

                        public void run() {
                            LDUpdatePacketEvents.this.sendMessage(sender, "Update failed, " + ex.getMessage());
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                finally {
                    LDUpdatePacketEvents.this.updateInProgress.set(false);
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPDATE_PACKET_EVENTS;
    }
}

