/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.entity.armadillo.ArmadilloState;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.entity.sniffer.SnifferState;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ItemFrameWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ModdedWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.ClassMappings;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ReflectionManager {
    private static String craftbukkitVersion;
    private static Method itemAsCraftCopyMethod;
    private static Method damageAndIdleSoundMethod;
    private static Constructor<?> boundingBoxConstructor;
    private static Method setBoundingBoxMethod;
    private static Field pingField;
    private static Field entityCountField;
    private static Field chunkMapField;
    private static Field chunkProviderField;
    private static Field entityTrackerField;
    private static Field trackedEntitiesField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Method ihmGet;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field trackerField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field entitiesField;
    private static NmsVersion version;
    private static Method itemAsBukkitMethod;
    private static Method getServerMethod;
    private static Method getNmsEntityMethod;
    private static Method soundGetMethod;
    private static Method soundEffectGetMethod;
    private static Field soundEffectGetKey;
    private static Method entityTypesAMethod;
    private static Method craftBlockDataGetState;
    private static Method magicGetBlock;
    private static Method magicGetMaterial;
    private static Method getBlockData;
    private static Method getBlockDataAsId;
    private static Method getNmsWorld;
    private static Method deserializedItemMeta;
    private static Method boundingBoxMethod;
    private static Method bukkitEntityMethod;
    private static Method connectionEntityMethod;
    private static Field noDamageTicks;
    private static Method isInvul;
    private static Object genericDamage;
    private static Field playerConnection;
    private static Method incrementedInventoryStateId;
    private static Field playerInventoryContainer;
    private static ReflectionManagerAbstract nmsReflection;
    private static Field trackerIsMoving;
    private static Field trackedPlayers;
    private static Field trackedPlayersMap;
    private static Method clearEntityTracker;
    private static Method addEntityTracker;
    private static Method fillProfileProperties;
    private static MinecraftSessionService sessionService;
    private static String minecraftVersion;
    private static Method getGameProfile;
    private static Method propertyName;
    private static Method propertyValue;
    private static Method propertySignature;
    private static Method getDatawatcher;
    private static Method datawatcherSerialize;
    private static Field datawatcherData;

    /*
     * WARNING - void declaration
     */
    public static void init() {
        try {
            void var4_14;
            nmsReflection = ReflectionManager.getReflectionManager(ReflectionManager.getVersion());
            getGameProfile = ReflectionManager.getCraftMethod("CraftPlayer", "getProfile", new Class[0]);
            trackedPlayers = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers");
            if (DisguiseUtilities.isRunningPaper() && !NmsVersion.v1_17.isSupported()) {
                trackedPlayersMap = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap");
            }
            clearEntityTracker = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
            addEntityTracker = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
            trackerIsMoving = ReflectionManager.getNmsField("EntityTrackerEntry", NmsVersion.v1_20_R2.isSupported() ? "i" : (NmsVersion.v1_19_R1.isSupported() ? "p" : (NmsVersion.v1_17.isSupported() ? "r" : (NmsVersion.v1_14.isSupported() ? "q" : "isMoving"))));
            if (nmsReflection != null) {
                sessionService = nmsReflection.getMinecraftSessionService();
            } else {
                getServerMethod = ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]);
                Object minecraftServer = ReflectionManager.getMinecraftServer();
                for (AccessibleObject accessibleObject : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                    if (!((Method)accessibleObject).getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                    sessionService = (MinecraftSessionService)((Method)accessibleObject).invoke(minecraftServer, new Object[0]);
                    break;
                }
            }
            try {
                fillProfileProperties = sessionService.getClass().getMethod("fillProfileProperties", GameProfile.class, Boolean.TYPE);
            }
            catch (Exception minecraftServer) {
                // empty catch block
            }
            try {
                propertyName = Property.class.getMethod("getName", new Class[0]);
                propertyValue = Property.class.getMethod("getValue", new Class[0]);
                propertySignature = Property.class.getMethod("getSignature", new Class[0]);
            }
            catch (Exception minecraftServer) {
                // empty catch block
            }
            if (nmsReflection != null) {
                return;
            }
            boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
            entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
            boundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]);
            bukkitEntityMethod = ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]);
            Class<?> craftItemClass = ReflectionManager.getCraftClass("CraftItemStack");
            itemAsCraftCopyMethod = ReflectionManager.getCraftMethod(craftItemClass, "asCraftCopy", ItemStack.class);
            itemAsBukkitMethod = ReflectionManager.getCraftMethod(craftItemClass, "asBukkitCopy", ReflectionManager.getNmsClass("ItemStack"));
            getNmsEntityMethod = ReflectionManager.getCraftMethod("CraftEntity", "getHandle", new Class[0]);
            Class<?> craftSound = ReflectionManager.getCraftClass("CraftSound");
            try {
                soundGetMethod = craftSound.getMethod("getSound", Sound.class);
            }
            catch (Exception ex) {
                soundEffectGetMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", Sound.class);
                soundEffectGetKey = ReflectionManager.getNmsField("SoundEffect", "b");
            }
            getBlockData = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "getBlockData", new Class[0]);
            if (NmsVersion.v1_13.isSupported()) {
                craftBlockDataGetState = ReflectionManager.getCraftMethod("CraftBlockData", "getState", new Class[0]);
                magicGetBlock = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getBlock", Material.class);
                magicGetMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Block"));
                entityTypesAMethod = ReflectionManager.getNmsMethod("EntityTypes", "a", String.class);
            }
            getBlockDataAsId = ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData"));
            getNmsWorld = ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]);
            deserializedItemMeta = ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass("CraftMetaItem$SerializableMeta"), "deserialize", Map.class);
            noDamageTicks = ReflectionManager.getNmsField("Entity", "noDamageTicks");
            isInvul = ReflectionManager.getNmsMethod("Entity", "isInvulnerable", ReflectionManager.getNmsClass("DamageSource"));
            Field[] fieldArray = ReflectionManager.getNmsClass("DamageSource").getFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var4_14 < n) {
                Object obj;
                Field f = fieldArray[var4_14];
                if (Modifier.isStatic(f.getModifiers()) && (obj = f.get(null)) != null && obj.toString().contains("(generic)")) {
                    genericDamage = obj;
                    break;
                }
                ++var4_14;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object entity = ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityCow").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (((Float)method.invoke(entity, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethod(method.getName(), new Class[0]);
                damageAndIdleSoundMethod.setAccessible(true);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        if (NmsVersion.v1_14.isSupported()) {
            chunkMapField = ReflectionManager.getNmsField("ChunkProviderServer", "playerChunkMap");
            trackedEntitiesField = ReflectionManager.getNmsField("PlayerChunkMap", "trackedEntities");
            entityTrackerField = ReflectionManager.getNmsField("PlayerChunkMap$EntityTracker", "trackerEntry");
            chunkProviderField = NmsVersion.v1_16.isSupported() ? ReflectionManager.getNmsField("WorldServer", "chunkProvider") : ReflectionManager.getNmsField("World", "chunkProvider");
        } else {
            trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
            entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
            ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        }
        Class dataClass = ReflectionManager.getNmsClass("DataWatcher");
        for (Method method : ReflectionManager.getNmsClass("Entity").getMethods()) {
            if (method.getParameterCount() != 0 || !method.getReturnType().isAssignableFrom(dataClass)) continue;
            getDatawatcher = method;
            break;
        }
        for (AccessibleObject accessibleObject : dataClass.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Map.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
            datawatcherData = accessibleObject;
            datawatcherData.setAccessible(true);
            break;
        }
        for (AccessibleObject accessibleObject : dataClass.getMethods()) {
            Class<?>[] params;
            Class<?> returnType = ((Method)accessibleObject).getReturnType();
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterCount() != 2 || !(params = ((Method)accessibleObject).getParameterTypes())[0].isAssignableFrom(List.class)) continue;
            datawatcherSerialize = accessibleObject;
        }
    }

    public static boolean hasInvul(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.hasInvul(entity);
        }
        Object nmsEntity = ReflectionManager.getNmsEntity(entity);
        try {
            if (entity instanceof LivingEntity) {
                return noDamageTicks.getInt(nmsEntity) > 0;
            }
            return (Boolean)isInvul.invoke(nmsEntity, genericDamage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getIncrementedStateId(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getIncrementedStateId(player);
        }
        try {
            Object container = playerInventoryContainer.get(ReflectionManager.getNmsEntity((Entity)player));
            return (Integer)incrementedInventoryStateId.invoke(container, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static boolean isSupported(AccessibleObject obj) {
        NmsAddedIn added;
        if (obj.isAnnotationPresent(NmsAddedIn.class) && !(added = obj.getAnnotation(NmsAddedIn.class)).value().isSupported()) {
            return false;
        }
        if (obj.isAnnotationPresent(NmsRemovedIn.class)) {
            NmsRemovedIn removed = obj.getAnnotation(NmsRemovedIn.class);
            return !removed.value().isSupported();
        }
        return true;
    }

    public static boolean isSupported(Class cl, String name) {
        try {
            for (Field field : cl.getFields()) {
                if (!field.getName().equals(name)) continue;
                return ReflectionManager.isSupported(field);
            }
            for (AccessibleObject accessibleObject : cl.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(name)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static String getResourceAsString(File file, String fileName) {
        try {
            return ReflectionManager.getResourceAsStringEx(file, fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getJarFileCount(File file, String ... ignoredDirectories) throws IOException {
        try (JarFile jar = new JarFile(file);){
            int count = 0;
            Enumeration<JarEntry> entry = jar.entries();
            block5: while (entry.hasMoreElements()) {
                JarEntry element = entry.nextElement();
                if (element.isDirectory()) continue;
                for (String ignored : ignoredDirectories) {
                    if (element.getName().startsWith(ignored)) continue block5;
                }
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsStringEx(File file, String fileName) {
        try (JarFile jar = new JarFile(file);){
            String string;
            block13: {
                JarEntry entry = jar.getJarEntry(fileName);
                InputStream stream = jar.getInputStream(entry);
                try {
                    string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return string;
        }
    }

    public static List<File> getFilesByPlugin(String pluginName) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : LibsDisguises.getInstance().getDataFolder().getAbsoluteFile().getParentFile().listFiles()) {
            if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            YamlConfiguration config = null;
            try {
                config = ReflectionManager.getPluginYAMLEx(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (config == null || !pluginName.equalsIgnoreCase(config.getString("name"))) continue;
            files.add(file);
        }
        return files;
    }

    public static YamlConfiguration getPluginYAML(File file) {
        try {
            return ReflectionManager.getPluginYAMLEx(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static YamlConfiguration getPluginYAMLEx(File file) throws Exception {
        String s = ReflectionManager.getResourceAsString(file, "plugin.yml");
        if (s == null) {
            return null;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.loadFromString(ReflectionManager.getResourceAsString(file, "plugin.yml"));
        return config;
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean increment) {
        if (nmsReflection != null) {
            return nmsReflection.getNewEntityId(increment);
        }
        try {
            Number entityCount = (Number)entityCountField.get(null);
            if (increment) {
                if (NmsVersion.v1_14.isSupported()) {
                    return ((AtomicInteger)entityCount).incrementAndGet();
                }
                int id = entityCount.intValue();
                entityCountField.set(null, id + 1);
                return id;
            }
            return entityCount.intValue();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static WrapperPlayServerEntityMetadata getMetadataPacket(int entityId, List<WatcherValue> values) {
        ArrayList entityData = new ArrayList();
        values.forEach(v -> entityData.add(v.getDataValue()));
        return new WrapperPlayServerEntityMetadata(entityId, entityData);
    }

    public static Object getPlayerConnectionOrPlayer(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getPlayerConnectionOrPlayer(player);
        }
        try {
            return ReflectionManager.getNmsEntity((Entity)player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Object createEntityInstance(DisguiseType disguiseType, String entityName) {
        if (nmsReflection != null) {
            return nmsReflection.createEntityInstance(entityName);
        }
        try {
            Object entityObject;
            Class entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityName.equals("Player")) {
                Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                GameProfile profile = new GameProfile(new UUID(0L, 0L), "Steve");
                Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass(NmsVersion.v1_14.isSupported() ? "WorldServer" : "World")).newInstance(world);
                entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), profile.getClass(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, profile, playerinteractmanager);
            } else {
                entityObject = entityName.equals("EnderPearl") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow")) : (entityName.equals("FishingHook") ? (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityHuman"), ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"), world, 0, 0) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"))) : (!NmsVersion.v1_14.isSupported() && entityName.equals("Potion") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, SpigotReflectionUtil.toNMSItemStack((ItemStack)new ItemStack(Material.SPLASH_POTION))) : (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityTypes"), ReflectionManager.getNmsClass("World")).newInstance(ReflectionManager.getEntityType(disguiseType.getEntityType()), world) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world))));
            }
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 1, 1, 1);
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 0, 0, 0);
            return entityObject;
        }
        catch (Exception e) {
            DisguiseUtilities.getLogger().warning("Error while attempting to create entity instance for " + disguiseType.name());
            e.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        if (nmsReflection != null) {
            double x = nmsReflection.getXBoundingBox(entity);
            double y = nmsReflection.getYBoundingBox(entity);
            double z = nmsReflection.getZBoundingBox(entity);
            return new FakeBoundingBox(x, y, z);
        }
        try {
            Object boundingBox = boundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double") || Modifier.isStatic(field.getModifiers())) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerFromPlayerConnection(Object nmsEntity) {
        if (nmsReflection != null) {
            return nmsReflection.getPlayerFromPlayerConnection(nmsEntity);
        }
        try {
            return nmsEntity;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        if (nmsReflection != null) {
            return nmsReflection.getBukkitEntity(nmsEntity);
        }
        try {
            return (Entity)bukkitEntityMethod.invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        if (nmsReflection != null) {
            return nmsReflection.getBukkitItem(nmsItem);
        }
        try {
            return (ItemStack)itemAsBukkitMethod.invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isCraftItem(ItemStack bukkitItem) {
        return bukkitItem.getClass().getName().contains(".craftbukkit.");
    }

    public static ItemStack getCraftItem(ItemStack bukkitItem) {
        if (nmsReflection != null) {
            return nmsReflection.getCraftItem(bukkitItem);
        }
        try {
            return (ItemStack)itemAsCraftCopyMethod.invoke(null, bukkitItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NmsVersion getVersion() {
        if (craftbukkitVersion == null) {
            if (Bukkit.getServer() == null) {
                version = NmsVersion.values()[NmsVersion.values().length - 1];
            } else {
                ReflectionManager.getCraftBukkitPackage();
            }
        }
        return version;
    }

    public static String getMinecraftVersion() {
        if (minecraftVersion == null) {
            Matcher matcher = Pattern.compile(" \\(MC: ([^)]+?)\\)").matcher(Bukkit.getVersion());
            if (!matcher.find()) {
                throw new IllegalStateException("Lib's Disguises is unable to find and parse a ` (MC: 1.10.1)` version in Bukkit.getVersion()");
            }
            minecraftVersion = matcher.group(1);
        }
        return minecraftVersion;
    }

    @Deprecated
    public static String getNmsPackage() {
        String[] spl;
        if (craftbukkitVersion == null) {
            ReflectionManager.getCraftBukkitPackage();
        }
        if ((spl = craftbukkitVersion.split("\\.")).length != 4) {
            return "";
        }
        return spl[3];
    }

    public static String getCraftBukkitPackage() {
        if (craftbukkitVersion == null) {
            craftbukkitVersion = Bukkit.getServer().getClass().getPackage().getName();
            String mcVersion = ReflectionManager.getMinecraftVersion();
            for (NmsVersion v : NmsVersion.values()) {
                if (!v.isMinecraftVersion(mcVersion)) continue;
                version = v;
            }
        }
        return craftbukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("org.bukkit.craftbukkit", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReflectionManagerAbstract getReflectionManager(NmsVersion nmsVersion) {
        try {
            String versionName = nmsVersion.name();
            if (nmsVersion == NmsVersion.v1_18) {
                versionName = Bukkit.getVersion().contains("1.18.1") ? versionName + "_1" : versionName + "_2";
            }
            Class<?> aClass = Class.forName("me.libraryaddict.disguise.utilities.reflection." + versionName + ".ReflectionManager");
            Object o = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (ReflectionManagerAbstract)o;
        }
        catch (ClassNotFoundException versionName) {
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTrackerEntry(target);
        }
        Object world = ReflectionManager.getWorldServer(target.getWorld());
        if (NmsVersion.v1_14.isSupported()) {
            Object chunkProvider = chunkProviderField.get(world);
            Object chunkMap = chunkMapField.get(chunkProvider);
            Map trackedEntities = (Map)trackedEntitiesField.get(chunkMap);
            Object entityTracker = trackedEntities.get(target.getEntityId());
            if (entityTracker == null) {
                return null;
            }
            return entityTrackerField.get(entityTracker);
        }
        Object tracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(tracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    public static Object getMinecraftServer() {
        if (nmsReflection != null) {
            return nmsReflection.getMinecraftServer();
        }
        try {
            return getServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GameProfile convertProfile(UserProfile profile) {
        GameProfile gProfile = new GameProfile(profile.getUUID(), profile.getName());
        List textures = profile.getTextureProperties();
        for (TextureProperty property : textures) {
            gProfile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature()));
        }
        return gProfile;
    }

    public static PlayerProfile createProfile(UserProfile profile) {
        try {
            return (PlayerProfile)ReflectionManager.getCraftConstructor("CraftGameProfile", GameProfile.class).newInstance(ReflectionManager.convertProfile(profile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static GameProfile getGameProfile(Player player) {
        try {
            return (GameProfile)getGameProfile.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UserProfile getUserProfile(Player player) {
        return ReflectionManager.getUserProfile(ReflectionManager.getGameProfile(player));
    }

    public static UserProfile getUserProfile(GameProfile userProfile) {
        UserProfile uProfile = new UserProfile(userProfile.getId(), userProfile.getName());
        Collection textures = userProfile.getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return uProfile;
        }
        ArrayList<TextureProperty> properties = new ArrayList<TextureProperty>();
        try {
            for (Property property : textures) {
                String sig;
                String value;
                String name;
                if (propertyName != null) {
                    name = (String)propertyName.invoke((Object)property, new Object[0]);
                    value = (String)propertyValue.invoke((Object)property, new Object[0]);
                    sig = (String)propertySignature.invoke((Object)property, new Object[0]);
                } else {
                    name = property.name();
                    value = property.value();
                    sig = property.signature();
                }
                properties.add(new TextureProperty(name, value, sig));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        uProfile.setTextureProperties(properties);
        return uProfile;
    }

    public static UserProfile getUserProfile(UUID uuid, String playerName) {
        return ReflectionManagerAbstract.getUserProfile(uuid == null ? ReflectionManager.getRandomUUID() : uuid, playerName);
    }

    public static UserProfile getClonedProfile(UserProfile userProfile) {
        return ReflectionManager.getUserProfileWithThisSkin(null, userProfile.getName(), userProfile);
    }

    public static UserProfile getUserProfileWithThisSkin(UUID uuid, String playerName, UserProfile profileWithSkin) {
        try {
            UserProfile userProfile = new UserProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName == null || playerName.length() < 17 ? playerName : playerName.substring(0, 16));
            if (profileWithSkin != null) {
                userProfile.setTextureProperties(profileWithSkin.getTextureProperties());
            }
            return userProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static UUID getRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uuid;
        }
        return new UUID(uuid.getMostSignificantBits() & 0xFFFFFFFFFFFFBFFFL | (long)DisguiseConfig.getUUIDGeneratedVersion() << 12, uuid.getLeastSignificantBits());
    }

    private static String getLocation(String pack, String className) {
        return ClassMappings.getClass(pack, className);
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.getNmsEntity(entity);
        }
        try {
            return getNmsEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Set getClonedTrackedPlayers(Object entityTrackerEntry) {
        return (Set)new HashSet(ReflectionManager.getTrackedPlayers(entityTrackerEntry)).clone();
    }

    public static Set getTrackedPlayers(Object entityTrackerEntry) {
        return (Set)trackedPlayers.get(entityTrackerEntry);
    }

    public static boolean isEntityTrackerMoving(Object entityTrackerEntry) {
        return (Boolean)trackerIsMoving.get(entityTrackerEntry);
    }

    public static void clearEntityTracker(Object tracker, Object player) {
        clearEntityTracker.invoke(tracker, player);
    }

    public static void addEntityTracker(Object tracker, Object player) {
        addEntityTracker.invoke(tracker, player);
    }

    public static void addEntityToTrackedMap(Object tracker, Player player) {
        Object nmsEntity = ReflectionManager.getPlayerConnectionOrPlayer(player);
        if (!DisguiseUtilities.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
            ReflectionManager.getTrackedPlayers(tracker).add(nmsEntity);
        } else {
            Map map = (Map)trackedPlayersMap.get(tracker);
            map.put(nmsEntity, true);
        }
    }

    public static void removeEntityFromTracked(Object tracker, Player player) {
        Object nmsEntity = ReflectionManager.getPlayerConnectionOrPlayer(player);
        if (!DisguiseUtilities.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
            ReflectionManager.getTrackedPlayers(tracker).remove(nmsEntity);
        } else {
            Map map = (Map)trackedPlayersMap.get(tracker);
            map.remove(nmsEntity);
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getPing(player);
        }
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.getSize(entity);
        }
        try {
            if (NmsVersion.v1_14.isSupported()) {
                Object size = ReflectionManager.getNmsField("Entity", "size").get(ReflectionManager.getNmsEntity(entity));
                float width = ReflectionManager.getNmsField("EntitySize", "width").getFloat(size);
                float height = ReflectionManager.getNmsField("Entity", "headHeight").getFloat(ReflectionManager.getNmsEntity(entity));
                return new float[]{width, height};
            }
            float width = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float height = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static UserProfile getSkullBlob(UserProfile userProfile) {
        try {
            if (fillProfileProperties == null) {
                ProfileResult result = sessionService.fetchProfile(userProfile.getUUID(), true);
                if (result == null) {
                    return null;
                }
                return ReflectionManager.getUserProfile(result.profile());
            }
            GameProfile gameProfile = new GameProfile(userProfile.getUUID(), userProfile.getName());
            return ReflectionManager.getUserProfile((GameProfile)fillProfileProperties.invoke((Object)sessionService, gameProfile, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Float getSoundModifier(Object entity) {
        if (nmsReflection != null) {
            return nmsReflection.getSoundModifier(entity);
        }
        try {
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static UserProfile grabProfileAddUUID(String playername) {
        try {
            LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
            if (nmsReflection != null) {
                nmsReflection.injectCallback(playername, callback);
            } else {
                Object minecraftServer = ReflectionManager.getMinecraftServer();
                for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                    if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                    Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                    Object profileRepo = method.invoke(minecraftServer, new Object[0]);
                    method.getReturnType().getMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
                    break;
                }
            }
            if (callback.getUserProfile() != null) {
                return callback.getUserProfile();
            }
            return ReflectionManager.getUserProfile(null, playername);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox) {
        if (nmsReflection != null) {
            nmsReflection.setBoundingBox(entity, newBox.getX(), newBox.getY(), newBox.getZ());
            return;
        }
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - newBox.getX() / 2.0, loc.getY(), loc.getZ() - newBox.getZ() / 2.0, loc.getX() + newBox.getX() / 2.0, loc.getY() + newBox.getY(), loc.getZ() + newBox.getZ() / 2.0);
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static SoundCategory getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return SoundCategory.PLAYER;
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return SoundCategory.HOSTILE;
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return SoundCategory.AMBIENT;
        }
        return SoundCategory.NEUTRAL;
    }

    public static ItemStack getEquipment(org.bukkit.inventory.EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static String getSoundString(Sound sound) {
        if (nmsReflection != null) {
            return nmsReflection.getSoundString(sound);
        }
        try {
            if (soundGetMethod == null) {
                return soundEffectGetKey.get(soundEffectGetMethod.invoke(null, sound)).toString();
            }
            return (String)soundGetMethod.invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertMetaFromSerialized(MetaIndex<T> index, Object value) {
        if (index == MetaIndex.BOAT_TYPE_OLD) {
            return (T)TreeSpecies.getByData((byte)((byte)((Integer)value).intValue()));
        }
        if (index == MetaIndex.CAT_TYPE) {
            if (nmsReflection != null) {
                return (T)nmsReflection.getCatTypeFromInt((Integer)value);
            }
            return (T)Cat.Type.values()[(Integer)value];
        }
        if (index == MetaIndex.FROG_VARIANT) {
            if (nmsReflection != null) {
                return (T)nmsReflection.getFrogVariantFromInt((Integer)value);
            }
            return (T)Frog.Variant.values()[(Integer)value];
        }
        if (index == MetaIndex.PAINTING) {
            return (T)nmsReflection.getPaintingFromInt((Integer)value);
        }
        if (index == MetaIndex.WOLF_VARIANT) {
            return (T)nmsReflection.getWolfVariantFromInt((Integer)value);
        }
        if (index == MetaIndex.CAT_COLLAR || index == MetaIndex.WOLF_COLLAR) {
            return (T)((Object)AnimalColor.getColorByDye((Integer)value));
        }
        if (index.isItemStack()) {
            return (T)SpigotConversionUtil.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)((com.github.retrooper.packetevents.protocol.item.ItemStack)value));
        }
        if (index.isBlock() || index.isBlockOpt()) {
            return (T)WrappedBlockState.getByGlobalId((int)((Integer)value));
        }
        if (index == MetaIndex.AREA_EFFECT_CLOUD_COLOR) {
            return (T)Color.fromRGB((int)((Integer)value));
        }
        if (index == MetaIndex.PARROT_VARIANT) {
            return (T)Parrot.Variant.values()[(Integer)value];
        }
        if (index == MetaIndex.AXOLOTL_VARIANT) {
            return (T)Axolotl.Variant.values()[(Integer)value];
        }
        if (index == MetaIndex.OCELOT_TYPE) {
            return (T)Ocelot.Type.values()[(Integer)value];
        }
        if (index == MetaIndex.FOX_TYPE) {
            return (T)Fox.Type.values()[(Integer)value];
        }
        if (index == MetaIndex.RABBIT_TYPE) {
            return (T)RabbitType.getType((Integer)value);
        }
        if (index == MetaIndex.LLAMA_COLOR) {
            return (T)Llama.Color.values()[(Integer)value];
        }
        if (index == MetaIndex.PANDA_MAIN_GENE || index == MetaIndex.PANDA_HIDDEN_GENE) {
            return (T)Panda.Gene.values()[(Byte)value];
        }
        if (index == MetaIndex.ITEM_DISPLAY_TRANSFORM) {
            return (T)ItemDisplay.ItemDisplayTransform.values()[(Byte)value];
        }
        if (index == MetaIndex.BOAT_TYPE_NEW) {
            return (T)Boat.Type.values()[(Integer)value];
        }
        return (T)value;
    }

    public static Object convertMetaToSerialized(MetaIndex index, Object value) {
        if (value instanceof Optional) {
            if (!((Optional)value).isPresent()) {
                if (index.getDataType() == EntityDataTypes.OPTIONAL_BLOCK_STATE) {
                    return 0;
                }
                return value;
            }
            Object dVal = ((Optional)value).get();
            if (dVal instanceof WrappedBlockState) {
                value = dVal;
            }
        }
        if (value instanceof WrappedBlockState) {
            return ((WrappedBlockState)value).getGlobalId();
        }
        if (NmsVersion.v1_14.isSupported()) {
            if (value instanceof Cat.Type) {
                if (nmsReflection != null) {
                    return nmsReflection.getCatVariantAsInt((Cat.Type)value);
                }
                return ((Cat.Type)value).ordinal();
            }
            if (NmsVersion.v1_19_R1.isSupported()) {
                if (value instanceof Frog.Variant) {
                    return nmsReflection.getFrogVariantAsInt((Frog.Variant)value);
                }
                if (value instanceof Art) {
                    return nmsReflection.getPaintingAsInt((Art)value);
                }
                if (value instanceof Boat.Type) {
                    return ((Boat.Type)value).ordinal();
                }
                if (NmsVersion.v1_20_R4.isSupported() && value instanceof Wolf.Variant) {
                    return nmsReflection.getWolfVariantAsInt((Wolf.Variant)value);
                }
            }
        }
        if (value instanceof Color) {
            return ((Color)value).asRGB();
        }
        if (value instanceof TreeSpecies) {
            return (int)((TreeSpecies)value).getData();
        }
        if (value instanceof ItemStack) {
            return SpigotConversionUtil.fromBukkitItemStack((ItemStack)((ItemStack)value));
        }
        if (value instanceof Rabbit.Type) {
            return RabbitType.getTypeId((Rabbit.Type)value);
        }
        if (!(!(value instanceof Enum) || value instanceof SnifferState || value instanceof EntityPose || value instanceof BlockFace || value instanceof ArmadilloState)) {
            int v = ((Enum)value).ordinal();
            if (index.isByteValues()) {
                return (byte)v;
            }
            return v;
        }
        return value;
    }

    public static Material getMaterial(String name) {
        if (nmsReflection != null) {
            return nmsReflection.getMaterial(name);
        }
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                Method toMinecraft = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterialFromInternalName", String.class);
                Object instance = toMinecraft.getDeclaringClass().getField("INSTANCE").get(null);
                return (Material)toMinecraft.invoke(instance, name);
            }
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name.toLowerCase(Locale.ENGLISH));
            Object registry = ReflectionManager.getNmsField("IRegistry", "ITEM").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("RegistryMaterials"), "get", mcKey.getClass());
            Object item = getMethod.invoke(registry, mcKey);
            if (item == null) {
                return null;
            }
            Method getMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Item"));
            return (Material)getMaterial.invoke(null, item);
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().severe("Error when trying to convert '" + name + "' into a Material");
            ex.printStackTrace();
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            return null;
        }
    }

    public static String getItemName(Material material) {
        if (nmsReflection != null) {
            return nmsReflection.getItemName(material);
        }
        try {
            Object item = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getItem", Material.class).invoke(null, material);
            if (item == null) {
                return null;
            }
            Object registry = NmsVersion.v1_13.isSupported() ? ReflectionManager.getNmsField("IRegistry", "ITEM").get(null) : ReflectionManager.getNmsField("Item", "REGISTRY").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(registry.getClass(), NmsVersion.v1_13.isSupported() ? "getKey" : "b", Object.class);
            Object mcKey = getMethod.invoke(registry, item);
            if (mcKey == null) {
                return null;
            }
            return (String)ReflectionManager.getNmsMethod("MinecraftKey", "getKey", new Class[0]).invoke(mcKey, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean isAssignableFrom(Class toCheck, Class checkAgainst) {
        if (!NmsVersion.v1_14.isSupported() && toCheck != checkAgainst && toCheck == OcelotWatcher.class) {
            toCheck = TameableWatcher.class;
        }
        return checkAgainst.isAssignableFrom(toCheck);
    }

    public static Class getSuperClass(Class cl) {
        if (cl == FlagWatcher.class) {
            return null;
        }
        if (!NmsVersion.v1_14.isSupported() && cl == OcelotWatcher.class) {
            return TameableWatcher.class;
        }
        return cl.getSuperclass();
    }

    public static Object createMinecraftKey(String name) {
        if (nmsReflection != null) {
            return nmsReflection.createMinecraftKey(name);
        }
        try {
            return ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityType(EntityType entityType) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityType(entityType);
        }
        try {
            Object val = entityTypesAMethod.invoke(null, entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName());
            if (NmsVersion.v1_14.isSupported()) {
                return ((Optional)val).orElse(null);
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object registerEntityType(NamespacedKey key) {
        if (nmsReflection != null) {
            return nmsReflection.registerEntityType(key);
        }
        try {
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(key.toString());
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            Constructor<?> c = ReflectionManager.getNmsClass("EntityTypes").getConstructors()[0];
            Object entityType = NmsVersion.v1_16.isSupported() ? c.newInstance(null, null, false, false, false, false, null, null, 0, 0) : c.newInstance(null, null, false, false, false, false, null);
            for (Field f : entityType.getClass().getDeclaredFields()) {
                if (f.getType() != String.class) continue;
                f.setAccessible(true);
                f.set(entityType, key.toString());
                break;
            }
            typesClass.getMethod("a", typesClass, mcKey.getClass(), Object.class).invoke(null, registry, mcKey, entityType);
            return entityType;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + key);
        }
    }

    public static int getEntityTypeId(Object entityTypes) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTypeId(entityTypes);
        }
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityTypes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityTypes);
        }
    }

    public static int getEntityTypeId(EntityType entityType) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTypeId(entityType);
        }
        try {
            if (NmsVersion.v1_13.isSupported()) {
                Object entityTypes = ReflectionManager.getEntityType(entityType);
                Class typesClass = ReflectionManager.getNmsClass("IRegistry");
                Object registry = typesClass.getField("ENTITY_TYPE").get(null);
                return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityTypes);
            }
            return entityType.getTypeId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityType);
        }
    }

    public static Object getEntityType(NamespacedKey name) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityType(name);
        }
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name.toString());
            return registry.getClass().getMethod("a", mcKey.getClass()).invoke(registry, mcKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("The entity " + name + " is not registered!");
        }
    }

    public static EntityData getEntityData(MetaIndex index, Object obj, boolean bukkitReadable) {
        return new EntityData(index.getIndex(), index.getDataType(), bukkitReadable ? ReflectionManager.convertMetaToSerialized(index, obj) : obj);
    }

    public static int getCombinedIdByBlockData(BlockData data) {
        if (nmsReflection != null) {
            return nmsReflection.getCombinedIdByBlockData(data);
        }
        try {
            Object iBlockData = craftBlockDataGetState.invoke((Object)data, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        if (nmsReflection != null) {
            return nmsReflection.getCombinedIdByItemStack(itemStack);
        }
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                return itemStack.getType().ordinal() + (itemStack.getDurability() << 12);
            }
            Object nmsBlock = magicGetBlock.invoke(null, itemStack.getType());
            Object iBlockData = getBlockData.invoke(nmsBlock, new Object[0]);
            return (Integer)getBlockDataAsId.invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static BlockData getBlockDataByCombinedId(int id) {
        if (nmsReflection != null) {
            return nmsReflection.getBlockDataByCombinedId(id);
        }
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            return (BlockData)ReflectionManager.getCraftMethod("CraftBlockData", "fromData", iBlockClass).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemStackByCombinedId(int id) {
        if (nmsReflection != null) {
            return nmsReflection.getItemStackByCombinedId(id);
        }
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            Method getBlock = ReflectionManager.getNmsMethod(NmsVersion.v1_16.isSupported() ? iBlockClass.getSuperclass() : iBlockClass, "getBlock", new Class[0]);
            Object block = getBlock.invoke(iBlockData, new Object[0]);
            if (NmsVersion.v1_13.isSupported()) {
                return new ItemStack((Material)magicGetMaterial.invoke(null, block));
            }
            Method getItem = ReflectionManager.getNmsMethod("Block", "u", iBlockClass);
            return ReflectionManager.getBukkitItem(getItem.invoke(block, iBlockData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(World w) {
        if (nmsReflection != null) {
            return nmsReflection.getWorldServer(w);
        }
        try {
            return getNmsWorld.invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        if (nmsReflection != null) {
            return nmsReflection.getDeserializedItemMeta(meta);
        }
        try {
            return (ItemMeta)deserializedItemMeta.invoke(null, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<? extends FlagWatcher> getFlagWatcher(DisguiseType disguiseType) {
        Class watcherClass;
        try {
            switch (disguiseType) {
                case MARKER: {
                    watcherClass = FlagWatcher.class;
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    watcherClass = ItemFrameWatcher.class;
                    break;
                }
                case ARROW: {
                    watcherClass = TippedArrowWatcher.class;
                    break;
                }
                case MODDED_LIVING: 
                case MODDED_MISC: {
                    watcherClass = ModdedWatcher.class;
                    break;
                }
                case COD: 
                case SALMON: {
                    watcherClass = FishWatcher.class;
                    break;
                }
                case SPECTRAL_ARROW: {
                    watcherClass = ArrowWatcher.class;
                    break;
                }
                case PRIMED_TNT: {
                    watcherClass = TNTWatcher.class;
                    break;
                }
                case MINECART_CHEST: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    watcherClass = MinecartWatcher.class;
                    break;
                }
                case SPIDER: 
                case CAVE_SPIDER: {
                    watcherClass = SpiderWatcher.class;
                    break;
                }
                case PIG_ZOMBIE: 
                case HUSK: 
                case DROWNED: 
                case ZOMBIFIED_PIGLIN: {
                    watcherClass = ZombieWatcher.class;
                    break;
                }
                case MAGMA_CUBE: {
                    watcherClass = SlimeWatcher.class;
                    break;
                }
                case ELDER_GUARDIAN: {
                    watcherClass = GuardianWatcher.class;
                    break;
                }
                case ILLUSIONER: 
                case EVOKER: {
                    watcherClass = IllagerWizardWatcher.class;
                    break;
                }
                case PUFFERFISH: {
                    watcherClass = PufferFishWatcher.class;
                    break;
                }
                default: {
                    watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + ReflectionManager.toReadable(disguiseType.name()) + "Watcher");
                    break;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Class entityClass = disguiseType.getEntityType().getEntityClass();
            if (entityClass != null) {
                watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : (Fish.class.isAssignableFrom(entityClass) ? FishWatcher.class : FlagWatcher.class))));
            }
            watcherClass = FlagWatcher.class;
        }
        return watcherClass;
    }

    public static void registerValues() {
        int maxErrorsThrown = 5;
        for (DisguiseType disguiseType : DisguiseType.values()) {
            try {
                if (disguiseType.getEntityType() == null) continue;
                Class<? extends FlagWatcher> watcherClass = ReflectionManager.getFlagWatcher(disguiseType);
                if (watcherClass == null) {
                    DisguiseUtilities.getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                    continue;
                }
                if (LibsPremium.isPremium().booleanValue() && (LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().isPremium() && !LibsPremium.getPaidInformation().isLegit() || LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isLegit())) {
                    throw new IllegalStateException("Error while checking pi rate on startup! Please re-download the jar from SpigotMC before reporting this error!");
                }
                disguiseType.setWatcherClass(watcherClass);
                if (LibsDisguises.getInstance() == null || DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
                ReflectionManager.createNMSValues(disguiseType);
            }
            catch (Throwable throwable) {
                if (maxErrorsThrown-- <= 0) {
                    throw throwable;
                }
                throwable.printStackTrace();
            }
        }
    }

    public static byte[] readFuzzyFully(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    private static void createNMSValues(DisguiseType disguiseType) {
        String nmsEntityName = ReflectionManager.toReadable(disguiseType.name());
        Class nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
        if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
            Object[] split = ReflectionManager.splitReadable(disguiseType.name());
            ArrayUtils.reverse((Object[])split);
            nmsEntityName = StringUtils.join((Object[])split);
            nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
            if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                nmsEntityName = null;
            }
        }
        if (nmsEntityName == null) {
            switch (disguiseType) {
                case MARKER: 
                case GLOW_ITEM_FRAME: 
                case ALLAY: 
                case AXOLOTL: 
                case BLOCK_DISPLAY: 
                case INTERACTION: 
                case ITEM_DISPLAY: 
                case TEXT_DISPLAY: 
                case CHEST_BOAT: 
                case FROG: 
                case GLOW_SQUID: 
                case GOAT: 
                case TADPOLE: 
                case WARDEN: 
                case CAMEL: 
                case SNIFFER: 
                case BREEZE: 
                case WIND_CHARGE: 
                case BOGGED: 
                case ARMADILLO: 
                case BREEZE_WIND_CHARGE: 
                case OMINOUS_ITEM_SPAWNER: {
                    nmsEntityName = disguiseType.toReadable().replace(" ", "");
                    break;
                }
                case DONKEY: {
                    nmsEntityName = "HorseDonkey";
                    break;
                }
                case ARROW: {
                    nmsEntityName = "TippedArrow";
                    break;
                }
                case DROPPED_ITEM: {
                    nmsEntityName = "Item";
                    break;
                }
                case FIREBALL: {
                    nmsEntityName = "LargeFireball";
                    break;
                }
                case FIREWORK: {
                    nmsEntityName = "Fireworks";
                    break;
                }
                case GIANT: {
                    nmsEntityName = "GiantZombie";
                    break;
                }
                case HUSK: {
                    nmsEntityName = "ZombieHusk";
                    break;
                }
                case ILLUSIONER: {
                    nmsEntityName = "IllagerIllusioner";
                    break;
                }
                case LEASH_HITCH: {
                    nmsEntityName = "Leash";
                    break;
                }
                case MINECART: {
                    nmsEntityName = "MinecartRideable";
                    break;
                }
                case MINECART_COMMAND: {
                    nmsEntityName = "MinecartCommandBlock";
                    break;
                }
                case MINECART_TNT: {
                    nmsEntityName = "MinecartTNT";
                    break;
                }
                case MULE: {
                    nmsEntityName = "HorseMule";
                    break;
                }
                case PRIMED_TNT: {
                    nmsEntityName = "TNTPrimed";
                    break;
                }
                case PUFFERFISH: {
                    nmsEntityName = "PufferFish";
                    break;
                }
                case SPLASH_POTION: {
                    nmsEntityName = "Potion";
                    break;
                }
                case STRAY: {
                    nmsEntityName = "SkeletonStray";
                    break;
                }
                case TRADER_LLAMA: {
                    nmsEntityName = "LLamaTrader";
                    break;
                }
                case TRIDENT: {
                    nmsEntityName = "ThrownTrident";
                    break;
                }
                case WANDERING_TRADER: {
                    nmsEntityName = "VillagerTrader";
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    nmsEntityName = "PigZombie";
                    break;
                }
            }
        }
        try {
            Float soundStrength;
            if (disguiseType == DisguiseType.UNKNOWN || disguiseType.isCustom()) {
                DisguiseValues disguiseValues = new DisguiseValues(disguiseType, 0.0);
                disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                SoundGroup sound = SoundGroup.getGroup(disguiseType.name());
                if (sound != null) {
                    sound.setDamageAndIdleSoundVolume(1.0f);
                }
                return;
            }
            if (nmsEntityName == null) {
                DisguiseUtilities.getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                return;
            }
            Object nmsEntity = ReflectionManager.createEntityInstance(disguiseType, nmsReflection != null ? disguiseType.getEntityType().getKey().getKey() : nmsEntityName);
            if (nmsEntity == null) {
                DisguiseUtilities.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                return;
            }
            disguiseType.setTypeId(NmsVersion.v1_13.isSupported() ? ReflectionManager.getEntityType(disguiseType.getEntityType()) : null, ReflectionManager.getEntityTypeId(disguiseType.getEntityType()));
            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
            List<EntityData> watcher = ReflectionManager.getEntityWatcher(bukkitEntity);
            ArrayList<MetaIndex> indexes = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
            boolean loggedName = false;
            for (EntityData data : watcher) {
                MetaIndex metaIndex = MetaIndex.getMetaIndex(disguiseType.getWatcherClass(), data.getIndex());
                if (metaIndex == null) {
                    if (disguiseType == DisguiseType.GLOW_SQUID && data.getValue().getClass() == String.class) continue;
                    DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                    DisguiseUtilities.getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + data.getIndex());
                    DisguiseUtilities.getLogger().severe("Value: " + data.getValue() + " (" + data.getValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + disguiseType.getWatcherClass().getSimpleName());
                    continue;
                }
                indexes.remove(metaIndex);
                Object ourDefaultBukkit = metaIndex.getDefault();
                Object ourDefaultSerialized = ReflectionManager.convertMetaToSerialized(metaIndex, ourDefaultBukkit);
                Object minecraftDefaultBukkit = ReflectionManager.convertMetaFromSerialized(metaIndex, data.getValue());
                Object minecraftDefaultSerialized = data.getValue();
                if (minecraftDefaultBukkit == null) {
                    minecraftDefaultBukkit = "nullsy";
                }
                if (ourDefaultBukkit == null) {
                    ourDefaultBukkit = "nullsa";
                }
                if (minecraftDefaultBukkit.getClass().getSimpleName().equals("CraftItemStack") && ourDefaultBukkit.getClass().getSimpleName().equals("ItemStack")) {
                    ourDefaultBukkit = ReflectionManager.getCraftItem((ItemStack)ourDefaultBukkit);
                }
                if (ourDefaultBukkit.getClass() == minecraftDefaultBukkit.getClass() && metaIndex.getDataType() == data.getType() && minecraftDefaultSerialized.getClass() == ourDefaultSerialized.getClass()) continue;
                if (!loggedName) {
                    DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                    DisguiseUtilities.getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + nmsEntityName);
                    loggedName = true;
                }
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                DisguiseUtilities.getLogger().severe("Index: " + data.getIndex() + " | " + metaIndex.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(metaIndex));
                DisguiseUtilities.getLogger().severe("LibsDisguises Bukkit: " + ourDefaultBukkit + " (" + ourDefaultBukkit.getClass() + ")");
                DisguiseUtilities.getLogger().severe("LibsDisguises Serialized: " + ourDefaultSerialized + " (" + ourDefaultSerialized.getClass() + ")");
                DisguiseUtilities.getLogger().severe("LibsDisguises Data Type: " + metaIndex.getDataType().getName());
                DisguiseUtilities.getLogger().severe("Minecraft Bukkit: " + minecraftDefaultBukkit + " (" + minecraftDefaultBukkit.getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft Serialized: " + minecraftDefaultSerialized + " (" + minecraftDefaultSerialized.getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft Data Type: " + data.getType().getName());
                DisguiseUtilities.getLogger().severe("LibsDisguises Serializer Data Type: " + metaIndex.getDataType().getName());
                DisguiseUtilities.getLogger().severe("Minecraft Serializer Data Type: " + data.getType().getName());
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
            }
            for (MetaIndex index : indexes) {
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                DisguiseUtilities.getLogger().severe((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
            }
            SoundGroup sound = SoundGroup.getGroup(disguiseType.name());
            if (sound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
                if (disguiseType == DisguiseType.COW && soundStrength.floatValue() != 0.4f && !LibsDisguises.getInstance().isNumberedBuild()) {
                    DisguiseUtilities.getLogger().severe("The hurt sound volume may be wrong on the COW disguise! Bad nms update?");
                }
            }
            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
            if (bukkitEntity instanceof Ageable) {
                ((Ageable)bukkitEntity).setBaby();
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof Zombie) {
                ((Zombie)bukkitEntity).setBaby(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof ArmorStand) {
                ((ArmorStand)bukkitEntity).setSmall(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
            DisguiseUtilities.getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and PacketEvents.");
            DisguiseUtilities.getLogger().severe("Development builds are available at (PacketEvents) https://ci.codemc.io/job/retrooper/job/packetevents/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
            ex.printStackTrace();
        }
    }

    public static List<EntityData> getEntityWatcher(Entity entity) {
        try {
            ByteBuf buffer;
            if (nmsReflection != null) {
                buffer = nmsReflection.getDataWatcherValues(entity);
            } else {
                Object datawatcher = getDatawatcher.invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
                Map data = (Map)datawatcherData.get(datawatcher);
                buffer = PooledByteBufAllocator.DEFAULT.buffer();
                Object nmsBuff = SpigotReflectionUtil.createPacketDataSerializer((Object)buffer);
                datawatcherSerialize.invoke(null, new ArrayList(data.values()), nmsBuff);
            }
            PacketWrapper wrapper = PacketWrapper.createUniversalPacketWrapper((Object)buffer);
            List list = wrapper.readEntityMetadata();
            ByteBufHelper.release((Object)buffer);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setScore(Scoreboard scoreboard, String name, int score) {
        ReflectionManager.setScore(scoreboard, name, score, true);
    }

    public static void setScore(final Scoreboard scoreboard, final String name, final int score, boolean canScheduleTask) {
        if (NmsVersion.v1_20_R3.isSupported()) {
            return;
        }
        if (canScheduleTask && (!Bukkit.isPrimaryThread() || DisguiseUtilities.isRunningPaper())) {
            new BukkitRunnable(){

                public void run() {
                    ReflectionManager.setScore(scoreboard, name, score, false);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
            return;
        }
        Set objectives = scoreboard.getObjectivesByCriteria("health");
        for (Objective objective : objectives) {
            Score s = objective.getScore(name);
            s.setScore(score);
        }
    }

    public static Map<String, Command> getCommands(CommandMap map) {
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            return (Map)field.get(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static SimpleCommandMap getCommandMap() {
        try {
            Field commandMap = SimplePluginManager.class.getDeclaredField("commandMap");
            commandMap.setAccessible(true);
            return (SimpleCommandMap)commandMap.get(Bukkit.getPluginManager());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String[] splitReadable(String string) {
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].charAt(0) + split[i].substring(1).toLowerCase(Locale.ENGLISH);
        }
        return split;
    }

    public static String toReadable(String string) {
        return ReflectionManager.toReadable(string, "");
    }

    public static String toReadable(String string, String joiner) {
        return StringUtils.join((Object[])ReflectionManager.splitReadable(string), (String)joiner);
    }

    public static org.bukkit.inventory.EquipmentSlot getSlot(EquipmentSlot slot) {
        switch (slot) {
            case BOOTS: {
                return org.bukkit.inventory.EquipmentSlot.FEET;
            }
            case HELMET: {
                return org.bukkit.inventory.EquipmentSlot.HEAD;
            }
            case LEGGINGS: {
                return org.bukkit.inventory.EquipmentSlot.LEGS;
            }
            case MAIN_HAND: {
                return org.bukkit.inventory.EquipmentSlot.HAND;
            }
            case OFF_HAND: {
                return org.bukkit.inventory.EquipmentSlot.OFF_HAND;
            }
            case CHEST_PLATE: {
                return org.bukkit.inventory.EquipmentSlot.CHEST;
            }
        }
        throw new IllegalStateException("Unknown equip slot " + slot);
    }

    public static EquipmentSlot getSlot(org.bukkit.inventory.EquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return EquipmentSlot.BOOTS;
            }
            case OFF_HAND: {
                return EquipmentSlot.OFF_HAND;
            }
            case HEAD: {
                return EquipmentSlot.HELMET;
            }
            case HAND: {
                return EquipmentSlot.MAIN_HAND;
            }
            case CHEST: {
                return EquipmentSlot.CHEST_PLATE;
            }
            case LEGS: {
                return EquipmentSlot.LEGGINGS;
            }
        }
        throw new IllegalStateException("Unknown equip slot " + slot);
    }

    public static EntityDataType getEntityDataType(MetaIndex index, Field field) {
        try {
            if (index.isBlock()) {
                return EntityDataTypes.BLOCK_STATE;
            }
            if (index.isBlockOpt()) {
                return EntityDataTypes.OPTIONAL_BLOCK_STATE;
            }
            if (index.isItemStack()) {
                return EntityDataTypes.ITEMSTACK;
            }
            if (index == MetaIndex.WOLF_VARIANT) {
                return EntityDataTypes.WOLF_VARIANT;
            }
            if (index == MetaIndex.CAT_TYPE && NmsVersion.v1_19_R1.isSupported()) {
                return EntityDataTypes.CAT_VARIANT;
            }
            if (index == MetaIndex.FROG_VARIANT) {
                return EntityDataTypes.FROG_VARIANT;
            }
            if (index == MetaIndex.PAINTING) {
                return EntityDataTypes.PAINTING_VARIANT_TYPE;
            }
            if (index == MetaIndex.ENTITY_POSE) {
                return EntityDataTypes.ENTITY_POSE;
            }
            if (index == MetaIndex.SNIFFER_STATE) {
                return EntityDataTypes.SNIFFER_STATE;
            }
            if (index == MetaIndex.ARMADILLO_STATE) {
                return EntityDataTypes.ARMADILLO_STATE;
            }
            if (index == MetaIndex.SHULKER_FACING) {
                return EntityDataTypes.BLOCK_FACE;
            }
            if (index == MetaIndex.AREA_EFFECT_CLOUD_COLOR) {
                return EntityDataTypes.INT;
            }
            Type type1 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (type1 instanceof Class && Enum.class.isAssignableFrom((Class)type1)) {
                if (index.isByteValues()) {
                    return EntityDataTypes.BYTE;
                }
                return EntityDataTypes.INT;
            }
            if (type1 == ItemStack.class) {
                return EntityDataTypes.ITEMSTACK;
            }
            if (type1 == Integer.class) {
                return EntityDataTypes.INT;
            }
            if (type1 == Byte.class) {
                return EntityDataTypes.BYTE;
            }
            if (type1 == Vector3f.class) {
                if (index.isRotation()) {
                    return EntityDataTypes.ROTATION;
                }
                return EntityDataTypes.VECTOR3F;
            }
            if (type1 == String.class) {
                return EntityDataTypes.STRING;
            }
            ArrayList<EntityDataType> found = new ArrayList<EntityDataType>();
            for (Field f : EntityDataTypes.class.getFields()) {
                if (f.getType() != EntityDataType.class || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !(f.getGenericType() instanceof ParameterizedType)) continue;
                Type type2 = ((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                if (!type1.toString().equals(type2.toString())) continue;
                found.add((EntityDataType)f.get(null));
            }
            if (found.isEmpty()) {
                throw new IllegalStateException("Unable to find an entity type for " + field.getName() + ". Type is " + type1);
            }
            if (found.size() > 1) {
                for (EntityDataType type : found) {
                    DisguiseUtilities.getLogger().severe("Found multiple entity data type for " + field.getName() + " of type " + type1 + ": " + type.getName());
                }
            }
            return (EntityDataType)found.get(0);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReflectionManagerAbstract getNmsReflection() {
        return nmsReflection;
    }
}

