/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;

public class WatcherMethod {
    private final Class<? extends FlagWatcher> watcherClass;
    private final MethodHandle method;
    private final String mappedName;
    private final String name;
    private final Class returnType;
    private final Class param;
    private final boolean randomDefault;
    private final boolean hideFromTab;
    private final boolean[] unusableBy;
    private final boolean[] hiddenFor;

    public boolean isUsable(DisguiseType type) {
        return !this.unusableBy[type.ordinal()];
    }

    public boolean isHidden(DisguiseType type) {
        return !this.isUsable(type) || this.hiddenFor[type.ordinal()];
    }

    public String toString() {
        return "WatcherMethod{watcherClass=" + this.watcherClass + ", method=" + this.method + ", mappedName='" + this.mappedName + '\'' + ", name='" + this.name + '\'' + ", returnType=" + this.returnType + ", param=" + this.param + ", randomDefault=" + this.randomDefault + ", hideFromTab=" + this.hideFromTab + ", unusableBy=" + Arrays.toString(this.unusableBy) + ", hiddenFor=" + Arrays.toString(this.hiddenFor) + '}';
    }

    public WatcherMethod(Class<? extends FlagWatcher> watcherClass, MethodHandle method, String mappedName, String name, Class returnType, Class param, boolean randomDefault, boolean hideFromTab, boolean[] unusableBy, boolean[] hiddenFor) {
        this.watcherClass = watcherClass;
        this.method = method;
        this.mappedName = mappedName;
        this.name = name;
        this.returnType = returnType;
        this.param = param;
        this.randomDefault = randomDefault;
        this.hideFromTab = hideFromTab;
        this.unusableBy = unusableBy;
        this.hiddenFor = hiddenFor;
    }

    public Class<? extends FlagWatcher> getWatcherClass() {
        return this.watcherClass;
    }

    public MethodHandle getMethod() {
        return this.method;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class getParam() {
        return this.param;
    }

    public boolean isRandomDefault() {
        return this.randomDefault;
    }

    public boolean isHideFromTab() {
        return this.hideFromTab;
    }

    public boolean[] getUnusableBy() {
        return this.unusableBy;
    }

    public boolean[] getHiddenFor() {
        return this.hiddenFor;
    }
}

