/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.github.retrooper.packetevents.protocol.color.Color;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleBlockStateData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleColorData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustColorTransitionData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleItemStackData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleSculkChargeData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleShriekData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleVibrationData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.protocol.world.positionsource.builtin.BlockPositionSource;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.util.Vector3i;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoWrappedBlockData;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ParamInfoParticle
extends ParamInfoEnum {
    private final Material[] materials;
    private static final Map<String, ParticleInfo> particleMap = new HashMap<String, ParticleInfo>();

    public ParamInfoParticle(String name, String description, Material[] materials) {
        super((Class)Particle.class, name, description, particleMap);
        this.materials = materials;
    }

    private static void fillMap() {
        for (Field field : ParticleTypes.class.getFields()) {
            ParameterizedType pType;
            Type type;
            int mods = field.getModifiers();
            if (!Modifier.isFinal(mods) || !Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !((type = field.getGenericType()) instanceof ParameterizedType) || (pType = (ParameterizedType)type).getActualTypeArguments().length != 1 || pType.getRawType() != ParticleType.class) continue;
            ParticleType particleType = (ParticleType)field.get(null);
            Class dataClass = (Class)pType.getActualTypeArguments()[0];
            particleMap.put(particleType.getName().getKey(), new ParticleInfo(particleType, dataClass));
        }
    }

    @Override
    public boolean hasTabCompletion() {
        return true;
    }

    private String convertName(String oldName) {
        if (oldName.equalsIgnoreCase("ITEM_CRACK")) {
            return "ITEM";
        }
        if (oldName.equalsIgnoreCase("BLOCK_CRACK")) {
            return "BLOCK";
        }
        if (oldName.equalsIgnoreCase("BLOCK_DUST")) {
            return "FALLING_DUST";
        }
        return oldName;
    }

    @Override
    public Set<String> getEnums(String tabComplete) {
        HashSet<String> enums = new HashSet<String>(this.getValues().keySet());
        if (tabComplete.isEmpty()) {
            return enums;
        }
        String tabCompleteUpperCase = tabComplete.toUpperCase(Locale.ENGLISH);
        String[] blockDatas = new String[]{"BLOCK", "BLOCK_MARKER", "FALLING_DUST", "DUST_PILLAR"};
        for (int i = -1; i < blockDatas.length; ++i) {
            String particleName = i < 0 ? "ITEM" : blockDatas[i];
            enums.remove(particleName);
            for (Material mat : this.materials) {
                String name;
                if (!mat.isBlock() && i == -1 || !(name = particleName + ":" + mat.name()).startsWith(tabCompleteUpperCase)) continue;
                enums.add(name);
            }
        }
        String startsWith = tabComplete.split(":")[0];
        if (Stream.of(blockDatas).noneMatch(s -> s.equalsIgnoreCase(startsWith))) {
            return enums;
        }
        Set<String> newEnums = ParamInfoManager.getParamInfo(WrappedBlockState.class).getEnums(tabComplete.replaceAll("^" + startsWith + ":?", ""));
        if (newEnums == null) {
            return enums;
        }
        newEnums.forEach(s -> enums.add(startsWith + ":" + s));
        return enums;
    }

    private String colorToString(int color) {
        for (Map.Entry<String, org.bukkit.Color> entry : ParamInfoColor.getStaticColors().entrySet()) {
            org.bukkit.Color c = entry.getValue();
            if (c.asRGB() != color) continue;
            return entry.getKey();
        }
        return String.valueOf(color);
    }

    private String colorToString(float red, float green, float blue) {
        int r = (int)red * 255;
        int g = (int)green * 255;
        int b = (int)blue * 255;
        for (Map.Entry<String, org.bukkit.Color> entry : ParamInfoColor.getStaticColors().entrySet()) {
            org.bukkit.Color c = entry.getValue();
            if (r != c.getRed() || g != c.getGreen() || b != c.getBlue()) continue;
            return entry.getKey();
        }
        if (red % 1.0f == 0.0f && green % 1.0f == 0.0f && blue % 1.0f == 0.0f) {
            return (int)red + "," + (int)green + "," + (int)blue;
        }
        return red + "," + green + "," + blue;
    }

    @Override
    public String toString(Object object) {
        Particle particle = (Particle)object;
        ParticleData data = particle.getData();
        String returns = particle.getType().getName().getKey();
        if (data != null) {
            if (data instanceof ParticleItemStackData) {
                returns = returns + ":" + ((ParticleItemStackData)data).getItemStack().getType().getName().getKey();
            } else if (data instanceof ParticleBlockStateData) {
                returns = returns + ":" + ParamInfoManager.getParamInfo(WrappedBlockState.class).toString(((ParticleBlockStateData)data).getBlockState());
            } else if (data instanceof ParticleDustData) {
                ParticleDustData dust = (ParticleDustData)data;
                if (dust.getScale() != 1.0f) {
                    returns = returns + ":" + dust.getScale();
                }
                returns = returns + ":" + this.colorToString(dust.getRed(), dust.getGreen(), dust.getBlue());
            } else if (data instanceof ParticleColorData) {
                returns = returns + ":" + this.colorToString(((ParticleColorData)data).getColor());
            } else if (data instanceof ParticleDustColorTransitionData) {
                ParticleDustColorTransitionData dust = (ParticleDustColorTransitionData)data;
                returns = returns + ":";
                if (dust.getScale() != 1.0f) {
                    returns = returns + dust.getScale() + ":";
                }
                returns = returns + this.colorToString(dust.getStartRed(), dust.getStartGreen(), dust.getStartBlue());
                returns = returns + ":";
                returns = returns + this.colorToString(dust.getEndRed(), dust.getEndGreen(), dust.getEndBlue());
            } else if (data instanceof ParticleSculkChargeData) {
                returns = returns + ":" + ((ParticleSculkChargeData)data).getRoll();
            } else if (data instanceof ParticleVibrationData) {
                ParticleVibrationData vib = (ParticleVibrationData)data;
                @Nullable Vector3i start = vib.getStartingPosition();
                BlockPositionSource source = vib.getSource() instanceof BlockPositionSource ? (BlockPositionSource)vib.getSource() : new BlockPositionSource(new Vector3i(0, 0, 0));
                returns = returns + ":" + source.getPos().getX() + "," + source.getPos().getY() + "," + source.getPos().getZ();
                if (start != null) {
                    returns = returns + ":" + start.getX() + "," + start.getY() + "," + start.getZ();
                }
                returns = returns + ":" + vib.getTicks();
            } else if (data instanceof ParticleShriekData) {
                returns = returns + ":" + ((ParticleShriekData)data).getDelay();
            }
        }
        return returns;
    }

    @Override
    public Object fromString(String string) throws DisguiseParseException {
        String[] split = string.split("[:,]", -1);
        ParticleInfo info = (ParticleInfo)super.fromString(this.convertName(split[0]));
        if (info == null) {
            return null;
        }
        split = Arrays.copyOfRange(split, 1, split.length);
        String name = info.type.getName().getKey();
        ParticleType<?> pType = info.getType();
        Class<? extends ParticleData> cl = info.getData();
        ParticleBlockStateData data = null;
        if (cl == ParticleBlockStateData.class) {
            if (split.length == 0) {
                data = new ParticleBlockStateData(WrappedBlockState.getDefaultState((StateType)StateTypes.STONE));
            } else {
                try {
                    String unSplit = string.substring(string.split("[:,]", -1)[0].length() + 1);
                    if (unSplit.isEmpty()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                    }
                    WrappedBlockState state = (WrappedBlockState)((ParamInfoWrappedBlockData)ParamInfoManager.getParamInfo(WrappedBlockState.class)).fromString(unSplit);
                    if (state == null) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                    }
                    data = new ParticleBlockStateData(state);
                }
                catch (DisguiseParseException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                }
            }
        } else if (cl == ParticleItemStackData.class) {
            if (split.length > 0) {
                ItemStack item = ParamInfoItemStack.parseToItemstack(split);
                data = new ParticleItemStackData(SpigotConversionUtil.fromBukkitItemStack((ItemStack)item));
            } else {
                data = new ParticleItemStackData(com.github.retrooper.packetevents.protocol.item.ItemStack.builder().type(ItemTypes.STONE).build());
            }
        } else if (cl == ParticleDustData.class) {
            float[] color = new float[3];
            float scale = 1.0f;
            if (split.length > 0) {
                ColorParser parser = new ColorParser(split, true);
                if (!parser.canConsume()) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                }
                try {
                    color = parser.getColor();
                }
                catch (DisguiseParseException ex) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                }
                int remain = parser.getArgsRemaining();
                if (remain != 0) {
                    if (!split[0].matches("\\d+(\\.\\d+)?") || remain > 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                    }
                    scale = Float.parseFloat(split[0]);
                    scale = Math.min(100.0f, Math.max(0.2f, scale));
                }
            }
            data = new ParticleDustData(scale, color[0], color[1], color[2]);
        } else if (cl == ParticleDustColorTransitionData.class) {
            float[] color1;
            float[] color2;
            ColorParser parser = new ColorParser(split, true);
            try {
                color2 = parser.getColor();
                color1 = parser.getColor();
            }
            catch (Exception ex) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST_TRANSITION, name, string);
            }
            float scale = 1.0f;
            int remain = parser.getArgsRemaining();
            if (remain != 0) {
                if (!split[0].matches("\\d+(\\.\\d+)?") || remain > 1) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST_TRANSITION, name, string);
                }
                scale = Float.parseFloat(split[0]);
                scale = Math.min(100.0f, Math.max(0.2f, scale));
            }
            data = new ParticleDustColorTransitionData(scale, color1[0], color1[1], color1[2], color2[0], color2[1], color2[2]);
        } else if (cl == ParticleShriekData.class) {
            int delay = 60;
            if (split.length > 0) {
                if (split.length > 1 || !split[0].matches("\\d+")) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_SHRIEK, name, string);
                }
                delay = Integer.parseInt(split[0]);
            }
            data = new ParticleShriekData(delay);
        } else if (cl == ParticleSculkChargeData.class) {
            float roll = 60.0f;
            if (split.length > 0) {
                if (split.length > 1 || !split[0].matches("\\d+(\\.\\d+)")) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_SHULK_CHARGE, name, string);
                }
                roll = Float.parseFloat(split[0]);
            }
            data = new ParticleSculkChargeData(roll);
        } else if (cl == ParticleColorData.class) {
            int color = ParamInfoParticle.getColorAsInt(string, split, name);
            data = new ParticleColorData(color);
        } else if (cl == ParticleVibrationData.class) {
            if (split.length != 4 && split.length != 7) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_VIBRATION, name, string);
            }
            for (String s : split) {
                if (s.matches("-?\\d+")) continue;
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_VIBRATION, name, string);
            }
            Vector3i sourceBlock = new Vector3i(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            Vector3i startBlock = null;
            int ticks = Integer.parseInt(split[split.length - 1]);
            if (split.length == 7) {
                startBlock = new Vector3i(Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]));
            }
            data = new ParticleVibrationData(startBlock, sourceBlock, ticks);
        }
        if (data == null) {
            if (split.length > 0) {
                return null;
            }
            data = ParticleData.emptyData();
        }
        return new Particle(pType, (ParticleData)data);
    }

    private static int getColorAsInt(String string, String[] split, String name) throws DisguiseParseException {
        int color = 0;
        if (split.length == 1 && split[0].matches("-?\\d+")) {
            color = Integer.parseInt(split[0]);
        } else if (split.length > 0) {
            ColorParser parser = new ColorParser(split, false);
            try {
                float[] colors = parser.getColor();
                color = new Color((int)colors[0], (int)colors[1], (int)colors[2]).asRGB();
            }
            catch (Exception ex) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_COLOR, name, string);
            }
            if (parser.getArgsRemaining() > 0) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_COLOR, name, string);
            }
        }
        return color;
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }

    static {
        ParamInfoParticle.fillMap();
    }

    private static class ParticleInfo {
        private final ParticleType<?> type;
        private final Class<? extends ParticleData> data;

        public ParticleType<?> getType() {
            return this.type;
        }

        public Class<? extends ParticleData> getData() {
            return this.data;
        }

        public ParticleInfo(ParticleType<?> type, Class<? extends ParticleData> data) {
            this.type = type;
            this.data = data;
        }
    }

    private static class ColorParser {
        private final String[] split;
        private final boolean decimalPointColor;
        private int argsConsumed;

        public float[] getColor() throws DisguiseParseException {
            int need = this.getArgsNeed();
            int start = this.split.length - (this.argsConsumed + need);
            Object[] copyOf = Arrays.copyOfRange(this.split, start, start + need);
            this.argsConsumed += need;
            if (copyOf.length == 3) {
                return new float[]{Float.parseFloat(copyOf[0]), Float.parseFloat((String)copyOf[1]), Float.parseFloat((String)copyOf[2])};
            }
            if (copyOf[0].equals("-1")) {
                return new float[]{-1.0f, -1.0f, -1.0f};
            }
            org.bukkit.Color color = ((ParamInfoColor)ParamInfoManager.getParamInfo(org.bukkit.Color.class)).parseToColor(StringUtils.join((Object[])copyOf, (String)","));
            float r = color.getRed();
            float g = color.getGreen();
            float b = color.getBlue();
            if (this.decimalPointColor) {
                r /= 255.0f;
                g /= 255.0f;
                b /= 255.0f;
            }
            return new float[]{r, g, b};
        }

        public int getArgsRemaining() {
            return this.split.length - this.getArgsConsumed();
        }

        private int getArgsNeed() {
            return this.split[this.split.length - (1 + this.argsConsumed)].matches("-?\\d+(\\.\\d+)?") ? 3 : 1;
        }

        public boolean canConsume() {
            return this.getArgsRemaining() > 0 && this.split.length >= this.getArgsNeed() + this.getArgsConsumed();
        }

        public ColorParser(String[] split, boolean decimalPointColor) {
            this.split = split;
            this.decimalPointColor = decimalPointColor;
        }

        public int getArgsConsumed() {
            return this.argsConsumed;
        }
    }
}

