/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.TranslateType;

public abstract class ParamInfo<T> {
    private final Class paramClass;
    private final String descriptiveName;
    private final String name;
    private Map<String, T> possibleValues;
    private String[] otherValues;
    private final String description;

    public ParamInfo(Class<T> paramClass, String name, String description) {
        this(paramClass, name, name, description);
    }

    public ParamInfo(Class<T> paramClass, String name, String descriptiveName, String description) {
        this.name = name;
        this.paramClass = paramClass;
        this.descriptiveName = descriptiveName;
        this.description = description;
    }

    public ParamInfo(Class<T> paramClass, String name, String description, T[] possibleValues) {
        this(paramClass, name, name, description, possibleValues);
    }

    public ParamInfo(Class<T> paramClass, String name, String descriptiveName, String description, T[] possibleValues) {
        this(paramClass, name, descriptiveName, description);
        this.possibleValues = new LinkedHashMap<String, T>();
        for (T anEnum : possibleValues) {
            this.getValues().put(((Enum)anEnum).name(), anEnum);
        }
    }

    public ParamInfo(Class<T> paramClass, String name, String description, Map<String, T> possibleValues) {
        this(paramClass, name, name, description, possibleValues);
    }

    public ParamInfo(Class<T> paramClass, String name, String descriptiveName, String description, Map<String, T> possibleValues) {
        this(paramClass, name, descriptiveName, description);
        this.possibleValues = new LinkedHashMap<String, T>();
        this.possibleValues.putAll(possibleValues);
    }

    public boolean canTranslateValues() {
        return this.getValues() != null;
    }

    public String[] getOtherValues() {
        return this.otherValues;
    }

    public void setOtherValues(String ... otherValues) {
        if (this.otherValues != null) {
            this.otherValues = Arrays.copyOf(this.otherValues, this.otherValues.length + otherValues.length);
            for (int i = 0; i < otherValues.length; ++i) {
                this.otherValues[this.otherValues.length - (otherValues.length - i)] = otherValues[i];
            }
        } else {
            this.otherValues = otherValues;
        }
    }

    public boolean canReturnNull() {
        return false;
    }

    protected abstract T fromString(String var1) throws DisguiseParseException;

    public abstract String toString(T var1);

    public T fromString(List<String> arguments) throws DisguiseParseException {
        String string = arguments.get(0);
        T value = this.fromString(string);
        if (value == null && !this.canReturnNull()) {
            throw new IllegalArgumentException();
        }
        arguments.remove(0);
        return value;
    }

    public int getMinArguments() {
        return 1;
    }

    public boolean hasTabCompletion() {
        return this.getValues() != null;
    }

    protected Class getParamClass() {
        return this.paramClass;
    }

    public boolean isParam(Class paramClass) {
        return this.getParamClass() == paramClass;
    }

    public String getName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawName());
    }

    public String getDescriptiveName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescriptiveName());
    }

    public String getRawName() {
        return this.name;
    }

    public String getRawDescriptiveName() {
        return this.descriptiveName;
    }

    public String getDescription() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescription());
    }

    public String getRawDescription() {
        return this.description;
    }

    public Map<String, T> getValues() {
        return this.possibleValues;
    }

    public Set<String> getEnums(String tabComplete) {
        if (this.getOtherValues() != null) {
            HashSet<String> set = new HashSet<String>(this.getValues().keySet());
            set.addAll(Arrays.asList(this.getOtherValues()));
            return set;
        }
        return this.getValues().keySet();
    }

    public boolean isCustomValues() {
        return true;
    }
}

