/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAnimationCollect;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAttachEntity;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAttributes;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerEntityStatus;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerEquipment;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerHeadLook;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerMetadata;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerMovement;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerSpawn;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerVelocity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketsHandler {
    private final IPacketHandler[] packetHandlers = new IPacketHandler[PacketType.Play.Server.values().length];

    public PacketsHandler() {
        this.registerPacketHandlers();
    }

    private void registerPacketHandlers() {
        ArrayList<IPacketHandler<Object>> packetHandlers = new ArrayList<IPacketHandler<Object>>();
        packetHandlers.add(new PacketHandlerAttributes());
        packetHandlers.add(new PacketHandlerAnimationCollect());
        packetHandlers.add(new PacketHandlerEntityStatus());
        packetHandlers.add(new PacketHandlerEquipment());
        packetHandlers.add(new PacketHandlerAttachEntity());
        packetHandlers.add(new PacketHandlerHeadLook());
        if (!LibsPremium.isPremium().booleanValue() || LibsDisguises.getInstance().getBuildNo().matches("\\d+") || LibsPremium.getPaidInformation() != null) {
            packetHandlers.add(new PacketHandlerMetadata());
        }
        packetHandlers.add(new PacketHandlerMovement());
        packetHandlers.add(new PacketHandlerSpawn());
        packetHandlers.add(new PacketHandlerVelocity());
        for (IPacketHandler iPacketHandler : packetHandlers) {
            for (PacketTypeCommon packetType : iPacketHandler.getHandledPackets()) {
                this.packetHandlers[((Enum)packetType).ordinal()] = iPacketHandler;
            }
        }
    }

    public LibsPackets transformPacket(PacketPlaySendEvent sentEvent, Disguise disguise, Player observer, Entity entity) {
        if (disguise.getType() == DisguiseType.UNKNOWN) {
            return new LibsPackets<Object>(null, disguise);
        }
        return this.transformPacket(DisguiseUtilities.constructWrapper(sentEvent), disguise, observer, entity);
    }

    public LibsPackets transformPacket(PacketWrapper sentPacket, Disguise disguise, Player observer, Entity entity) {
        LibsPackets<PacketWrapper> packets = new LibsPackets<PacketWrapper>(sentPacket, disguise);
        if (disguise.getType() == DisguiseType.UNKNOWN) {
            return packets;
        }
        try {
            packets.addPacket(sentPacket);
            IPacketHandler handler = this.packetHandlers[((Enum)sentPacket.getPacketTypeData().getPacketType()).ordinal()];
            if (handler != null) {
                handler.handle(disguise, packets, observer, entity);
                return packets;
            }
            packets.setUnhandled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packets;
    }
}

