/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.inventory.MainHand;

public class InsentientWatcher
extends LivingWatcher {
    public InsentientWatcher(Disguise disguise) {
        super(disguise);
    }

    public MainHand getMainHand() {
        return this.getInsentientFlag(2) ? MainHand.RIGHT : MainHand.LEFT;
    }

    public void setMainHand(MainHand mainHand) {
        this.setInsentientFlag(2, mainHand == MainHand.RIGHT);
    }

    public boolean isAI() {
        return this.getInsentientFlag(1);
    }

    public void setAI(boolean ai) {
        this.setInsentientFlag(1, ai);
    }

    private void setInsentientFlag(int i, boolean flag) {
        byte b0 = this.getData(MetaIndex.INSENTIENT_META);
        if (flag) {
            this.setData(MetaIndex.INSENTIENT_META, (byte)(b0 | i));
        } else {
            this.setData(MetaIndex.INSENTIENT_META, (byte)(b0 & -(i + 1)));
        }
        this.sendData(MetaIndex.INSENTIENT_META);
    }

    private boolean getInsentientFlag(int i) {
        return (this.getData(MetaIndex.INSENTIENT_META) & i) != 0;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isEnraged() {
        return this.getInsentientFlag(4);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setEnraged(boolean enraged) {
        if (this.hasValue(MetaIndex.INSENTIENT_META) && this.getInsentientFlag(4) == enraged) {
            return;
        }
        this.setInsentientFlag(4, enraged);
    }
}

