/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;

@NmsAddedIn(value=NmsVersion.v1_14)
public class CatWatcher
extends TameableWatcher {
    public CatWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            Cat.Type[] values = Cat.Type.values();
            this.setType(values[DisguiseUtilities.getRandom().nextInt(values.length)]);
        }
    }

    public Cat.Type getType() {
        return this.getData(MetaIndex.CAT_TYPE);
    }

    @RandomDefaultValue
    @MethodDescription(value="What variant of Cat is this?")
    public void setType(Cat.Type type) {
        this.setData(MetaIndex.CAT_TYPE, type);
        this.sendData(MetaIndex.CAT_TYPE);
    }

    public DyeColor getCollarColor() {
        return this.getData(MetaIndex.CAT_COLLAR).getDyeColor();
    }

    @Deprecated
    public void setCollarColor(AnimalColor color) {
        this.setCollarColor(color.getDyeColor());
    }

    @MethodDescription(value="What's the Cat's collar color?")
    public void setCollarColor(DyeColor newColor) {
        if (!this.isTamed()) {
            this.setTamed(true);
        }
        if (this.hasValue(MetaIndex.CAT_COLLAR) && newColor == this.getCollarColor()) {
            return;
        }
        this.setData(MetaIndex.CAT_COLLAR, AnimalColor.getColorByWool(newColor.getWoolData()));
        this.sendData(MetaIndex.CAT_COLLAR);
    }

    public boolean isLyingDown() {
        return this.getData(MetaIndex.CAT_LYING_DOWN);
    }

    @MethodDescription(value="Is the Cat lying down?")
    public void setLyingDown(boolean value) {
        this.setData(MetaIndex.CAT_LYING_DOWN, value);
        this.sendData(MetaIndex.CAT_LYING_DOWN);
    }

    public boolean isLookingUp() {
        return this.getData(MetaIndex.CAT_LOOKING_UP);
    }

    @MethodDescription(value="Is the Cat looking upwards?")
    public void setLookingUp(boolean value) {
        this.setData(MetaIndex.CAT_LOOKING_UP, value);
        this.sendData(MetaIndex.CAT_LOOKING_UP);
    }
}

