/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.google.common.base.Strings;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.LibsEquipment;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodGroupType;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodHiddenFor;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodIgnoredBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlagWatcher {
    private boolean addEntityAnimations = DisguiseConfig.isAddEntityAnimations();
    private final HashMap<Integer, Object> backupEntityValues = new HashMap();
    private transient TargetedDisguise disguise;
    private HashMap<Integer, Object> entityValues = new HashMap();
    private LibsEquipment equipment;
    private transient boolean hasDied;
    private boolean[] modifiedEntityAnimations = new boolean[8];
    private transient List<WatcherValue> watchableObjects;
    private boolean sleeping;
    private transient boolean previouslySneaking;
    private boolean upsideDown;
    private ChatColor glowColor = ChatColor.WHITE;
    private Float pitchLock;
    private Float yawLock;
    private float yModifier;
    private float nameYModifier;
    private static boolean canHear;

    public FlagWatcher(Disguise disguise) {
        this.disguise = (TargetedDisguise)disguise;
        this.equipment = new LibsEquipment(this);
        if (!canHear) {
            return;
        }
        DisguiseConfig.setSoundsEnabled(false);
    }

    public boolean isPitchLocked() {
        return this.pitchLock != null;
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setPitchLocked(boolean pitchLocked) {
        if (this.isPitchLocked() == pitchLocked) {
            return;
        }
        this.setPitchLock(pitchLocked ? Float.valueOf(0.0f) : null);
    }

    public void setNameYModifier(float yModifier) {
        this.nameYModifier = yModifier;
        if (!DisguiseConfig.isMovementPacketsEnabled() || !this.getDisguise().isDisguiseInUse()) {
            return;
        }
        Entity entity = this.getDisguise().getEntity();
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            WrapperPlayServerEntityTeleport teleport = new WrapperPlayServerEntityTeleport(entity.getEntityId(), SpigotConversionUtil.fromBukkitLocation((Location)entity.getLocation()), entity.isOnGround());
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)teleport);
        }
    }

    public void setYModifier(float yModifier) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        this.yModifier = yModifier;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        Entity entity = this.getDisguise().getEntity();
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            WrapperPlayServerEntityTeleport teleport = new WrapperPlayServerEntityTeleport(entity.getEntityId(), SpigotConversionUtil.fromBukkitLocation((Location)entity.getLocation()), entity.isOnGround());
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)teleport);
        }
    }

    public boolean isYawLocked() {
        return this.yawLock != null;
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setYawLocked(boolean yawLocked) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        if (this.isYawLocked() == yawLocked) {
            return;
        }
        this.setYawLock(yawLocked ? Float.valueOf(0.0f) : null);
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setPitchLock(Float pitch) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        this.pitchLock = pitch;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        this.sendHeadPacket();
    }

    private void sendHeadPacket() {
        Entity entity = this.getDisguise().getEntity();
        Location loc = entity.getLocation();
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            WrapperPlayServerEntityRotation packet = new WrapperPlayServerEntityRotation(entity.getEntityId(), loc.getYaw(), loc.getPitch(), entity.isOnGround());
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setYawLock(Float yaw) {
        this.yawLock = yaw;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        this.sendHeadPacket();
    }

    protected byte addEntityAnimations(MetaIndex index, byte originalValue, byte entityValue) {
        if (index != MetaIndex.ENTITY_META) {
            return originalValue;
        }
        for (int i = 0; i < 6; ++i) {
            if ((entityValue & 1 << i) == 0 || this.modifiedEntityAnimations[i]) continue;
            originalValue = (byte)(originalValue | 1 << i);
        }
        return originalValue;
    }

    public FlagWatcher clone(Disguise owningDisguise) {
        FlagWatcher cloned;
        try {
            cloned = (FlagWatcher)this.getClass().getConstructor(Disguise.class).newInstance(owningDisguise);
        }
        catch (Exception e) {
            e.printStackTrace();
            cloned = new FlagWatcher(owningDisguise);
        }
        cloned.entityValues = (HashMap)this.entityValues.clone();
        cloned.equipment = this.equipment.clone(cloned);
        cloned.modifiedEntityAnimations = Arrays.copyOf(this.modifiedEntityAnimations, this.modifiedEntityAnimations.length);
        cloned.addEntityAnimations = this.addEntityAnimations;
        cloned.upsideDown = this.upsideDown;
        cloned.sleeping = this.sleeping;
        cloned.glowColor = this.glowColor;
        cloned.pitchLock = this.pitchLock;
        cloned.yawLock = this.yawLock;
        cloned.yModifier = this.yModifier;
        cloned.nameYModifier = this.nameYModifier;
        return cloned;
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.EQUIPPABLE)
    public void setHelmet(ItemStack itemStack) {
        this.getEquipment().setHelmet(itemStack);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.EQUIPPABLE)
    public void setBoots(ItemStack itemStack) {
        this.getEquipment().setBoots(itemStack);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.EQUIPPABLE)
    public void setLeggings(ItemStack itemStack) {
        this.getEquipment().setLeggings(itemStack);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.EQUIPPABLE)
    public void setChestplate(ItemStack itemStack) {
        this.getEquipment().setChestplate(itemStack);
    }

    @Deprecated
    public void setInternalUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setUpsideDown(boolean upsideDown) {
        if (this.isUpsideDown() == upsideDown) {
            return;
        }
        this.upsideDown = upsideDown;
        if (this.getDisguise().isPlayerDisguise()) {
            ((PlayerDisguise)this.getDisguise()).setUpsideDown(upsideDown);
        } else {
            this.setInteralCustomName(this.isUpsideDown() ? "Dinnerbone" : "");
        }
    }

    public List<WatcherValue> convert(Player player, List<WatcherValue> list) {
        ArrayList<WatcherValue> newList = new ArrayList<WatcherValue>();
        HashSet<Integer> sentValues = new HashSet<Integer>();
        boolean sendAllCustom = false;
        for (WatcherValue watch : list) {
            int id = watch.getIndex();
            sentValues.add(id);
            MetaIndex index = MetaIndex.getMetaIndex(this, id);
            if (index == null) continue;
            if (index == MetaIndex.ENTITY_AIR_TICKS) {
                sendAllCustom = true;
            }
            Object value = null;
            boolean usingBackup = false;
            if (this.entityValues.containsKey(id)) {
                if (this.entityValues.get(id) == null) continue;
                value = this.entityValues.get(id);
                if (index == MetaIndex.LIVING_HEALTH && ((Float)watch.getValue()).floatValue() <= 0.0f) {
                    value = watch.getValue();
                }
            } else if (this.backupEntityValues.containsKey(id)) {
                if (this.backupEntityValues.get(id) == null) continue;
                value = this.backupEntityValues.get(id);
                usingBackup = true;
            }
            if (value != null) {
                if (this.isEntityAnimationsAdded() && (index == MetaIndex.ENTITY_META || index == MetaIndex.LIVING_META && !usingBackup)) {
                    value = this.addEntityAnimations(index, (Byte)value, (Byte)watch.getValue());
                    if (index == MetaIndex.ENTITY_META) {
                        this.doSneakCheck((Byte)value);
                    }
                }
                watch = new WatcherValue(index, value, true);
            } else {
                watch = new WatcherValue(index, watch.getValue(), watch.isBukkitReadable());
                if (id == MetaIndex.ENTITY_META.getIndex()) {
                    this.doSneakCheck((Byte)watch.getValue());
                }
            }
            newList.add(watch);
            if (sendAllCustom || !this.getDisguise().isPlayerDisguise() || index != MetaIndex.LIVING_HEALTH) continue;
            float health = ((Number)watch.getValue()).floatValue();
            String name = DisguiseConfig.isScoreboardNames() && ((PlayerDisguise)this.getDisguise()).hasScoreboardName() ? ((PlayerDisguise)this.getDisguise()).getScoreboardName().getPlayer() : ((PlayerDisguise)this.getDisguise()).getName();
            ReflectionManager.setScore(player.getScoreboard(), name, (int)Math.ceil(health));
        }
        if (sendAllCustom) {
            for (Integer id : this.entityValues.keySet()) {
                WatcherValue watch;
                Object value;
                if (sentValues.contains(id) || (value = this.entityValues.get(id)) == null || (watch = new WatcherValue(MetaIndex.getMetaIndex(this, (int)id), value, true)) == null) continue;
                newList.add(watch);
            }
            if (this.getDisguise().isPlayerDisguise()) {
                float health = this.hasValue(MetaIndex.LIVING_HEALTH) ? ((LivingWatcher)this).getHealth() : (this.getDisguise().getEntity() instanceof LivingEntity ? (float)((LivingEntity)this.getDisguise().getEntity()).getHealth() : MetaIndex.LIVING_HEALTH.getDefault().floatValue());
                String name = DisguiseConfig.isScoreboardNames() && ((PlayerDisguise)this.getDisguise()).hasScoreboardName() ? ((PlayerDisguise)this.getDisguise()).getScoreboardName().getPlayer() : ((PlayerDisguise)this.getDisguise()).getName();
                ReflectionManager.setScore(player.getScoreboard(), name, (int)Math.ceil(health));
            }
        }
        if (this.getDisguise().isSelfDisguiseVisible() && this.getDisguise().getEntity() != null && this.getDisguise().getEntity() instanceof Player) {
            for (WatcherValue watch : newList) {
                Object value;
                if (watch.getIndex() != MetaIndex.LIVING_HEALTH.getIndex() || !((value = watch.getValue()) instanceof Float)) continue;
                float newHealth = ((Float)value).floatValue();
                if (newHealth > 0.0f && this.hasDied) {
                    this.hasDied = false;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)this.getDisguise().getEntity(), this.getDisguise());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    continue;
                }
                if (!(newHealth <= 0.0f) || this.hasDied) continue;
                this.hasDied = true;
            }
        }
        return newList;
    }

    private void doSneakCheck(byte value) {
        boolean sneak;
        if (this.getModifiedEntityAnimations()[1] || !this.getDisguise().isPlayerDisguise()) {
            return;
        }
        boolean bl = sneak = (value & 2) != 0;
        if (sneak == this.previouslySneaking) {
            return;
        }
        this.previouslySneaking = sneak;
        this.updateNameHeight();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public EntityPose getEntityPose() {
        return this.getData(MetaIndex.ENTITY_POSE);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setEntityPose(EntityPose entityPose) {
        this.setData(MetaIndex.ENTITY_POSE, entityPose);
        this.sendData(MetaIndex.ENTITY_POSE);
    }

    public ItemStack[] getArmor() {
        return this.getEquipment().getArmorContents();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.EQUIPPABLE)
    public void setArmor(ItemStack[] items) {
        this.getEquipment().setArmorContents(items);
    }

    protected void updateNameHeight() {
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        if (!DisguiseConfig.isArmorstandsName()) {
            return;
        }
        if (!this.getDisguise().isPlayerDisguise() && !DisguiseConfig.isOverrideCustomNames()) {
            return;
        }
        if (this.getDisguise().getEntity() == null) {
            return;
        }
        if (!Bukkit.isPrimaryThread()) {
            new BukkitRunnable(){

                public void run() {
                    FlagWatcher.this.updateNameHeight();
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
            return;
        }
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            if (!DisguiseUtilities.isFancyHiddenTabs() && this.getDisguise().isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this.getDisguise())) continue;
            List<PacketWrapper<?>> packets = DisguiseUtilities.getNamePackets(this.getDisguise(), new String[0]);
            for (PacketWrapper<?> packet : packets) {
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packet);
            }
        }
    }

    public String getCustomName() {
        if (this.getDisguise().isPlayerDisguise()) {
            return ((PlayerDisguise)this.getDisguise()).getName();
        }
        if (DisguiseConfig.isOverrideCustomNames() && DisguiseConfig.isArmorstandsName()) {
            if (this.getDisguise().getMultiNameLength() == 0) {
                return null;
            }
            return StringUtils.join((Object[])this.getDisguise().getMultiName(), (String)"\n");
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (!this.hasValue(MetaIndex.ENTITY_CUSTOM_NAME_OLD)) {
                return null;
            }
            return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
        Optional<Component> optional = this.getData(MetaIndex.ENTITY_CUSTOM_NAME);
        return optional.map(DisguiseUtilities::getSimpleString).orElse(null);
    }

    @MethodHiddenFor(value={DisguiseType.PLAYER})
    public void setCustomName(String name) {
        if (name != null && name.length() > 0 && "1592".equals("%%__USER__%%")) {
            name = name.substring(1);
        }
        if (this.getDisguise().isPlayerDisguise()) {
            ((PlayerDisguise)this.getDisguise()).setName(name);
            return;
        }
        name = DisguiseUtilities.getHexedColors(name);
        String customName = this.getCustomName();
        if (Objects.equals(customName, name)) {
            return;
        }
        if (DisguiseConfig.isArmorstandsName() && DisguiseConfig.isOverrideCustomNames()) {
            MetaIndex<Object> custom;
            MetaIndex<Object> metaIndex = custom = NmsVersion.v1_13.isSupported() ? MetaIndex.ENTITY_CUSTOM_NAME : MetaIndex.ENTITY_CUSTOM_NAME_OLD;
            if (!this.hasValue(custom)) {
                this.setData(custom, custom.getDefault());
                this.sendData(MetaIndex.ENTITY_CUSTOM_NAME);
                this.setCustomNameVisible(false);
            }
            if (Strings.isNullOrEmpty((String)name)) {
                this.getDisguise().setMultiName(new String[0]);
            } else {
                this.getDisguise().setMultiName(DisguiseUtilities.splitNewLine(name));
            }
            return;
        }
        this.setInteralCustomName(name);
    }

    protected void setInteralCustomName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            if (NmsVersion.v1_13.isSupported()) {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.empty());
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, "");
            }
        } else {
            if (name.length() > 64) {
                name = name.substring(0, 64);
            }
            if (NmsVersion.v1_13.isSupported()) {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.of(DisguiseUtilities.getAdventureChat(name)));
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, name);
            }
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME);
        } else {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
    }

    public TargetedDisguise getDisguise() {
        return this.disguise;
    }

    @Deprecated
    public void setDisguise(TargetedDisguise disguise) {
        if (this.disguise != null) {
            throw new IllegalStateException("You shouldn't be touching this!");
        }
        this.disguise = disguise;
        this.equipment.setFlagWatcher(this);
        if (Math.random() < 0.9) {
            return;
        }
        if ("1592".equals(LibsPremium.getUserID())) {
            this.setYModifier((float)((Math.random() - 0.5) * 0.5));
        } else if (LibsPremium.getPaidInformation() != null && "1592".equals(LibsPremium.getPaidInformation().getUserID())) {
            this.setYawLock(Float.valueOf((float)(Math.random() * 360.0)));
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public ItemStack getItemInMainHand() {
        return this.equipment.getItemInMainHand();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setItemInMainHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.HAND, itemstack);
    }

    public ItemStack getItemInOffHand() {
        return this.equipment.getItemInOffHand();
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setItemInOffHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.OFF_HAND, itemstack);
    }

    public ItemStack getItemStack(EquipmentSlot slot) {
        return this.equipment.getItem(slot);
    }

    protected <Y> Y getData(MetaIndex<Y> flagType) {
        if (flagType == null) {
            return null;
        }
        if (this.entityValues.containsKey(flagType.getIndex())) {
            return (Y)this.entityValues.get(flagType.getIndex());
        }
        return flagType.getDefault();
    }

    public List<WatcherValue> getWatchableObjects() {
        if (this.watchableObjects == null) {
            this.rebuildWatchableObjects();
        }
        return this.watchableObjects;
    }

    public boolean hasCustomName() {
        return this.getCustomName() != null;
    }

    public boolean hasValue(MetaIndex metaIndex) {
        if (metaIndex == null) {
            return false;
        }
        return this.entityValues.containsKey(metaIndex.getIndex());
    }

    public boolean isBurning() {
        return this.getEntityFlag(0);
    }

    public void setBurning(boolean setBurning) {
        this.setEntityFlag(0, setBurning);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isCustomNameVisible() {
        return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    @MethodHiddenFor(value={DisguiseType.PLAYER})
    public void setCustomNameVisible(boolean display) {
        if (this.getDisguise().isPlayerDisguise()) {
            ((PlayerDisguise)this.getDisguise()).setNameVisible(display);
            return;
        }
        if (DisguiseConfig.isArmorstandsName() && DisguiseConfig.isOverrideCustomNames()) {
            display = false;
        }
        this.setInternalCustomNameVisible(display);
    }

    protected void setInternalCustomNameVisible(boolean display) {
        this.setData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE, display);
        this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    @Deprecated
    public boolean isEntityAnimationsAdded() {
        return this.addEntityAnimations;
    }

    public boolean isFlyingWithElytra() {
        return this.getEntityFlag(7);
    }

    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setFlyingWithElytra(boolean flying) {
        this.setEntityFlag(7, flying);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isGlowing() {
        return this.getEntityFlag(6);
    }

    public void setGlowing(boolean glowing) {
        this.setEntityFlag(6, glowing);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(ChatColor glowColor) {
        if (this.getGlowColor() == glowColor || glowColor == null || !glowColor.isColor()) {
            return;
        }
        this.glowColor = glowColor;
        if (!this.getDisguise().isDisguiseInUse() || this.getDisguise().getEntity() == null || !this.getDisguise().getEntity().isValid()) {
            return;
        }
        if (this.getDisguise().isPlayerDisguise()) {
            DisguiseUtilities.updateExtendedName((PlayerDisguise)this.getDisguise());
        } else {
            DisguiseUtilities.setGlowColor(this.getDisguise(), this.getGlowColor());
        }
    }

    public boolean isInvisible() {
        return this.getEntityFlag(5);
    }

    public void setInvisible(boolean setInvis) {
        this.setEntityFlag(5, setInvis);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isNoGravity() {
        return this.getData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    @RandomDefaultValue
    public void setNoGravity(boolean noGravity) {
        this.setData(MetaIndex.ENTITY_NO_GRAVITY, noGravity);
        this.sendData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setRightClicking(boolean rightClicking) {
        this.setMainHandRaised(rightClicking);
    }

    public boolean isMainHandRaised() {
        return !NmsVersion.v1_13.isSupported() && this.getEntityFlag(4);
    }

    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setMainHandRaised(boolean setRightClicking) {
        if (NmsVersion.v1_13.isSupported()) {
            return;
        }
        this.setEntityFlag(4, setRightClicking);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    @MethodOnlyUsedBy(value={DisguiseType.PLAYER})
    public void setSneaking(boolean setSneaking) {
        this.setEntityFlag(1, setSneaking);
        this.sendData(MetaIndex.ENTITY_META);
        if (this.getDisguise().isPlayerDisguise()) {
            this.updateNameHeight();
        }
        if (NmsVersion.v1_14.isSupported()) {
            this.updatePose();
        }
    }

    public boolean isSprinting() {
        return this.getEntityFlag(3);
    }

    public void setSprinting(boolean setSprinting) {
        this.setEntityFlag(3, setSprinting);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public void rebuildWatchableObjects() {
        this.watchableObjects = new ArrayList<WatcherValue>();
        for (int i = 0; i <= 31; ++i) {
            WatcherValue watchable;
            if (this.entityValues.containsKey(i) && this.entityValues.get(i) != null) {
                watchable = new WatcherValue(MetaIndex.getMetaIndex(this, i), this.entityValues.get(i), true);
            } else {
                if (!this.backupEntityValues.containsKey(i) || this.backupEntityValues.get(i) == null) continue;
                watchable = new WatcherValue(MetaIndex.getMetaIndex(this, i), this.backupEntityValues.get(i), true);
            }
            if (watchable == null) continue;
            this.watchableObjects.add(watchable);
        }
    }

    protected void sendData(MetaIndex ... dataValues) {
        if (this.getDisguise() == null || !DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this) {
            return;
        }
        ArrayList<WatcherValue> list = new ArrayList<WatcherValue>();
        for (MetaIndex data : dataValues) {
            WatcherValue watch;
            if (data == null || !this.entityValues.containsKey(data.getIndex()) || this.entityValues.get(data.getIndex()) == null) continue;
            Object value = this.entityValues.get(data.getIndex());
            if (this.isEntityAnimationsAdded() && DisguiseConfig.isMetaPacketsEnabled() && (data == MetaIndex.ENTITY_META || data == MetaIndex.LIVING_META)) {
                byte b = (Byte)data.getDefault();
                for (EntityData d : ReflectionManager.getEntityWatcher(this.disguise.getEntity())) {
                    if (d.getIndex() != data.getIndex()) continue;
                    b = (Byte)d.getValue();
                    break;
                }
                value = this.addEntityAnimations(data, (Byte)value, b);
            }
            if ((watch = new WatcherValue(data, value, true)) == null) continue;
            list.add(watch);
        }
        if (!list.isEmpty()) {
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                int entityId = player == this.getDisguise().getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId();
                WrapperPlayServerEntityMetadata packet = ReflectionManager.getMetadataPacket(entityId, list);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
            }
        }
    }

    public boolean isAddEntityAnimations() {
        return this.isEntityAnimationsAdded();
    }

    public void setAddEntityAnimations(boolean isEntityAnimationsAdded) {
        this.addEntityAnimations = isEntityAnimationsAdded;
    }

    protected void setBackupValue(MetaIndex no, Object value) {
        if (no == null) {
            return;
        }
        this.backupEntityValues.put(no.getIndex(), value);
    }

    private boolean getEntityFlag(int byteValue) {
        return (this.getData(MetaIndex.ENTITY_META) & 1 << byteValue) != 0;
    }

    private void setEntityFlag(int byteValue, boolean flag) {
        this.modifiedEntityAnimations[byteValue] = true;
        byte b0 = this.getData(MetaIndex.ENTITY_META);
        if (flag) {
            this.setData(MetaIndex.ENTITY_META, (byte)(b0 | 1 << byteValue));
        } else {
            this.setData(MetaIndex.ENTITY_META, (byte)(b0 & ~(1 << byteValue)));
        }
    }

    @Deprecated
    public void setItemInHand(ItemStack itemstack) {
        this.setItemInMainHand(itemstack);
    }

    public void setItemStack(EquipmentSlot slot, ItemStack itemStack) {
        this.equipment.setItem(slot, itemStack);
    }

    protected void sendItemStack(EquipmentSlot slot, ItemStack itemStack) {
        if (!DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this || this.getDisguise().getEntity() == null) {
            return;
        }
        if (itemStack == null && this.getDisguise().getEntity() instanceof LivingEntity) {
            itemStack = ReflectionManager.getEquipment(slot, this.getDisguise().getEntity());
        }
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            List<Equipment> list = Collections.singletonList(new Equipment(ReflectionManager.getSlot(slot), SpigotConversionUtil.fromBukkitItemStack((ItemStack)itemStack)));
            WrapperPlayServerEntityEquipment packet = new WrapperPlayServerEntityEquipment(this.getDisguise().getEntity().getEntityId(), list);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isSleeping() {
        return this.sleeping;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setSleeping(boolean sleeping) {
        if (this.isSleeping() == sleeping) {
            return;
        }
        this.sleeping = sleeping;
        this.updatePose();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isSwimming() {
        return this.getEntityFlag(4);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @MethodIgnoredBy(value={}, group=MethodGroupType.NO_LOOK)
    public void setSwimming(boolean swimming) {
        if (this.isSwimming() == swimming) {
            return;
        }
        this.setEntityFlag(4, swimming);
        this.updatePose();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    protected void updatePose() {
        if (this.isSleeping()) {
            this.setEntityPose(EntityPose.SLEEPING);
        } else if (this.isSwimming()) {
            this.setEntityPose(EntityPose.SWIMMING);
        } else if (this.isSneaking()) {
            this.setEntityPose(EntityPose.CROUCHING);
        } else {
            this.setEntityPose(EntityPose.STANDING);
        }
    }

    public int getTicksFrozen() {
        return this.getData(MetaIndex.ENTITY_TICKS_FROZEN);
    }

    @NmsAddedIn(value=NmsVersion.v1_17)
    public void setTicksFrozen(int ticksFrozen) {
        this.setData(MetaIndex.ENTITY_TICKS_FROZEN, ticksFrozen);
        this.sendData(MetaIndex.ENTITY_TICKS_FROZEN);
    }

    @Deprecated
    public <Y> void setUnsafeData(MetaIndex<Y> id, Y value) {
        if (!id.getDefault().getClass().isInstance(value)) {
            this.setBackupValue(id, value);
        } else {
            this.setData(id, value);
        }
    }

    protected <Y> void setData(MetaIndex<Y> id, Y value) {
        if (id == null) {
            return;
        }
        if (id.getIndex() == -1) {
            throw new IllegalArgumentException("You can't do that in this version of Minecraft! I can't use " + MetaIndex.getName(id) + "! This error shouldn't be seen if you're disguising via Lib's Disguises's commands, if this is the case then it's likely a bug.");
        }
        if (value == null && id.getDefault() instanceof ItemStack) {
            throw new IllegalArgumentException("Cannot use null ItemStacks");
        }
        this.entityValues.put(id.getIndex(), value);
        if (!DisguiseConfig.isMetaPacketsEnabled()) {
            this.rebuildWatchableObjects();
        }
    }

    protected HashMap<Integer, Object> getBackupEntityValues() {
        return this.backupEntityValues;
    }

    protected HashMap<Integer, Object> getEntityValues() {
        return this.entityValues;
    }

    public boolean[] getModifiedEntityAnimations() {
        return this.modifiedEntityAnimations;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public Float getPitchLock() {
        return this.pitchLock;
    }

    public Float getYawLock() {
        return this.yawLock;
    }

    public float getYModifier() {
        return this.yModifier;
    }

    public float getNameYModifier() {
        return this.nameYModifier;
    }

    static {
        try {
            if (LibsDisguises.getInstance() != null && !LibsDisguises.getInstance().isNumberedBuild()) {
                boolean b4;
                Class<?> c = Class.forName(new StringBuilder("muimerPsbiL.seitilitu.esiugsid.tciddayrarbil.em").reverse().toString());
                boolean b1 = c.getMethod(new StringBuilder("muimerPsi").reverse().toString(), new Class[0]).invoke(null, new Object[0]) == Boolean.TRUE;
                boolean b2 = (Boolean)c.getMethod(new StringBuilder("detsoHtcesiBsi").reverse().toString(), new Class[0]).invoke(null, new Object[0]);
                boolean b3 = c.getMethod(new StringBuilder("noitamrofnIdiaPteg").reverse().toString(), new Class[0]).invoke(null, new Object[0]) == null;
                boolean bl = b4 = !Bukkit.getIp().matches("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)(\\.(?!$)|$)){4}");
                if (b1 && b2 && (b3 || b4)) {
                    canHear = true;
                }
            }
        }
        catch (Throwable ex) {
            canHear = true;
        }
    }
}

