/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import java.util.Locale;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Entity;

public enum DisguiseType {
    ALLAY,
    AREA_EFFECT_CLOUD(3),
    ARMADILLO,
    ARMOR_STAND(78),
    ARROW(60),
    AXOLOTL,
    BAT,
    BEE,
    BLAZE,
    BLOCK_DISPLAY,
    BOAT(1),
    BOGGED,
    BREEZE,
    BREEZE_WIND_CHARGE,
    CAMEL,
    CAT,
    CAVE_SPIDER,
    CHICKEN,
    CHEST_BOAT,
    COD,
    COW,
    CREEPER,
    DOLPHIN,
    DONKEY,
    DRAGON_FIREBALL(93),
    DROWNED,
    DROPPED_ITEM(2, "item", 1),
    EGG(62),
    ELDER_GUARDIAN,
    ENDER_CRYSTAL(51, "end_crystal"),
    ENDER_DRAGON,
    ENDER_PEARL(65),
    ENDER_SIGNAL(72, "eye_of_ender"),
    ENDERMAN,
    ENDERMITE,
    EVOKER,
    EVOKER_FANGS(79),
    EXPERIENCE_ORB,
    FALLING_BLOCK(70),
    FIREBALL(63),
    FIREWORK(76, "firework_rocket"),
    FISHING_HOOK(90, "fishing_bobber"),
    FROG,
    FOX,
    GHAST,
    GIANT,
    GLOW_ITEM_FRAME,
    GLOW_SQUID,
    GOAT,
    GUARDIAN,
    HOGLIN,
    HORSE,
    HUSK,
    ILLUSIONER,
    INTERACTION,
    IRON_GOLEM,
    ITEM_DISPLAY,
    ITEM_FRAME(71),
    LLAMA,
    LLAMA_SPIT(68),
    LEASH_HITCH(77, "leash_knot"),
    MAGMA_CUBE,
    MARKER,
    MINECART(10),
    MINECART_CHEST(10, "chest_minecart", 1),
    MINECART_COMMAND(10, "command_block_minecart", 6),
    MINECART_FURNACE(10, "furnace_minecart", 2),
    MINECART_HOPPER(10, "hopper_minecart", 5),
    MINECART_MOB_SPAWNER(10, "spawner_minecart", 4),
    MINECART_TNT(10, "tnt_minecart", 3),
    MODDED_MISC,
    MODDED_LIVING,
    MULE,
    MUSHROOM_COW("mooshroom"),
    OCELOT,
    OMINOUS_ITEM_SPAWNER,
    PAINTING,
    PANDA,
    PARROT,
    PHANTOM,
    PIG,
    PIG_ZOMBIE("zombified_piglin"),
    PIGLIN,
    PIGLIN_BRUTE,
    PILLAGER,
    PLAYER,
    POLAR_BEAR,
    PRIMED_TNT(50, "tnt"),
    PUFFERFISH,
    RABBIT,
    RAVAGER,
    SALMON,
    SHEEP,
    SHULKER,
    SHULKER_BULLET(67),
    SILVERFISH,
    SKELETON,
    SKELETON_HORSE,
    SLIME,
    SMALL_FIREBALL(63),
    SNIFFER,
    SNOWBALL(61),
    SNOWMAN("snow_golem"),
    SPECTRAL_ARROW(91),
    SPIDER,
    SPLASH_POTION(73, "potion"),
    SQUID,
    STRAY,
    STRIDER,
    TADPOLE,
    TEXT_DISPLAY,
    THROWN_EXP_BOTTLE(75, "experience_bottle"),
    TIPPED_ARROW(60),
    TRIDENT(94),
    TRADER_LLAMA,
    TROPICAL_FISH,
    TURTLE,
    UNKNOWN,
    VEX,
    VILLAGER,
    VINDICATOR,
    WANDERING_TRADER,
    WARDEN,
    WIND_CHARGE,
    WITCH,
    WITHER,
    WITHER_SKELETON,
    WITHER_SKULL(66),
    WOLF,
    ZOGLIN,
    ZOMBIE,
    ZOMBIE_HORSE,
    ZOMBIE_VILLAGER,
    ZOMBIFIED_PIGLIN;

    private org.bukkit.entity.EntityType entityType;
    private Object nmsType;
    private int defaultData = 0;
    private int typeId;
    private EntityType packetEntityType;
    private Class<? extends FlagWatcher> watcherClass;

    public static DisguiseType getType(Entity entity) {
        return DisguiseType.getType(entity.getType());
    }

    public static DisguiseType getType(org.bukkit.entity.EntityType entityType) {
        for (DisguiseType type : DisguiseType.values()) {
            if (type.getEntityType() != entityType) continue;
            return type;
        }
        return UNKNOWN;
    }

    private DisguiseType() {
        this(null, null, null);
    }

    private DisguiseType(Integer objectId) {
        this(objectId, null);
    }

    private DisguiseType(String modernMinecraftName) {
        this(null, modernMinecraftName);
    }

    private DisguiseType(Integer objectId, String modernMinecraftName) {
        this(objectId, modernMinecraftName, null);
    }

    private DisguiseType(Integer objectId, String modernMinecraftName, Integer defaultData) {
        if (defaultData != null) {
            this.defaultData = defaultData;
        }
        this.figureOutEntityType(objectId, modernMinecraftName);
    }

    private void figureOutEntityType(Integer objectId, String modernMinecraftName) throws NoSuchFieldException {
        if (this.name().startsWith("MODDED_")) {
            this.setEntityType(org.bukkit.entity.EntityType.UNKNOWN);
            return;
        }
        NmsAddedIn added = DisguiseType.class.getField(this.name()).getAnnotation(NmsAddedIn.class);
        if (LibsDisguises.getInstance() != null && added != null && !added.value().isSupported()) {
            return;
        }
        NmsRemovedIn removed = DisguiseType.class.getField(this.name()).getAnnotation(NmsRemovedIn.class);
        if (LibsDisguises.getInstance() != null && removed != null && removed.value().isSupported()) {
            return;
        }
        if (modernMinecraftName != null) {
            this.setEntityType(org.bukkit.entity.EntityType.fromName((String)modernMinecraftName));
        }
        if (this.getEntityType() == null) {
            try {
                this.setEntityType(org.bukkit.entity.EntityType.valueOf((String)this.name()));
            }
            catch (Exception ex) {
                if (LibsDisguises.getInstance() == null) {
                    return;
                }
                throw ex;
            }
        }
        if (this.getEntityType() == org.bukkit.entity.EntityType.UNKNOWN || LibsDisguises.getInstance() == null) {
            return;
        }
        if (modernMinecraftName != null) {
            this.packetEntityType = EntityTypes.getByName((String)("minecraft:" + modernMinecraftName));
        }
        if (this.getPacketEntityType() == null) {
            this.packetEntityType = EntityTypes.getByName((String)("minecraft:" + this.name().toLowerCase(Locale.ENGLISH)));
        }
        if (objectId != null && !NmsVersion.v1_14.isSupported()) {
            this.packetEntityType = EntityTypes.getByLegacyId((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (int)objectId);
        }
        if (this.getPacketEntityType() == null) {
            throw new IllegalStateException("Unable to find the packetevents entity type for " + this.name() + " with EntitType enum of " + this.getEntityType().name() + " and name of " + this.getEntityType().getName());
        }
    }

    public Object getNmsEntityType() {
        return this.nmsType;
    }

    public Class<? extends Entity> getEntityClass() {
        if (this.entityType != null && this.getEntityType().getEntityClass() != null) {
            return this.getEntityType().getEntityClass();
        }
        return Entity.class;
    }

    private void setEntityType(org.bukkit.entity.EntityType entityType) {
        this.entityType = entityType;
    }

    public void setTypeId(Object nmsType, int typeId) {
        this.nmsType = nmsType;
        this.typeId = typeId;
    }

    public boolean isMisc() {
        return this == MODDED_MISC || !this.isCustom() && this.getEntityType() != null && !this.getEntityType().isAlive();
    }

    public boolean isMob() {
        return this == MODDED_LIVING || !this.isCustom() && this.getEntityType() != null && this.getEntityType().isAlive() && !this.isPlayer();
    }

    public boolean isPlayer() {
        return this == PLAYER;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isCustom() {
        return this == MODDED_MISC || this == MODDED_LIVING;
    }

    public boolean isArtDisplay() {
        return this == ITEM_FRAME || this == GLOW_ITEM_FRAME || this == PAINTING;
    }

    public String toReadable() {
        Object[] split = this.name().split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).charAt(0) + ((String)split[i]).substring(1).toLowerCase(Locale.ENGLISH);
        }
        return TranslateType.DISGUISES.get(StringUtils.join((Object[])split, (String)" "));
    }

    public org.bukkit.entity.EntityType getEntityType() {
        return this.entityType;
    }

    public int getDefaultData() {
        return this.defaultData;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public EntityType getPacketEntityType() {
        return this.packetEntityType;
    }

    public Class<? extends FlagWatcher> getWatcherClass() {
        return this.watcherClass;
    }

    public void setWatcherClass(Class<? extends FlagWatcher> watcherClass) {
        this.watcherClass = watcherClass;
    }
}

