/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class LDDebugDisguiseLoop
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("disguiseloop");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public String getPermission() {
        return "libsdisguises.disguise";
    }

    @Override
    public boolean isEnabled() {
        return !LibsDisguises.getInstance().isNumberedBuild();
    }

    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Must be a player to use this command, if you're seeing this then you clearly don't know what this command is for and wouldn't benefit from using it.");
            return;
        }
        if (args.length != 2 || !args[1].equalsIgnoreCase("agree")) {
            sender.sendMessage(ChatColor.RED + "This is for debugging and is meant to loop over every disguise and disguise you to verify if there's any obvious issues. There is no value for you in this command. Type 'agree' into the command to continue.");
            return;
        }
        final Iterator<String> iterator = LDDebugDisguiseLoop.getDisguisesToRun().iterator();
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!((Player)sender).isOnline()) {
                    this.cancel();
                    return;
                }
                String command = (String)iterator.next();
                String message = ChatColor.AQUA + "Now disguising " + sender.getName() + " as " + command;
                sender.sendMessage(message);
                DisguiseUtilities.getLogger().info(message);
                Disguise disguise = DisguiseAPI.getDisguise((Entity)((Player)sender));
                try {
                    ((Player)sender).performCommand("disguise " + command);
                    if (disguise == DisguiseAPI.getDisguise((Entity)((Player)sender))) {
                        DisguiseUtilities.getLogger().info("Looks like '" + command + "' failed.");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (!iterator.hasNext()) {
                        this.cancel();
                        sender.sendMessage(ChatColor.AQUA + "Command Complete!");
                    }
                }
            }
        }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 5L, 5L);
    }

    @NotNull
    private static List<String> getDisguisesToRun() {
        ArrayList<String> commands = new ArrayList<String>();
        for (DisguiseType type : DisguiseType.values()) {
            String command;
            if (type.getEntityType() == null || type.isUnknown() || type.isCustom()) continue;
            switch (type) {
                case PLAYER: {
                    command = "player libraryaddict";
                    break;
                }
                case DROPPED_ITEM: {
                    command = "dropped_item grass";
                    break;
                }
                default: {
                    command = type.name();
                }
            }
            commands.add(command);
        }
        return commands;
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_DEBUG_MINESKIN;
    }
}

