/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClassMappings {
    private static final HashMap<String, String> classLocations = new HashMap();
    private static final String[] packages = ClassMappings.getPackages();
    private static boolean updatingCache = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClass(String packageHint, String className) {
        String key = packageHint + "." + className;
        String location = classLocations.get(key);
        if (location != null) {
            return location;
        }
        location = "???";
        for (String pack : packages) {
            if (!pack.startsWith(packageHint)) continue;
            String toTry = pack + "." + className;
            try {
                Class.forName(toTry);
                location = toTry;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        classLocations.put(key, location);
        HashMap<String, String> hashMap = classLocations;
        synchronized (hashMap) {
            if (!updatingCache && LibsDisguises.getInstance() != null && LibsDisguises.getInstance().isEnabled()) {
                updatingCache = true;
                new BukkitRunnable(){

                    public void run() {
                        ClassMappings.saveMappingsCache(LibsDisguises.getInstance().getDataFolder());
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 200L);
            }
        }
        return location;
    }

    private static String[] getPackages() {
        String[] s = new String[]{"net.minecraft.server.$version$", "net.minecraft.core", "net.minecraft.core.particles", "net.minecraft.nbt", "net.minecraft.network.chat", "net.minecraft.network.protocol.game", "net.minecraft.network.syncher", "net.minecraft.resources", "net.minecraft.server.level", "net.minecraft.server", "net.minecraft.server.network", "net.minecraft.sounds", "net.minecraft.world.damagesource", "net.minecraft.world.effect", "net.minecraft.world.entity.ambient", "net.minecraft.world.entity.animal.axolotl", "net.minecraft.world.entity.animal", "net.minecraft.world.entity.animal.goat", "net.minecraft.world.entity.animal.horse", "net.minecraft.world.entity.boss.enderdragon", "net.minecraft.world.entity.boss.wither", "net.minecraft.world.entity.decoration", "net.minecraft.world.entity", "net.minecraft.world.entity.item", "net.minecraft.world.entity.monster", "net.minecraft.world.entity.monster.hoglin", "net.minecraft.world.entity.monster.piglin", "net.minecraft.world.entity.npc", "net.minecraft.world.entity.player", "net.minecraft.world.entity.projectile", "net.minecraft.world.entity.vehicle", "net.minecraft.world.inventory", "net.minecraft.world.item", "net.minecraft.world.level.block", "net.minecraft.world.level.block.state", "net.minecraft.world.level", "net.minecraft.world.phys", "org.bukkit.craftbukkit.$version$.block.data", "org.bukkit.craftbukkit.$version$", "org.bukkit.craftbukkit.$version$.entity", "org.bukkit.craftbukkit.$version$.inventory", "org.bukkit.craftbukkit.$version$.util"};
        String replaceStr = "$version$";
        String version = ReflectionManager.getNmsPackage();
        if (version.isEmpty()) {
            replaceStr = "." + replaceStr;
        }
        for (int i = 0; i < s.length; ++i) {
            s[i] = s[i].replace(replaceStr, version);
        }
        return s;
    }

    private static String getVersion() {
        return "Built for: " + Bukkit.getVersion() + "\t" + LibsDisguises.getInstance().getDescription().getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMappingsCache(File dataFolder) {
        HashMap<String, String> hashMap = classLocations;
        synchronized (hashMap) {
            if (!updatingCache) {
                return;
            }
            updatingCache = false;
        }
        File mappingsCache = new File(dataFolder, "mappings_cache");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(mappingsCache));){
            writer.write(ClassMappings.getVersion() + "\n");
            for (Map.Entry<String, String> entry : classLocations.entrySet()) {
                writer.write(entry.getKey() + " " + entry.getValue() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadMappingsCache(File dataFolder) {
        File mappingsCache = new File(dataFolder, "mappings_cache");
        if (!mappingsCache.exists()) {
            return;
        }
        try (BufferedReader reader2 = new BufferedReader(new FileReader(mappingsCache));){
            String line = reader2.readLine();
            if (line == null || !line.equals(ClassMappings.getVersion())) {
                DisguiseUtilities.getLogger().info("Outdated mappings cache, will rebuild.");
                return;
            }
            while ((line = reader2.readLine()) != null) {
                String[] parts = line.split(" ", 2);
                if (parts.length != 2) continue;
                try {
                    if (parts[1].contains(".")) {
                        Class.forName(parts[1]);
                    }
                    classLocations.put(parts[0], parts[1]);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

