/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean debugging;
    private String apiKey;

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback callback, String url, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/url", url, null, modelType);
    }

    private void printDebug(String message) {
        if (!this.isDebugging() || LibsDisguises.getInstance() == null) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info("[MineSkinAPI] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback callback, String path, String skinUrl, File file, SkinUtils.ModelType modelType) {
        MineSkinResponse mineSkinResponse;
        InputStream input;
        long nextRequestIn;
        HttpURLConnection connection;
        block57: {
            block56: {
                String errorMessage;
                block54: {
                    block55: {
                        block50: {
                            APIError error;
                            block53: {
                                block52: {
                                    block51: {
                                        this.lock.lock();
                                        long sleep = this.nextRequest - System.currentTimeMillis();
                                        if (file != null) {
                                            this.printDebug("Grabbing a skin from file at " + file.getPath());
                                        } else if (skinUrl != null) {
                                            this.printDebug("Grabbing a skin from url '" + skinUrl + "'");
                                        }
                                        if (this.getApiKey() != null) {
                                            this.printDebug("Using a MineSkin api key!");
                                        }
                                        if (sleep > 0L) {
                                            this.printDebug("Sleeping for " + sleep + "ms before calling the API due to a recent request");
                                            try {
                                                Thread.sleep(sleep);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        connection = null;
                                        nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
                                        if (this.getApiKey() != null) {
                                            path = path + (path.contains("?") ? (char)'&' : '?') + "key=" + this.getApiKey();
                                        }
                                        URL url = new URL("https://api.mineskin.org" + path);
                                        connection = (HttpURLConnection)url.openConnection();
                                        connection.setConnectTimeout(19000);
                                        connection.setReadTimeout(19000);
                                        connection.setDoOutput(true);
                                        connection.setRequestProperty("User-Agent", "LibsDisguises");
                                        String boundary = "LD@" + Long.toHexString(System.currentTimeMillis());
                                        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                        String charset = "UTF-8";
                                        String CRLF = "\r\n";
                                        try (OutputStream output = connection.getOutputStream();
                                             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
                                            writer.append("--").append(boundary).append(CRLF);
                                            writer.append("Content-Disposition: form-data; name=\"visibility\"").append(CRLF);
                                            writer.append("Content-Type: text/plain; charset=").append(charset).append(CRLF);
                                            writer.append(CRLF).append("1").append(CRLF).flush();
                                            if (file != null) {
                                                writer.append("--").append(boundary).append(CRLF);
                                                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(CRLF);
                                                writer.append("Content-Type: image/png").append(CRLF);
                                                writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                                                writer.append(CRLF).flush();
                                                Files.copy(file.toPath(), output);
                                                output.flush();
                                                writer.append(CRLF).flush();
                                            } else if (skinUrl != null) {
                                                writer.append("--").append(boundary).append(CRLF);
                                                writer.append("Content-Disposition: form-data; name=\"url\"").append(CRLF);
                                                writer.append(CRLF).append(skinUrl).append(CRLF).flush();
                                            }
                                            if (modelType == SkinUtils.ModelType.SLIM) {
                                                writer.append("--").append(boundary).append(CRLF);
                                                writer.append("Content-Disposition: form-data; name=\"model\"").append(CRLF);
                                                writer.append(CRLF).append("slim").append(CRLF).flush();
                                            }
                                            writer.append("--").append(boundary).append("--").append(CRLF).flush();
                                        }
                                        this.printDebug("Received status code: " + connection.getResponseCode());
                                        if (connection.getResponseCode() != 500) break block50;
                                        errorMessage = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        error = (APIError)new Gson().fromJson(errorMessage, APIError.class);
                                        this.printDebug("Received error: " + errorMessage);
                                        if (error.code != 403) break block51;
                                        callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_403.get(new Object[0]));
                                        MineSkinResponse mineSkinResponse2 = null;
                                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                        this.lock.unlock();
                                        return mineSkinResponse2;
                                    }
                                    if (error.code != 404) break block52;
                                    callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_404.get(new Object[0]));
                                    MineSkinResponse mineSkinResponse3 = null;
                                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                    this.lock.unlock();
                                    return mineSkinResponse3;
                                }
                                if (error.code != 408 && error.code != 504 && error.code != 599) break block53;
                                callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_TIMEOUT.get(new Object[0]));
                                MineSkinResponse mineSkinResponse4 = null;
                                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                this.lock.unlock();
                                return mineSkinResponse4;
                            }
                            callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_IMAGE_HAS_ERROR.get(error.error));
                            MineSkinResponse mineSkinResponse5 = null;
                            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                            this.lock.unlock();
                            return mineSkinResponse5;
                        }
                        if (connection.getResponseCode() != 400) break block54;
                        if (skinUrl == null) break block55;
                        callback.onError(LibsMsg.SKIN_API_BAD_URL, new Object[0]);
                        errorMessage = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        return errorMessage;
                    }
                    if (file == null) break block56;
                    callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                    errorMessage = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    return errorMessage;
                }
                if (connection.getResponseCode() != 429) break block56;
                callback.onError(LibsMsg.SKIN_API_FAIL_TOO_FAST, new Object[0]);
                errorMessage = null;
                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                this.lock.unlock();
                return errorMessage;
            }
            input = connection.getInputStream();
            String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.printDebug("Received: " + response);
            MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
            nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
            mineSkinResponse = skinResponse;
            if (input == null) break block57;
            input.close();
        }
        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
        this.lock.unlock();
        return mineSkinResponse;
        {
            catch (Throwable throwable) {
                MineSkinResponse mineSkinResponse6;
                try {
                    if (input == null) throw throwable;
                    try {
                        input.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException ex) {
                    if (this.isDebugging()) {
                        ex.printStackTrace();
                    }
                    callback.onError(skinUrl == null ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
                    mineSkinResponse6 = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    return mineSkinResponse6;
                }
                catch (Exception ex) {
                    block58: {
                        if (connection == null || connection.getResponseCode() != 524 && connection.getResponseCode() != 408 && connection.getResponseCode() != 504 && connection.getResponseCode() != 599) break block58;
                        if (this.getApiKey() != null && connection.getResponseCode() == 504) {
                            callback.onError(LibsMsg.SKIN_API_TIMEOUT_API_KEY_ERROR, new Object[0]);
                        } else {
                            callback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                        }
                        mineSkinResponse6 = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        return mineSkinResponse6;
                    }
                    try {
                        block59: {
                            break block59;
                            {
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (DisguiseUtilities.getLogger() != null) {
                            DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                        }
                        ex.printStackTrace();
                        callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        return null;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MineSkinResponse generateFromUUID(UUID uuid, SkinUtils.ModelType modelType) throws IllegalArgumentException {
        block18: {
            this.lock.lock();
            long sleep = this.nextRequest - System.currentTimeMillis();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            long nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
            try {
                MineSkinResponse mineSkinResponse;
                block17: {
                    String siteUrl = "https://api.mineskin.org/generate/user/:" + uuid.toString();
                    if (modelType == SkinUtils.ModelType.SLIM) {
                        siteUrl = siteUrl + "?model=slim";
                    }
                    URL url = new URL(siteUrl);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "LibsDisguises");
                    con.setDoOutput(true);
                    InputStream input = con.getInputStream();
                    try {
                        String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                        nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
                        mineSkinResponse = skinResponse;
                        if (input == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            if (ex.getMessage() != null && ex.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                                throw new IllegalArgumentException();
                            }
                            if (DisguiseUtilities.getLogger() != null) {
                                DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                            }
                            ex.printStackTrace();
                            break block18;
                        }
                    }
                    input.close();
                }
                return mineSkinResponse;
            }
            finally {
                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                this.lock.unlock();
            }
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback callback, File file, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/upload", null, file, modelType);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

