/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUploadLogs
implements LDCommand {
    private long lastUsed;

    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("uploadlog", "uploadlogs", "uploadconfig", "uploadconfigs", "logs", "log");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        if (this.lastUsed + TimeUnit.MINUTES.toMillis(3L) > System.currentTimeMillis()) {
            sender.sendMessage(ChatColor.RED + "You last used this command under 3 minutes ago! Restart the server or wait for this timer to disappear!");
            return;
        }
        File latest = new File("logs/latest.log");
        final File disguises = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        List configs = new ConfigLoader().getConfigs().stream().map(f -> new File(LibsDisguises.getInstance().getDataFolder(), (String)f)).collect(Collectors.toList());
        final StringBuilder configText = new StringBuilder();
        for (File config : configs) {
            if (configText.length() != 0) {
                configText.append("\n\n================\n\n");
            }
            try {
                String text = new String(Files.readAllBytes(config.toPath()));
                text = text.replaceAll("\n? *#[^\n]*", "").replaceAll("[\n\r]+", "\n");
                configText.append("File: ").append(config.getName()).append("\n\n").append(text);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.isTooBig(latest)) {
            sender.sendMessage(ChatColor.RED + "Your latest.log file is too big! It should be less than 10mb! Please restart and run this command again!");
            return;
        }
        if (this.isTooBig(disguises)) {
            sender.sendMessage(ChatColor.RED + "Your disguises.yml is too big! You'll need to trim that file down before using this command! It should be less than 10mb!");
            return;
        }
        try {
            int nextLine;
            final String latestText = new String(Files.readAllBytes(latest.toPath()));
            boolean valid = false;
            int lastFind = 0;
            for (int i = 0; i < 15 && (nextLine = latestText.indexOf("\n", lastFind)) != -1; ++i) {
                String str = latestText.substring(lastFind, nextLine);
                lastFind = nextLine + 2;
                if (!str.contains("Starting minecraft server version") && !str.contains("Loading properties") && !str.contains("This server is running")) continue;
                valid = true;
                break;
            }
            if (!valid) {
                sender.sendMessage(ChatColor.RED + "Your latest.log is too old! Please restart the server and try again!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "Now creating mclo.gs links...");
            new BukkitRunnable(){

                public void run() {
                    try {
                        String disguiseText = new String(Files.readAllBytes(disguises.toPath()));
                        configText.append("\n\n================\n");
                        ArrayList<String> modified = DisguiseConfig.doOutput(true, true);
                        for (String s : modified) {
                            configText.append("\n").append(s);
                        }
                        if (modified.isEmpty()) {
                            configText.append("\nUsing default config!");
                        }
                        final URL latestPaste = new GuestPaste("latest.log", latestText).paste();
                        final URL configPaste = new GuestPaste("LibsDisguises config.yml", configText.toString()).paste();
                        final URL disguisesPaste = new GuestPaste("LibsDisguises disguises.yml", disguiseText).paste();
                        LDUploadLogs.this.lastUsed = System.currentTimeMillis();
                        new BukkitRunnable(){

                            public void run() {
                                sender.sendMessage(ChatColor.GOLD + "Upload successful!");
                                if (sender instanceof Player) {
                                    sender.sendMessage(ChatColor.GOLD + "Click on the below message to have it appear in your chat input");
                                }
                                String text = "My log file: " + latestPaste + ", my combined config files: " + configPaste + " and my disguises file: " + disguisesPaste;
                                ComponentBuilder builder = new ComponentBuilder("");
                                builder.append(text);
                                builder.color(net.md_5.bungee.api.ChatColor.AQUA);
                                builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text));
                                sender.spigot().sendMessage(builder.create());
                            }
                        }.runTask((Plugin)LibsDisguises.getInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sender.sendMessage(ChatColor.RED + "Unexpected error! Upload failed! " + e.getMessage());
                    }
                }
            }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isTooBig(File file) {
        return file.exists() && this.isTooBig(file.length());
    }

    private boolean isTooBig(long length) {
        return length > 10048000L;
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPLOAD_LOGS;
    }

    public class GuestPaste {
        private String name = null;
        private final String text;

        public GuestPaste(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public URL paste() throws Exception {
            URL url = new URL("https://api.mclo.gs/1/log");
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            LinkedList<AbstractMap.SimpleEntry<String, String>> params = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_code", this.text));
            StringBuilder output = new StringBuilder();
            output.append(URLEncoder.encode("content", "UTF-8"));
            output.append('=');
            output.append(URLEncoder.encode(this.text, "UTF-8"));
            con.setDoOutput(true);
            try (DataOutputStream dos = new DataOutputStream(con.getOutputStream());){
                dos.writeBytes(output.toString());
                dos.flush();
            }
            int status = con.getResponseCode();
            if (status >= 200 && status < 300) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                    String inputLine;
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = br.readLine()) != null) {
                        response.append(inputLine);
                    }
                    MCLogs logs = (MCLogs)new Gson().fromJson(response.toString(), MCLogs.class);
                    URL uRL = new URL(logs.url);
                    return uRL;
                }
            }
            throw new IllegalStateException("Unexpected response code " + status);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuestPaste)) {
                return false;
            }
            GuestPaste other = (GuestPaste)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GuestPaste;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "LDUploadLogs.GuestPaste(name=" + this.getName() + ", text=" + this.getText() + ")";
        }
    }

    class MCLogs {
        boolean success;
        String id;
        String url;
        String raw;

        MCLogs() {
        }
    }
}

