/*
 * Decompiled with CFR 0.152.
 */
package libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import libsdisg.shaded.net.kyori.adventure.text.Component;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.Context;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import libsdisg.shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class TranslatableTransformation
extends Transformation
implements Inserting {
    private final String key;
    private final List<Component> inners;

    public static TranslatableTransformation create(Context ctx, String name, List<TagPart> args) {
        List<Component> with;
        if (args.isEmpty()) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a translatable component", args);
        }
        if (args.size() > 1) {
            with = new ArrayList();
            for (TagPart in : args.subList(1, args.size())) {
                with.add(ctx.parse(in.value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return new TranslatableTransformation(args.get(0).value(), with);
    }

    private TranslatableTransformation(String key, List<Component> with) {
        this.key = key;
        this.inners = with;
    }

    @Override
    public Component apply() {
        if (this.inners.isEmpty()) {
            return Component.translatable(this.key);
        }
        return Component.translatable(this.key, this.inners);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("inners", this.inners));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TranslatableTransformation that = (TranslatableTransformation)other;
        return Objects.equals(this.key, that.key) && Objects.equals(this.inners, that.inners);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.inners);
    }
}

