/*
 * Decompiled with CFR 0.152.
 */
package libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import libsdisg.shaded.net.kyori.adventure.text.Component;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import libsdisg.shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class KeybindTransformation
extends Transformation
implements Inserting {
    private final String keybind;

    public static KeybindTransformation create(String name, List<TagPart> args) {
        if (args.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args + " into a keybind component", args);
        }
        return new KeybindTransformation(args.get(0).value());
    }

    private KeybindTransformation(String keybind) {
        this.keybind = keybind;
    }

    @Override
    public Component apply() {
        return Component.keybind(this.keybind);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("keybind", this.keybind));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeybindTransformation that = (KeybindTransformation)other;
        return Objects.equals(this.keybind, that.keybind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keybind);
    }
}

