/*
 * Decompiled with CFR 0.152.
 */
package libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.node;

import java.util.Map;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.Template;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.Token;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.parser.TokenParser;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TagPart {
    private final String value;
    private final Token token;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public TagPart(@NotNull String sourceMessage, @NotNull Token token, @NotNull Map<String, Template> templates) {
        this(sourceMessage, token, TemplateResolver.pairs(templates));
    }

    public TagPart(@NotNull String sourceMessage, @NotNull Token token, @NotNull TemplateResolver templateResolver) {
        String v = TagPart.unquoteAndEscape(sourceMessage, token.startIndex(), token.endIndex());
        this.value = v = TokenParser.resolveStringTemplates(v, templateResolver);
        this.token = token;
    }

    @NotNull
    public String value() {
        return this.value;
    }

    @NotNull
    public Token token() {
        return this.token;
    }

    @NotNull
    public static String unquoteAndEscape(@NotNull String text, int start, int end) {
        if (start == end) {
            return "";
        }
        int startIndex = start;
        int endIndex = end;
        char firstChar = text.charAt(startIndex);
        char lastChar = text.charAt(endIndex - 1);
        if (firstChar == '\'' || firstChar == '\"') {
            ++startIndex;
        }
        if (lastChar == '\'' || lastChar == '\"') {
            --endIndex;
        }
        return TokenParser.unescape(text, startIndex, endIndex, i -> i == firstChar);
    }

    public String toString() {
        return this.value;
    }
}

