/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerEntityDestroy
extends PacketAdapter {
    public PacketListenerEntityDestroy(Plugin plugin) {
        super(plugin, new PacketType[]{PacketType.Play.Server.ENTITY_DESTROY});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!NmsVersion.v1_17.isSupported()) {
            int[] entityIds;
            for (int entityId : entityIds = (int[])event.getPacket().getIntegerArrays().read(0)) {
                this.handleEntityId(event.getPlayer(), entityId);
            }
            return;
        }
        List entityIds = (List)event.getPacket().getIntLists().read(0);
        if (entityIds == null) {
            return;
        }
        Iterator iterator = entityIds.iterator();
        while (iterator.hasNext()) {
            int entityId = (Integer)iterator.next();
            this.handleEntityId(event.getPlayer(), entityId);
        }
    }

    private int[] getToRemove(Player player, int entityId) {
        if (entityId == DisguiseAPI.getSelfDisguiseId()) {
            return null;
        }
        Disguise disguise = DisguiseUtilities.getDisguise(player, entityId);
        if (disguise == null) {
            return null;
        }
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return null;
        }
        return disguise.getArmorstandIds();
    }

    private void handleEntityId(Player player, int entityId) {
        int[] toRemove = this.getToRemove(player, entityId);
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, DisguiseUtilities.getDestroyPacket(toRemove));
    }
}

