/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public abstract class DisplayWatcher
extends FlagWatcher {
    public DisplayWatcher(Disguise disguise) {
        super(disguise);
    }

    public Transformation getTransformation() {
        Vector3f transformation = this.getData(MetaIndex.DISPLAY_TRANSLATION);
        Quaternionf leftRotation = this.getData(MetaIndex.DISPLAY_LEFT_ROTATION);
        Quaternionf rightRotation = this.getData(MetaIndex.DISPLAY_RIGHT_ROTATION);
        Vector3f scale = this.getData(MetaIndex.DISPLAY_SCALE);
        return new Transformation(transformation, leftRotation, scale, rightRotation);
    }

    @RandomDefaultValue
    public void setTransformation(Transformation transformation) {
        this.setData(MetaIndex.DISPLAY_TRANSLATION, transformation.getTranslation());
        this.setData(MetaIndex.DISPLAY_LEFT_ROTATION, transformation.getLeftRotation());
        this.setData(MetaIndex.DISPLAY_RIGHT_ROTATION, transformation.getRightRotation());
        this.setData(MetaIndex.DISPLAY_SCALE, transformation.getScale());
        this.sendData(MetaIndex.DISPLAY_TRANSLATION, MetaIndex.DISPLAY_LEFT_ROTATION, MetaIndex.DISPLAY_RIGHT_ROTATION, MetaIndex.DISPLAY_SCALE);
    }

    public Vector3f getTranslation() {
        return this.getData(MetaIndex.DISPLAY_TRANSLATION);
    }

    @RandomDefaultValue
    public void setTranslation(Vector3f translation) {
        this.setData(MetaIndex.DISPLAY_TRANSLATION, translation);
        this.sendData(MetaIndex.DISPLAY_TRANSLATION);
    }

    public Vector3f getScale() {
        return this.getData(MetaIndex.DISPLAY_SCALE);
    }

    public void setScale(Vector3f scale) {
        this.setData(MetaIndex.DISPLAY_SCALE, scale);
        this.sendData(MetaIndex.DISPLAY_SCALE);
    }

    public Quaternionf getLeftRotation() {
        return this.getData(MetaIndex.DISPLAY_LEFT_ROTATION);
    }

    public void setLeftRotation(Quaternionf rotation) {
        this.setData(MetaIndex.DISPLAY_LEFT_ROTATION, rotation);
        this.sendData(MetaIndex.DISPLAY_LEFT_ROTATION);
    }

    public Quaternionf getRightRotation() {
        return this.getData(MetaIndex.DISPLAY_LEFT_ROTATION);
    }

    public void setRightRotation(Quaternionf rotation) {
        this.setData(MetaIndex.DISPLAY_RIGHT_ROTATION, rotation);
        this.sendData(MetaIndex.DISPLAY_RIGHT_ROTATION);
    }

    public int getInterpolationDuration() {
        return this.getData(MetaIndex.DISPLAY_INTERPOLATION_DURATION);
    }

    public void setInterpolationDuration(int duration) {
        this.setData(MetaIndex.DISPLAY_INTERPOLATION_DURATION, duration);
        this.sendData(MetaIndex.DISPLAY_INTERPOLATION_DURATION);
    }

    public float getViewRange() {
        return this.getData(MetaIndex.DISPLAY_VIEW_RANGE).floatValue();
    }

    public void setViewRange(float range) {
        this.setData(MetaIndex.DISPLAY_VIEW_RANGE, Float.valueOf(range));
        this.sendData(MetaIndex.DISPLAY_VIEW_RANGE);
    }

    public float getShadowRadius() {
        return this.getData(MetaIndex.DISPLAY_SHADOW_RADIUS).floatValue();
    }

    public void setShadowRadius(float radius) {
        this.setData(MetaIndex.DISPLAY_SHADOW_RADIUS, Float.valueOf(radius));
        this.sendData(MetaIndex.DISPLAY_SHADOW_RADIUS);
    }

    public float getShadowStrength() {
        return this.getData(MetaIndex.DISPLAY_SHADOW_STRENGTH).floatValue();
    }

    public void setShadowStrength(float strength) {
        this.setData(MetaIndex.DISPLAY_SHADOW_STRENGTH, Float.valueOf(strength));
        this.sendData(MetaIndex.DISPLAY_SHADOW_STRENGTH);
    }

    public float getDisplayWidth() {
        return this.getData(MetaIndex.DISPLAY_WIDTH).floatValue();
    }

    public void setDisplayWidth(float width) {
        this.setData(MetaIndex.DISPLAY_WIDTH, Float.valueOf(width));
        this.sendData(MetaIndex.DISPLAY_WIDTH);
    }

    public float getDisplayHeight() {
        return this.getData(MetaIndex.DISPLAY_HEIGHT).floatValue();
    }

    public void setDisplayHeight(float height) {
        this.setData(MetaIndex.DISPLAY_HEIGHT, Float.valueOf(height));
        this.sendData(MetaIndex.DISPLAY_HEIGHT);
    }

    public int getInterpolationDelay() {
        return this.getData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS);
    }

    public void setInterpolationDelay(int ticks) {
        this.setData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS, ticks);
        this.sendData(MetaIndex.DISPLAY_INTERPOLATION_START_DELTA_TICKS);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.values()[this.getData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS)];
    }

    @RandomDefaultValue
    public void setBillboard(Display.Billboard billboard) {
        this.setData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS, (byte)billboard.ordinal());
        this.sendData(MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS);
    }

    public Color getGlowColorOverride() {
        int color = this.getData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE);
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        this.setData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE, color == null ? -1 : color.asARGB());
        this.sendData(MetaIndex.DISPLAY_GLOW_COLOR_OVERRIDE);
    }

    public Display.Brightness getBrightness() {
        int data = this.getData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE);
        if (data == -1) {
            return null;
        }
        int blockLight = data >> 4 & 0xFFFF;
        int skyLight = data >> 20 & 0xFFFF;
        return new Display.Brightness(blockLight, skyLight);
    }

    public void setBrightness(Display.Brightness brightness) {
        this.setData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE, brightness == null ? -1 : brightness.getBlockLight() << 4 | brightness.getSkyLight() << 20);
        this.sendData(MetaIndex.DISPLAY_BRIGHTNESS_OVERRIDE);
    }

    public int getTeleportDuration() {
        return this.getData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION);
    }

    public void setTeleportDuration(int duration) {
        this.setData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION, Math.max(0, Math.min(59, duration)));
        this.sendData(MetaIndex.DISPLAY_POS_ROT_INTERPOLATION_DURATION);
    }
}

