/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.BatWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

class DisguiseRunnable
extends BukkitRunnable {
    private int blockX;
    private int blockY;
    private int blockZ;
    private int facing;
    private int deadTicks = 0;
    private int actionBarTicks = -1;
    private int refreshRate;
    private long lastRefreshed = System.currentTimeMillis();
    private final Disguise disguise;
    final Double vectorY;
    final boolean alwaysSendVelocity;

    public DisguiseRunnable(Disguise disguise) {
        this.disguise = disguise;
        switch (disguise.getType()) {
            case FIREWORK: 
            case WITHER_SKULL: 
            case EXPERIENCE_ORB: {
                this.vectorY = 1.0E-6;
                this.alwaysSendVelocity = true;
                break;
            }
            default: {
                this.vectorY = null;
                this.alwaysSendVelocity = false;
            }
        }
        switch (disguise.getType()) {
            case FIREWORK: 
            case EXPERIENCE_ORB: {
                this.refreshRate = 40;
                break;
            }
            case EVOKER_FANGS: {
                this.refreshRate = 23;
                break;
            }
        }
        this.refreshRate *= 50;
    }

    public void run() {
        if (!this.disguise.isDisguiseInUse() || this.disguise.getEntity() == null || !Bukkit.getWorlds().contains(this.disguise.getEntity().getWorld())) {
            this.disguise.stopDisguise();
            if (!this.isCancelled()) {
                this.cancel();
            }
            return;
        }
        if (++this.actionBarTicks % 15 == 0) {
            this.actionBarTicks = 0;
            this.disguise.doActionBar();
        }
        if (this.disguise.getEntity() instanceof Player && !((Player)this.disguise.getEntity()).isOnline()) {
            this.disguise.removeDisguise();
        } else {
            if (this.disguise.disguiseExpires > 0L && (DisguiseConfig.isDynamicExpiry() ? this.disguise.disguiseExpires-- == 1L : this.disguise.disguiseExpires < System.currentTimeMillis())) {
                this.disguise.removeDisguise();
                if (this.disguise.getEntity() instanceof Player) {
                    LibsMsg.EXPIRED_DISGUISE.send((CommandSender)this.disguise.getEntity(), new Object[0]);
                }
                return;
            }
            if (!this.disguise.getEntity().isValid()) {
                if (this.deadTicks++ > (this.disguise.getType() == DisguiseType.ENDER_DRAGON ? 200 : 20) && this.disguise.isRemoveDisguiseOnDeath()) {
                    this.disguise.removeDisguise();
                }
                return;
            }
        }
        this.deadTicks = 0;
        if (this.refreshRate > 0 && this.lastRefreshed + (long)this.refreshRate < System.currentTimeMillis()) {
            this.lastRefreshed = System.currentTimeMillis();
            DisguiseUtilities.refreshTrackers((TargetedDisguise)this.disguise);
        }
        if (this.disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox((TargetedDisguise)this.disguise);
        }
        if (this.disguise.getType() == DisguiseType.BAT && !((BatWatcher)this.disguise.getWatcher()).isHanging()) {
            return;
        }
        this.doVelocity(this.vectorY, this.alwaysSendVelocity);
        if (this.disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
            packet.getIntegers().write(0, (Object)this.disguise.getEntity().getEntityId());
            for (Player player : DisguiseUtilities.getPerverts(this.disguise)) {
                if (this.disguise.getEntity() != player) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                    continue;
                }
                if (!this.disguise.isSelfDisguiseVisible() || !(this.disguise.getEntity() instanceof Player)) continue;
                PacketContainer selfPacket = packet.shallowClone();
                selfPacket.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket((Player)this.disguise.getEntity(), selfPacket, false);
            }
        }
    }

    private void doVelocity(Double vectorY, boolean alwaysSendVelocity) {
        if (this.disguise.isVelocitySent() && vectorY != null && (alwaysSendVelocity || !this.disguise.getEntity().isOnGround())) {
            Vector vector = this.disguise.getEntity().getVelocity();
            if (!(vector.getY() == 0.0 || vector.getY() < 0.0 && alwaysSendVelocity && this.disguise.getEntity().isOnGround())) {
                return;
            }
            if (this.disguise.getType() != DisguiseType.EXPERIENCE_ORB || !this.disguise.getEntity().isOnGround()) {
                PacketContainer lookPacket = null;
                if (this.disguise.getType() == DisguiseType.WITHER_SKULL && DisguiseConfig.isWitherSkullPacketsEnabled()) {
                    lookPacket = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                    StructureModifier mods = lookPacket.getModifier();
                    lookPacket.getIntegers().write(0, (Object)this.disguise.getEntity().getEntityId());
                    Location loc = this.disguise.getEntity().getLocation();
                    mods.write(4, (Object)DisguiseUtilities.getYaw(this.disguise.getType(), this.disguise.getEntity().getType(), (byte)Math.floor(loc.getYaw() * 256.0f / 360.0f)));
                    mods.write(5, (Object)DisguiseUtilities.getPitch(this.disguise.getType(), this.disguise.getEntity().getType(), (byte)Math.floor(loc.getPitch() * 256.0f / 360.0f)));
                    if (this.disguise.isSelfDisguiseVisible() && this.disguise.getEntity() instanceof Player) {
                        PacketContainer selfLookPacket = lookPacket.shallowClone();
                        selfLookPacket.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket((Player)this.disguise.getEntity(), selfLookPacket, false);
                    }
                }
                try {
                    PacketContainer velocityPacket = new PacketContainer(PacketType.Play.Server.ENTITY_VELOCITY);
                    StructureModifier mods = velocityPacket.getIntegers();
                    mods.write(0, (Object)this.disguise.getEntity().getEntityId());
                    mods.write(1, (Object)((int)(vector.getX() * 8000.0)));
                    mods.write(3, (Object)((int)(vector.getZ() * 8000.0)));
                    for (Player player : DisguiseUtilities.getPerverts(this.disguise)) {
                        PacketContainer tempVelocityPacket = velocityPacket.shallowClone();
                        mods = tempVelocityPacket.getIntegers();
                        if (this.disguise.getEntity() == player) {
                            if (!this.disguise.isSelfDisguiseVisible()) continue;
                            mods.write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        }
                        mods.write(2, (Object)((int)(8000.0 * (vectorY * ReflectionManager.getPing(player)) * 0.069)));
                        if (lookPacket != null && player != this.disguise.getEntity()) {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, lookPacket, false);
                        }
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, tempVelocityPacket, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

