/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_19_R3;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Vector3f;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R3.CraftArt;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager
implements ReflectionManagerAbstract {
    @Override
    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof EntityLiving) {
            return nmsEntity.ak > 0;
        }
        return nmsEntity.b(nmsEntity.dG().n());
    }

    @Override
    public int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.bP.k();
    }

    @Override
    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    @Override
    public int getNewEntityId(boolean increment) {
        try {
            Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("d");
            entityCounter.setAccessible(true);
            AtomicInteger atomicInteger = (AtomicInteger)entityCounter.get(null);
            if (increment) {
                return atomicInteger.incrementAndGet();
            }
            return atomicInteger.get();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().b;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        Optional optional = EntityTypes.a((String)entityName.toLowerCase(Locale.ROOT));
        if (optional.isPresent()) {
            net.minecraft.world.entity.Entity entity;
            EntityTypes entityType = (EntityTypes)optional.get();
            WorldServer world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityType == EntityTypes.bt) {
                WrappedGameProfile gameProfile = ReflectionManagerAbstract.getGameProfile(new UUID(0L, 0L), "Steve");
                entity = new EntityPlayer((MinecraftServer)this.getMinecraftServer(), world, (GameProfile)gameProfile.getHandle());
            } else {
                entity = entityType.a((net.minecraft.world.level.World)world);
            }
            if (entity == null) {
                return null;
            }
            entity.e(1.0, 1.0, 1.0);
            entity.e(0.0, 0.0, 0.0);
            return entity;
        }
        return null;
    }

    public MobEffectList getMobEffectList(int id) {
        return MobEffectList.a((int)id);
    }

    public MobEffect createMobEffect(PotionEffect effect) {
        return this.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public MobEffect createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        return new MobEffect(this.getMobEffectList(id), duration, amplification, ambient, particles);
    }

    public AxisAlignedBB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().cD();
    }

    @Override
    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).d - this.getBoundingBox((Entity)entity).a;
    }

    @Override
    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).e - this.getBoundingBox((Entity)entity).b;
    }

    @Override
    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).f - this.getBoundingBox((Entity)entity).c;
    }

    public EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).f();
    }

    @Override
    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    @Override
    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    @Override
    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public Holder<SoundEffect> getCraftSound(Sound sound) {
        return BuiltInRegistries.c.d((Object)CraftSound.getSoundEffect((Sound)sound));
    }

    public EntityTrackerEntry getEntityTrackerEntry(Entity target) throws Exception {
        WorldServer world = ((CraftWorld)target.getWorld()).getHandle();
        ChunkProviderServer chunkSource = world.k();
        PlayerChunkMap chunkMap = chunkSource.a;
        Int2ObjectMap entityMap = chunkMap.L;
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        Field field = PlayerChunkMap.EntityTracker.class.getDeclaredField("b");
        field.setAccessible(true);
        return (EntityTrackerEntry)field.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    @Override
    public String getEnumArt(Art art) {
        return BuiltInRegistries.m.b((Object)((PaintingVariant)CraftArt.BukkitToNotch((Art)art).a())).a();
    }

    public net.minecraft.core.BlockPosition getBlockPosition(int x, int y, int z) {
        return new net.minecraft.core.BlockPosition(x, y, z);
    }

    public EnumDirection getEnumDirection(int direction) {
        return EnumDirection.b((int)direction);
    }

    @Override
    public void handleTablistPacket(PacketEvent event, Function<UUID, Boolean> shouldRemove) {
        ClientboundPlayerInfoUpdatePacket packet = (ClientboundPlayerInfoUpdatePacket)event.getPacket().getHandle();
        if (!packet.a().contains(ClientboundPlayerInfoUpdatePacket.a.a)) {
            return;
        }
        ArrayList<ClientboundPlayerInfoUpdatePacket.b> canKeep = new ArrayList<ClientboundPlayerInfoUpdatePacket.b>();
        for (ClientboundPlayerInfoUpdatePacket.b entry : packet.c()) {
            if (shouldRemove.apply(entry.a()).booleanValue()) continue;
            canKeep.add(entry);
        }
        if (canKeep.size() == packet.c().size()) {
            return;
        }
        if (canKeep.isEmpty()) {
            event.setCancelled(true);
            return;
        }
        event.getPacket().getModifier().write(1, canKeep);
    }

    @Override
    public PacketContainer getTabListPacket(String displayName, WrappedGameProfile gameProfile, boolean nameVisible, EnumWrappers.PlayerInfoAction ... actions) {
        if (actions[0] == EnumWrappers.PlayerInfoAction.REMOVE_PLAYER) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO_REMOVE);
            packet.getModifier().write(0, Collections.singletonList(gameProfile.getUUID()));
            return packet;
        }
        ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(gameProfile.getUUID(), (GameProfile)gameProfile.getHandle(), nameVisible, 0, EnumGamemode.a, (IChatBaseComponent)IChatBaseComponent.b((String)displayName), null);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        StructureModifier modifier = packet.getModifier();
        EnumSet enumSet = EnumSet.copyOf(Arrays.stream(actions).map(action -> ClientboundPlayerInfoUpdatePacket.a.valueOf((String)action.name())).collect(Collectors.toList()));
        modifier.write(0, enumSet);
        modifier.write(1, Collections.singletonList(entry));
        return packet;
    }

    @Override
    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    @Override
    public double getPing(Player player) {
        return player.getPing();
    }

    @Override
    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntitySize dimensions = nmsEntity.a(EntityPose.a);
        return new float[]{dimensions.a, nmsEntity.cE()};
    }

    @Override
    public WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        DedicatedServer minecraftServer = this.getMinecraftServer();
        MinecraftSessionService sessionService = minecraftServer.am();
        return WrappedGameProfile.fromHandle((Object)sessionService.fillProfileProperties((GameProfile)gameProfile.getHandle(), true));
    }

    @Override
    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            Method method = EntityLiving.class.getDeclaredMethod("eN", new Class[0]);
            method.setAccessible(true);
            return (Float)method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void injectCallback(String playername, ProfileLookupCallback callback) {
        Agent agent = Agent.MINECRAFT;
        this.getMinecraftServer().ao().findProfilesByNames(new String[]{playername}, agent, callback);
    }

    @Override
    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    @Override
    public Enum getSoundCategory(String category) {
        return (Enum)Arrays.stream(SoundCategory.values()).filter(soundSource -> category.equalsIgnoreCase(soundSource.a())).findAny().get();
    }

    @Override
    public Enum createEnumItemSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return EnumItemSlot.a;
            }
            case OFF_HAND: {
                return EnumItemSlot.b;
            }
            case FEET: {
                return EnumItemSlot.c;
            }
            case LEGS: {
                return EnumItemSlot.d;
            }
            case CHEST: {
                return EnumItemSlot.e;
            }
            case HEAD: {
                return EnumItemSlot.f;
            }
        }
        return null;
    }

    @Override
    public Object getSoundString(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound).a().toString();
    }

    @Override
    public Optional<?> convertOptional(Object val) {
        if (val instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)val;
            return Optional.of(this.getBlockPosition(pos.getX(), pos.getY(), pos.getZ()));
        }
        if (val instanceof WrappedBlockData) {
            Object obj = ((WrappedBlockData)val).getHandle();
            return Optional.of(obj);
        }
        if (val instanceof ItemStack) {
            net.minecraft.world.item.ItemStack obj = this.getNmsItem((ItemStack)val);
            return Optional.of(obj);
        }
        if (val instanceof WrappedChatComponent) {
            Object obj = ((WrappedChatComponent)val).getHandle();
            return Optional.of(obj);
        }
        return Optional.of(val);
    }

    public Vector3f convertVec3(Object object) {
        if (object instanceof Vector3F) {
            Vector3F vector3F = (Vector3F)object;
            return new Vector3f(vector3F.getX(), vector3F.getY(), vector3F.getZ());
        }
        if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            return new Vector3f((float)eulerAngle.getX(), (float)eulerAngle.getY(), (float)eulerAngle.getZ());
        }
        return null;
    }

    public EnumDirection convertDirection(EnumWrappers.Direction direction) {
        return EnumDirection.a((int)direction.ordinal());
    }

    @Override
    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    @Override
    public String getItemName(Material material) {
        return BuiltInRegistries.i.b((Object)CraftMagicNumbers.getItem((Material)material)).a();
    }

    public net.minecraft.world.item.ItemStack getNmsItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    public VillagerData getNmsVillagerData(Villager.Type villagerType, Villager.Profession villagerProfession, int level) {
        VillagerType nmsVillagerType = (VillagerType)BuiltInRegistries.y.a(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerType.getKey()));
        VillagerProfession nmsVillagerProfession = (VillagerProfession)BuiltInRegistries.z.a(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerProfession.getKey()));
        return new VillagerData(nmsVillagerType, nmsVillagerProfession, level);
    }

    public VillagerType getVillagerType(Villager.Type type) {
        return (VillagerType)BuiltInRegistries.y.a(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey()));
    }

    public VillagerProfession getVillagerProfession(Villager.Profession profession) {
        return (VillagerProfession)BuiltInRegistries.z.a(CraftNamespacedKey.toMinecraft((NamespacedKey)profession.getKey()));
    }

    public <T> DataWatcher.Item<T> createDataWatcherItem(WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject, T metaItem) {
        return new DataWatcher.Item((DataWatcherObject)wrappedDataWatcherObject.getHandle(), metaItem);
    }

    public Holder<SoundEffect> createSoundEvent(String minecraftKey) {
        return BuiltInRegistries.c.d((Object)SoundEffect.a((MinecraftKey)this.createMinecraftKey(minecraftKey)));
    }

    public MinecraftKey createMinecraftKey(String name) {
        return new MinecraftKey(name);
    }

    public Vec3D getVec3D(Vector vector) {
        return new Vec3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    @Override
    public Object registerEntityType(NamespacedKey key) {
        EntityTypes newEntity = new EntityTypes(null, null, false, false, false, false, null, null, 0, 0, FeatureFlagSet.a());
        IRegistry.a((IRegistry)BuiltInRegistries.h, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.g();
        return newEntity;
    }

    @Override
    public int getEntityTypeId(Object entityTypes) {
        EntityTypes entityType = (EntityTypes)entityTypes;
        return BuiltInRegistries.h.a((Object)entityType);
    }

    @Override
    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    @Override
    public Object getEntityType(NamespacedKey name) {
        return BuiltInRegistries.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    @Override
    public Object getNmsEntityPose(String enumPose) {
        return EntityPose.valueOf((String)enumPose);
    }

    @Override
    public int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.i((IBlockData)state);
    }

    @Override
    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.i((IBlockData)block.o());
    }

    @Override
    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.a((int)id));
    }

    @Override
    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.a((int)id).b()));
    }

    public WorldServer getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    @Override
    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_19_R3.inventory.CraftMetaItem$SerializableMeta");
            Method deserialize = aClass.getDeclaredMethod("deserialize", Map.class);
            Object itemMeta = deserialize.invoke(null, meta);
            return (ItemMeta)itemMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object convertInvalidMeta(Object value) {
        if (value instanceof Frog.Variant) {
            return this.getFrogVariant((Frog.Variant)value);
        }
        if (value instanceof Cat.Type) {
            return this.getCatVariant((Cat.Type)value);
        }
        if (value instanceof Art) {
            return this.getArtVariant((Art)value);
        }
        if (value instanceof BlockData) {
            return ((CraftBlockData)value).getState();
        }
        return value;
    }

    private FrogVariant getFrogVariant(Frog.Variant variant) {
        switch (variant) {
            case COLD: {
                return FrogVariant.c;
            }
            case WARM: {
                return FrogVariant.b;
            }
            case TEMPERATE: {
                return FrogVariant.a;
            }
        }
        return null;
    }

    private CatVariant getCatVariant(Cat.Type type) {
        return (CatVariant)BuiltInRegistries.ai.a(type.ordinal());
    }

    private Holder.c<PaintingVariant> getArtVariant(Art art) {
        return (Holder.c)BuiltInRegistries.m.c(art.ordinal()).get();
    }
}

