/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.util.Set;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerSounds
extends PacketAdapter {
    public PacketListenerSounds(LibsDisguises plugin) {
        PacketType[] packetTypeArray;
        if (NmsVersion.v1_19_R2.isSupported()) {
            PacketType[] packetTypeArray2 = new PacketType[2];
            packetTypeArray2[0] = PacketType.Play.Server.NAMED_SOUND_EFFECT;
            packetTypeArray = packetTypeArray2;
            packetTypeArray2[1] = PacketType.Play.Server.ENTITY_SOUND;
        } else {
            PacketType[] packetTypeArray3 = new PacketType[1];
            packetTypeArray = packetTypeArray3;
            packetTypeArray3[0] = PacketType.Play.Server.NAMED_SOUND_EFFECT;
        }
        super((Plugin)plugin, ListenerPriority.NORMAL, packetTypeArray);
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled() || event.isAsync() || event.isPlayerTemporary()) {
            return;
        }
        this.handleNamedSoundEffect(event);
    }

    private void handleNamedSoundEffect(PacketEvent event) {
        PacketContainer newPacket;
        Entity entity;
        Disguise disguise;
        int offset;
        Object soundEffectObj;
        SoundGroup soundGroup;
        Player observer;
        StructureModifier mods;
        block14: {
            mods = event.getPacket().getModifier();
            observer = event.getPlayer();
            soundGroup = null;
            soundEffectObj = mods.read(0);
            offset = 0;
            disguise = null;
            entity = null;
            if (event.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT) {
                offset = 2;
                int[] soundCords = new int[]{(Integer)mods.read(2), (Integer)mods.read(3), (Integer)mods.read(4)};
                for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
                    for (TargetedDisguise entityDisguise : disguises) {
                        entity = entityDisguise.getEntity();
                        if (entity == null || entity.getWorld() != observer.getWorld() || !entityDisguise.canSee(observer)) continue;
                        Location loc = entity.getLocation();
                        int[] entCords = new int[]{(int)(loc.getX() * 8.0), (int)(loc.getY() * 8.0), (int)(loc.getZ() * 8.0)};
                        if (soundCords[0] != entCords[0] || soundCords[1] != entCords[1] || soundCords[2] != entCords[2]) continue;
                        disguise = entityDisguise;
                        soundGroup = SoundGroup.getGroup(entity.getType().name());
                        break block14;
                    }
                }
            } else {
                disguise = DisguiseUtilities.getDisguise(observer, (Integer)mods.read(2));
                if (disguise == null) {
                    return;
                }
                entity = disguise.getEntity();
                soundGroup = SoundGroup.getGroup(entity.getType().name());
            }
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        if (soundGroup == null || soundGroup.getSound(soundEffectObj) == null) {
            return;
        }
        SoundGroup.SoundType soundType = !(entity instanceof LivingEntity) || ((LivingEntity)entity).getHealth() > 0.0 ? soundGroup.getType(soundEffectObj) : SoundGroup.SoundType.DEATH;
        if (entity == observer && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        SoundGroup disguiseSound = SoundGroup.getGroup(disguise);
        if (disguiseSound == null) {
            event.setCancelled(true);
            return;
        }
        Object sound = disguiseSound.getSound(soundType);
        if (sound == null) {
            event.setCancelled(true);
            return;
        }
        Enum soundCat = ReflectionManager.getSoundCategory(disguise.getType());
        float volume = ((Float)mods.read(offset + 3)).floatValue();
        float pitch = ((Float)mods.read(offset + 4)).floatValue();
        if (volume == soundGroup.getDamageAndIdleSoundVolume()) {
            volume = disguiseSound.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && entity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if (!NmsVersion.v1_19_R2.isSupported() && sound.getClass().getSimpleName().equals("MinecraftKey")) {
            newPacket = new PacketContainer(PacketType.Play.Server.CUSTOM_SOUND_EFFECT);
            StructureModifier newModifs = newPacket.getModifier();
            newModifs.write(2, mods.read(2));
            newModifs.write(3, mods.read(3));
            newModifs.write(4, mods.read(4));
            mods = newModifs;
        } else {
            newPacket = event.getPacket().shallowClone();
            mods = newPacket.getModifier();
        }
        mods.write(0, sound);
        mods.write(1, (Object)soundCat);
        mods.write(offset + 3, (Object)Float.valueOf(volume));
        mods.write(offset + 4, (Object)Float.valueOf(pitch));
        event.setPacket(newPacket);
    }
}

