/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser.constructors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;

public abstract class ExtraDisguiseParam<T> {
    public abstract boolean isApplicable(DisguiseType var1);

    public boolean isApplicable(DisguiseType disguiseType, String arg) {
        return this.isApplicable(disguiseType);
    }

    public abstract ParamInfo<T> getParamInfo();

    public abstract String getParameterMethod();

    public T createParametervalue(CommandSender sender, String arg) throws DisguiseParseException {
        return this.getParamInfo().fromString(new ArrayList<String>(Collections.singletonList(arg)));
    }

    public abstract String getParameterAsString(T var1);

    public void checkParameterPermission(CommandSender sender, DisguisePermissions permissions, HashMap<String, HashMap<String, Boolean>> disguiseOptions, ArrayList<String> usedOptions, DisguisePerm disguisePerm, T param) throws DisguiseParseException {
        this.checkParameterPermission(permissions, disguiseOptions, usedOptions, disguisePerm, param);
    }

    public void checkParameterPermission(DisguisePermissions permissions, HashMap<String, HashMap<String, Boolean>> disguiseOptions, ArrayList<String> usedOptions, DisguisePerm disguisePerm, T param) throws DisguiseParseException {
        String itemName;
        usedOptions.add(this.getParameterMethod().toLowerCase());
        if (!permissions.isAllowedDisguise(disguisePerm, usedOptions)) {
            throw new DisguiseParseException(LibsMsg.D_PARSE_NOPERM, usedOptions.stream().reduce((first, second) -> second).orElse(null));
        }
        String string = itemName = param == null ? "null" : this.getParameterAsString(param);
        if (!DisguisePermissions.hasPermissionOption(disguiseOptions, this.getParameterMethod(), itemName)) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, itemName, disguisePerm.toReadable());
        }
    }
}

