/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.ItemStack;

public class ParamInfoItemStackArray
extends ParamInfoItemStack {
    public ParamInfoItemStackArray(Class paramClass, String name, String valueType, String description, Enum[] possibleValues) {
        super(paramClass, name, valueType, description, possibleValues);
        this.setOtherValues("%armor%");
    }

    @Override
    public boolean canReturnNull() {
        return false;
    }

    @Override
    public Set<String> getEnums(String tabComplete) {
        ArrayList<String> split = this.split(tabComplete);
        LinkedHashSet<String> toReturn = new LinkedHashSet<String>();
        if (split == null || split.stream().anyMatch(s -> s.equalsIgnoreCase("%armor%"))) {
            return toReturn;
        }
        String lastEntry = split.remove(split.size() - 1);
        for (String material : super.getEnums(null)) {
            if (!split.isEmpty() && !material.toLowerCase(Locale.ENGLISH).startsWith(lastEntry.toLowerCase(Locale.ENGLISH))) continue;
            toReturn.add(StringUtils.join(split, (String)",") + (split.isEmpty() ? "" : ",") + material);
        }
        return toReturn;
    }

    @Override
    public String toString(Object object) {
        ItemStack[] stacks = (ItemStack[])object;
        String returns = "";
        for (int i = 0; i < stacks.length; ++i) {
            if (i > 0) {
                returns = returns + ",";
            }
            if (stacks[i] == null) continue;
            String toString = super.toString(stacks[i]);
            if (toString.startsWith("{")) {
                return DisguiseUtilities.getGson().toJson(object);
            }
            returns = returns + toString;
        }
        return returns;
    }

    @Override
    public ItemStack[] fromString(String string) {
        ArrayList<String> split;
        if (string.startsWith("[") && string.endsWith("]")) {
            try {
                return (ItemStack[])DisguiseUtilities.getGson().fromJson(string, ItemStack[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((split = this.split(string)) == null || split.size() != 4) {
            return null;
        }
        ItemStack[] items = new ItemStack[4];
        for (int a = 0; a < 4; ++a) {
            items[a] = ParamInfoItemStackArray.parseToItemstack(split.get(a));
        }
        return items;
    }

    private ArrayList<String> split(String string) {
        ArrayList<String> split = new ArrayList<String>();
        char[] chars = string.toCharArray();
        boolean quote = false;
        int depth = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (split.size() > 3 || depth < 0) {
                return null;
            }
            char c = chars[i];
            if (!quote && depth == 0 && c == ',') {
                split.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
            if (c == '\\' && i + 1 < chars.length) {
                builder.append(chars[++i]);
                continue;
            }
            if (c == '\"') {
                quote = !quote;
                continue;
            }
            if (quote) continue;
            if (c == '{' || c == '[') {
                ++depth;
                continue;
            }
            if (c != '}' && c != ']') continue;
            --depth;
        }
        if (quote || depth != 0) {
            return null;
        }
        split.add(builder.toString());
        return split;
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

