/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EndermanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoTypes;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoSoundGroup;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ParamInfoManager {
    private static final List<ParamInfo> paramList;
    private static final DisguiseMethods disguiseMethods;
    private static final ParamInfoItemBlock paramInfoItemBlock;
    private static final ParamInfoSoundGroup paramInfoSoundGroup;

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ParamInfo info = ParamInfoManager.getParamInfo(object.getClass());
        if (info == null) {
            throw new IllegalArgumentException(object.getClass() + " is not handled by ParamInfo!");
        }
        return info.toString(object);
    }

    public static ParamInfo getParamInfo(WatcherMethod method) {
        if (method.getName().equalsIgnoreCase("setSoundGroup")) {
            return ParamInfoManager.getParamInfoSoundGroup();
        }
        if (method.getWatcherClass() == EndermanWatcher.class && method.getName().equalsIgnoreCase("setItemInMainHand")) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        if (method.getWatcherClass() == FallingBlockWatcher.class && (method.getParam() == Material.class || method.getParam() == ItemStack.class)) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        return ParamInfoManager.getParamInfo(method.getParam());
    }

    public static ParamInfo getParamInfo(Class c) {
        if (c.isAnonymousClass()) {
            c = c.getSuperclass();
        }
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            if (!info.isParam(c)) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguiseType, String methodName) {
        return ParamInfoManager.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (WatcherMethod method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase(Locale.ENGLISH).equals(methodName.toLowerCase(Locale.ENGLISH))) continue;
            return ParamInfoManager.getParamInfo(method);
        }
        return null;
    }

    public static WatcherMethod[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass) {
        return ParamInfoManager.getDisguiseWatcherMethods(watcherClass, false);
    }

    public static WatcherMethod[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass, boolean includeIgnored) {
        if (watcherClass == null) {
            return new WatcherMethod[0];
        }
        ArrayList<WatcherMethod> methods = new ArrayList<WatcherMethod>(disguiseMethods.getMethods(watcherClass));
        if (!includeIgnored) {
            methods.removeIf(WatcherMethod::isHideFromTab);
        }
        methods.sort((m1, m2) -> {
            int v2;
            int v1 = ParamInfoManager.getValue(m1);
            if (v1 != (v2 = ParamInfoManager.getValue(m2))) {
                return v1 - v2;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
        });
        return methods.toArray(new WatcherMethod[0]);
    }

    public static int getValue(WatcherMethod method) {
        Class<? extends FlagWatcher> declaring = method.getWatcherClass();
        if (declaring == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }

    public static DisguiseMethods getDisguiseMethods() {
        return disguiseMethods;
    }

    public static ParamInfoItemBlock getParamInfoItemBlock() {
        return paramInfoItemBlock;
    }

    public static ParamInfoSoundGroup getParamInfoSoundGroup() {
        return paramInfoSoundGroup;
    }

    static {
        ParamInfoTypes infoTypes = new ParamInfoTypes();
        paramList = infoTypes.getParamInfos();
        paramInfoItemBlock = infoTypes.getParamInfoBlock();
        paramInfoSoundGroup = paramList.stream().filter(p -> p instanceof ParamInfoSoundGroup).findAny().orElse(null);
        disguiseMethods = new DisguiseMethods();
    }
}

