/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.util.ArrayList;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Location;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketHandlerMovement
implements IPacketHandler {
    private final boolean invalid = LibsPremium.getUserID().matches("\\d+") && Integer.parseInt(LibsPremium.getUserID()) < 2;

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.REL_ENTITY_MOVE};
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0);
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        this.handle2(disguise, sentPacket, packets, observer, entity);
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return;
        }
        ArrayList<PacketContainer> toAdd = new ArrayList<PacketContainer>();
        double height = disguise.getHeight() + (double)disguise.getWatcher().getNameYModifier();
        for (PacketContainer packet : packets.getPackets()) {
            if (packet.getType() == PacketType.Play.Server.ENTITY_LOOK) continue;
            for (int i = 0; i < len; ++i) {
                int standId = disguise.getArmorstandIds()[i];
                PacketContainer packet2 = packet.shallowClone();
                packet2.getIntegers().write(0, (Object)standId);
                if (packet2.getType() == PacketType.Play.Server.ENTITY_TELEPORT) {
                    packet2.getDoubles().write(1, (Object)((Double)packet2.getDoubles().read(1) + height + 0.28 * (double)i));
                }
                toAdd.add(packet2);
            }
        }
        packets.getPackets().addAll(toAdd);
    }

    public void handle2(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        if (this.invalid && RandomUtils.nextDouble() < 0.1) {
            packets.clear();
            return;
        }
        double yMod = DisguiseUtilities.getYModifier(disguise) + (double)disguise.getWatcher().getYModifier();
        if (disguise.getType() == DisguiseType.FALLING_BLOCK && ((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
            packets.clear();
            if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK) {
                return;
            }
            PacketContainer movePacket = sentPacket.shallowClone();
            Location loc = entity.getLocation();
            if (movePacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT) {
                StructureModifier doubles = movePacket.getDoubles();
                doubles.write(0, (Object)((double)loc.getBlockX() + 0.5));
                double y = loc.getBlockY();
                doubles.write(1, (Object)((y += loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0)) + yMod));
                doubles.write(2, (Object)((double)loc.getBlockZ() + 0.5));
            } else {
                boolean sameBlock;
                int z;
                int y;
                int x;
                if (NmsVersion.v1_14.isSupported()) {
                    StructureModifier shorts = movePacket.getShorts();
                    x = ((Short)shorts.read(0)).shortValue();
                    y = ((Short)shorts.read(1)).shortValue();
                    z = ((Short)shorts.read(2)).shortValue();
                } else {
                    StructureModifier ints = movePacket.getIntegers();
                    x = (Integer)ints.read(0);
                    y = (Integer)ints.read(1);
                    z = (Integer)ints.read(2);
                }
                Vector diff = new Vector((double)x / 4096.0, (double)y / 4096.0, (double)z / 4096.0);
                Location newLoc = loc.clone().subtract(diff);
                double origY = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                double newY = (double)newLoc.getBlockY() + (newLoc.getY() % 1.0 >= 0.85 ? 1.0 : (newLoc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                boolean bl = sameBlock = loc.getBlockX() == newLoc.getBlockX() && newY == origY && loc.getBlockZ() == newLoc.getBlockZ();
                if (sameBlock) {
                    return;
                }
                x = this.conRel(loc.getBlockX(), newLoc.getBlockX());
                y = this.conRel(origY, newY);
                z = this.conRel(loc.getBlockZ(), newLoc.getBlockZ());
                if (NmsVersion.v1_14.isSupported()) {
                    StructureModifier shorts = movePacket.getShorts();
                    shorts.write(0, (Object)((short)x));
                    shorts.write(1, (Object)((short)y));
                    shorts.write(2, (Object)((short)z));
                } else {
                    StructureModifier ints = movePacket.getIntegers();
                    ints.write(0, (Object)x);
                    ints.write(1, (Object)y);
                    ints.write(2, (Object)z);
                }
            }
            packets.addPacket(movePacket);
            return;
        }
        if (disguise.getType() == DisguiseType.RABBIT && (sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE || sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK)) {
            long lastHop = 999999L;
            if (!entity.getMetadata("LibsRabbitHop").isEmpty()) {
                lastHop = System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong();
            }
            if (lastHop < 100L || lastHop > 500L) {
                if (lastHop > 500L) {
                    entity.removeMetadata("LibsRabbitHop", (Plugin)LibsDisguises.getInstance());
                    entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
                }
                PacketContainer statusPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
                packets.addPacket(statusPacket);
                statusPacket.getIntegers().write(0, (Object)entity.getEntityId());
                statusPacket.getBytes().write(0, (Object)1);
            }
        }
        if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.WITHER_SKULL) {
            packets.clear();
        } else {
            if (sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE) {
                packets.clear();
                PacketContainer movePacket = sentPacket.shallowClone();
                packets.addPacket(movePacket);
                StructureModifier bytes = movePacket.getBytes();
                byte yawValue = (Byte)bytes.read(0);
                byte pitchValue = (Byte)bytes.read(1);
                Float pitchLock = disguise.getWatcher().getPitchLock();
                Float yawLock = disguise.getWatcher().getYawLock();
                if (pitchLock != null) {
                    pitchValue = (byte)(pitchLock.floatValue() * 256.0f / 360.0f);
                    pitchValue = DisguiseUtilities.getPitch(disguise.getType(), pitchValue);
                } else {
                    pitchValue = DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue);
                }
                if (yawLock != null) {
                    yawValue = (byte)(yawLock.floatValue() * 256.0f / 360.0f);
                    yawValue = DisguiseUtilities.getYaw(disguise.getType(), yawValue);
                } else {
                    yawValue = DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue);
                }
                bytes.write(0, (Object)yawValue);
                bytes.write(1, (Object)pitchValue);
                if (entity == observer.getVehicle() && AbstractHorse.class.isAssignableFrom(disguise.getType().getEntityClass())) {
                    PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                    packet.getIntegers().write(0, (Object)DisguiseAPI.getEntityAttachmentId());
                    packet.getBytes().write(0, (Object)yawValue);
                    packet.getBytes().write(1, (Object)pitchValue);
                    packets.addPacket(packet);
                } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT && disguise.getType() == DisguiseType.ITEM_FRAME) {
                    double y;
                    StructureModifier doubles = movePacket.getDoubles();
                    Location loc = entity.getLocation();
                    double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                    if (data % 2.0 == 0.0) {
                        if (data % 2.0 == 0.0) {
                            doubles.write(3, (Object)loc.getZ());
                        } else {
                            doubles.write(1, (Object)loc.getZ());
                        }
                    }
                    if ((y = DisguiseUtilities.getYModifier(disguise)) != 0.0) {
                        doubles.write(2, (Object)((Double)doubles.read(2) + y));
                    }
                } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                    movePacket.getBooleans().write(0, (Object)false);
                }
            } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                packets.clear();
                PacketContainer movePacket = sentPacket.shallowClone();
                packets.addPacket(movePacket);
                movePacket.getBooleans().write(0, (Object)false);
            }
            if (yMod != 0.0 && sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT) {
                PacketContainer packet = packets.getPackets().get(0);
                if (packet == sentPacket) {
                    packet = packet.shallowClone();
                    packets.clear();
                    packets.addPacket(packet);
                }
                StructureModifier doubles = packet.getDoubles();
                doubles.write(1, (Object)((Double)doubles.read(1) + yMod));
            }
        }
    }
}

