/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHandlerEquipment
implements IPacketHandler {
    private PacketsHandler packetsHandler;

    public PacketHandlerEquipment(PacketsHandler packetsHandler) {
        this.packetsHandler = packetsHandler;
    }

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT};
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        if (NmsVersion.v1_16.isSupported()) {
            this.handleNew(disguise, sentPacket, packets, observer, entity);
        } else {
            this.handleOld(disguise, sentPacket, packets, observer, entity);
        }
    }

    public void handleNew(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        List slots = (List)packets.getPackets().get(0).getModifier().read(1);
        ArrayList<Pair> newSlots = new ArrayList<Pair>();
        boolean constructed = false;
        for (Pair pair : slots) {
            EquipmentSlot slot = ReflectionManager.createEquipmentSlot(pair.getFirst());
            ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
            if (itemStack != null) {
                if (!constructed) {
                    constructed = true;
                    if (packets.getPackets().size() > 1) {
                        packets.getPackets().remove(1);
                    } else {
                        packets.clear();
                    }
                    PacketContainer equipPacket = sentPacket.shallowClone();
                    packets.getPackets().add(packets.getPackets().size(), equipPacket);
                    equipPacket.getModifier().write(1, newSlots);
                }
                newSlots.add(Pair.of((Object)pair.getFirst(), (Object)ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack)));
            } else {
                newSlots.add(pair);
                itemStack = ReflectionManager.getBukkitItem(pair.getSecond());
            }
            if ((!disguise.getWatcher().isMainHandRaised() || slot != EquipmentSlot.HAND) && (!(disguise.getWatcher() instanceof LivingWatcher) || !((LivingWatcher)disguise.getWatcher()).isOffhandRaised() || slot != EquipmentSlot.OFF_HAND) || itemStack == null || itemStack.getType() == Material.AIR) continue;
            List<WatcherValue> list = new ArrayList<WatcherValue>();
            if (DisguiseConfig.isMetaPacketsEnabled()) {
                WatcherValue watch = new WatcherValue(MetaIndex.LIVING_META, (Object)WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(MetaIndex.LIVING_META.getIndex()));
                if (watch != null) {
                    list.add(watch);
                }
                list = disguise.getWatcher().convert(observer, list);
            } else {
                for (WatcherValue obj : disguise.getWatcher().getWatchableObjects()) {
                    if (obj.getIndex() != MetaIndex.LIVING_META.getIndex()) continue;
                    list.add(obj);
                    break;
                }
            }
            PacketContainer packetBlock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
            list.forEach(v -> v.setValue((byte)0));
            PacketContainer packetUnblock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
            PacketContainer packet1 = packets.getPackets().get(0);
            packets.clear();
            packets.addPacket(packetUnblock);
            packets.addPacket(packet1);
            packets.addPacket(packetBlock);
        }
    }

    public void handleOld(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        EquipmentSlot slot = ReflectionManager.createEquipmentSlot(packets.getPackets().get(0).getModifier().read(1));
        ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
        if (itemStack != null) {
            packets.clear();
            PacketContainer equipPacket = sentPacket.shallowClone();
            packets.addPacket(equipPacket);
            equipPacket.getModifier().write(2, ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack));
        }
        if (disguise.getWatcher().isMainHandRaised() && slot == EquipmentSlot.HAND || disguise.getWatcher() instanceof LivingWatcher && ((LivingWatcher)disguise.getWatcher()).isOffhandRaised() && slot == EquipmentSlot.OFF_HAND) {
            if (itemStack == null) {
                itemStack = (ItemStack)packets.getPackets().get(0).getItemModifier().read(0);
            }
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                MetaIndex<Byte> toUse;
                List<WatcherValue> list = new ArrayList<WatcherValue>();
                MetaIndex<Byte> metaIndex = toUse = NmsVersion.v1_13.isSupported() ? MetaIndex.LIVING_META : MetaIndex.ENTITY_META;
                if (DisguiseConfig.isMetaPacketsEnabled()) {
                    WatcherValue watch = new WatcherValue(toUse, (Object)WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(toUse.getIndex()));
                    if (watch != null) {
                        list.add(watch);
                    }
                    list = disguise.getWatcher().convert(observer, list);
                } else {
                    for (WatcherValue obj : disguise.getWatcher().getWatchableObjects()) {
                        if (obj.getIndex() != toUse.getIndex()) continue;
                        list.add(obj);
                        break;
                    }
                }
                PacketContainer packetBlock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
                list.forEach(v -> v.setValue(NmsVersion.v1_13.isSupported() ? (byte)0 : (byte)((Byte)v.getValue() & 0xFFFFFFEF)));
                PacketContainer packetUnblock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
                PacketContainer packet1 = packets.getPackets().get(0);
                packets.clear();
                packets.addPacket(packetUnblock);
                packets.addPacket(packet1);
                packets.addPacket(packetBlock);
            }
        }
    }
}

