/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_19_1;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Vector3f;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R1.CraftArt;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftSound;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager
implements ReflectionManagerAbstract {
    @Override
    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof EntityLiving) {
            return nmsEntity.W > 0;
        }
        return nmsEntity.b(DamageSource.n);
    }

    @Override
    public int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.bU.k();
    }

    @Override
    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    @Override
    public int getNewEntityId(boolean increment) {
        try {
            Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("c");
            entityCounter.setAccessible(true);
            AtomicInteger atomicInteger = (AtomicInteger)entityCounter.get(null);
            if (increment) {
                return atomicInteger.incrementAndGet();
            }
            return atomicInteger.get();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().b;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        Optional optional = EntityTypes.a((String)entityName.toLowerCase(Locale.ROOT));
        if (optional.isPresent()) {
            net.minecraft.world.entity.Entity entity;
            EntityTypes entityType = (EntityTypes)optional.get();
            WorldServer world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityType == EntityTypes.bn) {
                WrappedGameProfile gameProfile = ReflectionManagerAbstract.getGameProfile(new UUID(0L, 0L), "Steve");
                entity = new EntityPlayer((MinecraftServer)this.getMinecraftServer(), world, (GameProfile)gameProfile.getHandle(), null);
            } else {
                entity = entityType.a((net.minecraft.world.level.World)world);
            }
            entity.e(1.0, 1.0, 1.0);
            entity.e(0.0, 0.0, 0.0);
            return entity;
        }
        return null;
    }

    public MobEffectList getMobEffectList(int id) {
        return MobEffectList.a((int)id);
    }

    public MobEffect createMobEffect(PotionEffect effect) {
        return this.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public MobEffect createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        return new MobEffect(this.getMobEffectList(id), duration, amplification, ambient, particles);
    }

    public AxisAlignedBB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().cy();
    }

    @Override
    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).d - this.getBoundingBox((Entity)entity).a;
    }

    @Override
    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).e - this.getBoundingBox((Entity)entity).b;
    }

    @Override
    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).f - this.getBoundingBox((Entity)entity).c;
    }

    public EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).f();
    }

    @Override
    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    @Override
    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    @Override
    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public SoundEffect getCraftSound(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound);
    }

    public EntityTrackerEntry getEntityTrackerEntry(Entity target) throws Exception {
        WorldServer world = ((CraftWorld)target.getWorld()).getHandle();
        ChunkProviderServer chunkSource = world.k();
        PlayerChunkMap chunkMap = chunkSource.a;
        Int2ObjectMap entityMap = chunkMap.K;
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        Field field = PlayerChunkMap.EntityTracker.class.getDeclaredField("b");
        field.setAccessible(true);
        return (EntityTrackerEntry)field.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    @Override
    public String getEnumArt(Art art) {
        return IRegistry.ac.b((Object)((PaintingVariant)CraftArt.BukkitToNotch((Art)art).a())).a();
    }

    public net.minecraft.core.BlockPosition getBlockPosition(int x, int y, int z) {
        return new net.minecraft.core.BlockPosition(x, y, z);
    }

    public EnumDirection getEnumDirection(int direction) {
        return EnumDirection.b((int)direction);
    }

    @Override
    public PacketContainer getTabListPacket(String displayName, WrappedGameProfile gameProfile, EnumWrappers.PlayerInfoAction action, boolean nameVisible) {
        PacketPlayOutPlayerInfo.PlayerInfoData entry = new PacketPlayOutPlayerInfo.PlayerInfoData((GameProfile)gameProfile.getHandle(), 0, EnumGamemode.a, (IChatBaseComponent)IChatBaseComponent.b((String)displayName), null);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        StructureModifier modifier = packet.getModifier();
        modifier.write(0, (Object)PacketPlayOutPlayerInfo.EnumPlayerInfoAction.valueOf((String)action.name()));
        modifier.write(1, Collections.singletonList(entry));
        return packet;
    }

    @Override
    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    @Override
    public double getPing(Player player) {
        return player.getPing();
    }

    @Override
    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntitySize dimensions = nmsEntity.a(EntityPose.a);
        return new float[]{dimensions.a, nmsEntity.cA()};
    }

    @Override
    public WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        DedicatedServer minecraftServer = this.getMinecraftServer();
        MinecraftSessionService sessionService = minecraftServer.am();
        return WrappedGameProfile.fromHandle((Object)sessionService.fillProfileProperties((GameProfile)gameProfile.getHandle(), true));
    }

    @Override
    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            Method method = EntityLiving.class.getDeclaredMethod("eC", new Class[0]);
            method.setAccessible(true);
            return (Float)method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void injectCallback(String playername, ProfileLookupCallback callback) {
        Agent agent = Agent.MINECRAFT;
        this.getMinecraftServer().ao().findProfilesByNames(new String[]{playername}, agent, callback);
    }

    @Override
    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    @Override
    public Enum getSoundCategory(String category) {
        return (Enum)Arrays.stream(SoundCategory.values()).filter(soundSource -> category.equalsIgnoreCase(soundSource.a())).findAny().get();
    }

    @Override
    public Enum createEnumItemSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return EnumItemSlot.a;
            }
            case OFF_HAND: {
                return EnumItemSlot.b;
            }
            case FEET: {
                return EnumItemSlot.c;
            }
            case LEGS: {
                return EnumItemSlot.d;
            }
            case CHEST: {
                return EnumItemSlot.e;
            }
            case HEAD: {
                return EnumItemSlot.f;
            }
        }
        return null;
    }

    @Override
    public Object getSoundString(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound).a().toString();
    }

    @Override
    public Optional<?> convertOptional(Object val) {
        if (val instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)val;
            return Optional.of(this.getBlockPosition(pos.getX(), pos.getY(), pos.getZ()));
        }
        if (val instanceof WrappedBlockData) {
            Object obj = ((WrappedBlockData)val).getHandle();
            return Optional.of(obj);
        }
        if (val instanceof ItemStack) {
            net.minecraft.world.item.ItemStack obj = this.getNmsItem((ItemStack)val);
            return Optional.of(obj);
        }
        if (val instanceof WrappedChatComponent) {
            Object obj = ((WrappedChatComponent)val).getHandle();
            return Optional.of(obj);
        }
        return Optional.of(val);
    }

    public Vector3f convertVec3(Object object) {
        if (object instanceof Vector3F) {
            Vector3F vector3F = (Vector3F)object;
            return new Vector3f(vector3F.getX(), vector3F.getY(), vector3F.getZ());
        }
        if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            return new Vector3f((float)eulerAngle.getX(), (float)eulerAngle.getY(), (float)eulerAngle.getZ());
        }
        return null;
    }

    public EnumDirection convertDirection(EnumWrappers.Direction direction) {
        return EnumDirection.a((int)direction.ordinal());
    }

    @Override
    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    @Override
    public String getItemName(Material material) {
        return IRegistry.Y.b((Object)CraftMagicNumbers.getItem((Material)material)).a();
    }

    public net.minecraft.world.item.ItemStack getNmsItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    public VillagerData getNmsVillagerData(Villager.Type villagerType, Villager.Profession villagerProfession) {
        VillagerType nmsVillagerType = (VillagerType)IRegistry.ao.a(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerType.getKey()));
        VillagerProfession nmsVillagerProfession = (VillagerProfession)IRegistry.ap.a(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerProfession.getKey()));
        return new VillagerData(nmsVillagerType, nmsVillagerProfession, 1);
    }

    public VillagerType getVillagerType(Villager.Type type) {
        return (VillagerType)IRegistry.ao.a(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey()));
    }

    public VillagerProfession getVillagerProfession(Villager.Profession profession) {
        return (VillagerProfession)IRegistry.ap.a(CraftNamespacedKey.toMinecraft((NamespacedKey)profession.getKey()));
    }

    public <T> DataWatcher.Item<T> createDataWatcherItem(WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject, T metaItem) {
        return new DataWatcher.Item((DataWatcherObject)wrappedDataWatcherObject.getHandle(), metaItem);
    }

    @Deprecated
    public SoundEffect createSoundEffect(String minecraftKey) {
        return new SoundEffect(new MinecraftKey(minecraftKey));
    }

    public MinecraftKey createMinecraftKey(String name) {
        return new MinecraftKey(name);
    }

    public Vec3D getVec3D(Vector vector) {
        return new Vec3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    @Override
    public Object registerEntityType(NamespacedKey key) {
        EntityTypes newEntity = new EntityTypes(null, null, false, false, false, false, null, null, 0, 0);
        IRegistry.a((IRegistry)IRegistry.X, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.g();
        return newEntity;
    }

    @Override
    public int getEntityTypeId(Object entityTypes) {
        EntityTypes entityType = (EntityTypes)entityTypes;
        return IRegistry.X.a((Object)entityType);
    }

    @Override
    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    @Override
    public Object getEntityType(NamespacedKey name) {
        return IRegistry.X.a(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    @Override
    public Object getNmsEntityPose(String enumPose) {
        return EntityPose.valueOf((String)enumPose);
    }

    @Override
    public int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.i((IBlockData)state);
    }

    @Override
    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.i((IBlockData)block.m());
    }

    @Override
    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.a((int)id));
    }

    @Override
    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.a((int)id).b()));
    }

    public WorldServer getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    @Override
    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_19_R1.inventory.CraftMetaItem$SerializableMeta");
            Method deserialize = aClass.getDeclaredMethod("deserialize", Map.class);
            Object itemMeta = deserialize.invoke(null, meta);
            return (ItemMeta)itemMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object convertInvalidMeta(Object value) {
        if (value instanceof Frog.Variant) {
            return this.getFrogVariant((Frog.Variant)value);
        }
        if (value instanceof Cat.Type) {
            return this.getCatVariant((Cat.Type)value);
        }
        if (value instanceof Art) {
            return IRegistry.ac.h(this.getArtVariant((Art)value));
        }
        return value;
    }

    private FrogVariant getFrogVariant(Frog.Variant variant) {
        switch (variant) {
            case COLD: {
                return FrogVariant.c;
            }
            case WARM: {
                return FrogVariant.b;
            }
            case TEMPERATE: {
                return FrogVariant.a;
            }
        }
        return null;
    }

    private CatVariant getCatVariant(Cat.Type type) {
        switch (type) {
            case TABBY: {
                return CatVariant.a;
            }
            case BLACK: {
                return CatVariant.b;
            }
            case RED: {
                return CatVariant.c;
            }
            case SIAMESE: {
                return CatVariant.d;
            }
            case BRITISH_SHORTHAIR: {
                return CatVariant.e;
            }
            case CALICO: {
                return CatVariant.f;
            }
            case PERSIAN: {
                return CatVariant.g;
            }
            case RAGDOLL: {
                return CatVariant.h;
            }
            case WHITE: {
                return CatVariant.i;
            }
            case JELLIE: {
                return CatVariant.j;
            }
            case ALL_BLACK: {
                return CatVariant.k;
            }
        }
        return null;
    }

    private ResourceKey<PaintingVariant> getArtVariant(Art art) {
        switch (art) {
            case KEBAB: {
                return PaintingVariants.a;
            }
            case AZTEC: {
                return PaintingVariants.b;
            }
            case ALBAN: {
                return PaintingVariants.c;
            }
            case AZTEC2: {
                return PaintingVariants.d;
            }
            case BOMB: {
                return PaintingVariants.e;
            }
            case PLANT: {
                return PaintingVariants.f;
            }
            case WASTELAND: {
                return PaintingVariants.g;
            }
            case POOL: {
                return PaintingVariants.h;
            }
            case COURBET: {
                return PaintingVariants.i;
            }
            case SEA: {
                return PaintingVariants.j;
            }
            case SUNSET: {
                return PaintingVariants.k;
            }
            case CREEBET: {
                return PaintingVariants.l;
            }
            case WANDERER: {
                return PaintingVariants.m;
            }
            case GRAHAM: {
                return PaintingVariants.n;
            }
            case MATCH: {
                return PaintingVariants.o;
            }
            case BUST: {
                return PaintingVariants.p;
            }
            case STAGE: {
                return PaintingVariants.q;
            }
            case VOID: {
                return PaintingVariants.r;
            }
            case SKULL_AND_ROSES: {
                return PaintingVariants.s;
            }
            case WITHER: {
                return PaintingVariants.t;
            }
            case FIGHTERS: {
                return PaintingVariants.u;
            }
            case POINTER: {
                return PaintingVariants.v;
            }
            case PIGSCENE: {
                return PaintingVariants.w;
            }
            case BURNING_SKULL: {
                return PaintingVariants.x;
            }
            case SKELETON: {
                return PaintingVariants.y;
            }
            case DONKEY_KONG: {
                return PaintingVariants.z;
            }
            case EARTH: {
                return PaintingVariants.A;
            }
            case WIND: {
                return PaintingVariants.B;
            }
            case WATER: {
                return PaintingVariants.C;
            }
            case FIRE: {
                return PaintingVariants.D;
            }
        }
        return null;
    }
}

